/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AggregateRating;
import com.google.schemaorg.core.AlignmentObject;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.Audience;
import com.google.schemaorg.core.AudioObject;
import com.google.schemaorg.core.Boolean;
import com.google.schemaorg.core.Comment;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.CreativeWorkImpl;
import com.google.schemaorg.core.Duration;
import com.google.schemaorg.core.Event;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.InteractionCounter;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.MediaObject;
import com.google.schemaorg.core.MusicAlbum;
import com.google.schemaorg.core.MusicComposition;
import com.google.schemaorg.core.MusicGroup;
import com.google.schemaorg.core.MusicPlaylist;
import com.google.schemaorg.core.MusicRecording;
import com.google.schemaorg.core.Offer;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Person;
import com.google.schemaorg.core.Place;
import com.google.schemaorg.core.PublicationEvent;
import com.google.schemaorg.core.Review;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.VideoObject;
import com.google.schemaorg.core.datatype.Date;
import com.google.schemaorg.core.datatype.DateTime;
import com.google.schemaorg.core.datatype.Integer;
import com.google.schemaorg.core.datatype.Number;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MusicRecordingImpl
extends CreativeWorkImpl
implements MusicRecording {
    private static final ImmutableSet<String> PROPERTY_SET = MusicRecordingImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/about");
        builder.add((Object)"http://schema.org/accessibilityAPI");
        builder.add((Object)"http://schema.org/accessibilityControl");
        builder.add((Object)"http://schema.org/accessibilityFeature");
        builder.add((Object)"http://schema.org/accessibilityHazard");
        builder.add((Object)"http://schema.org/accountablePerson");
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/aggregateRating");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/alternativeHeadline");
        builder.add((Object)"http://schema.org/associatedMedia");
        builder.add((Object)"http://schema.org/audience");
        builder.add((Object)"http://schema.org/audio");
        builder.add((Object)"http://schema.org/author");
        builder.add((Object)"http://schema.org/award");
        builder.add((Object)"http://schema.org/awards");
        builder.add((Object)"http://schema.org/byArtist");
        builder.add((Object)"http://schema.org/character");
        builder.add((Object)"http://schema.org/citation");
        builder.add((Object)"http://schema.org/comment");
        builder.add((Object)"http://schema.org/commentCount");
        builder.add((Object)"http://schema.org/contentLocation");
        builder.add((Object)"http://schema.org/contentRating");
        builder.add((Object)"http://schema.org/contributor");
        builder.add((Object)"http://schema.org/copyrightHolder");
        builder.add((Object)"http://schema.org/copyrightYear");
        builder.add((Object)"http://schema.org/creator");
        builder.add((Object)"http://schema.org/dateCreated");
        builder.add((Object)"http://schema.org/dateModified");
        builder.add((Object)"http://schema.org/datePublished");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/discussionUrl");
        builder.add((Object)"http://schema.org/duration");
        builder.add((Object)"http://schema.org/editor");
        builder.add((Object)"http://schema.org/educationalAlignment");
        builder.add((Object)"http://schema.org/educationalUse");
        builder.add((Object)"http://schema.org/encoding");
        builder.add((Object)"http://schema.org/encodings");
        builder.add((Object)"http://schema.org/exampleOfWork");
        builder.add((Object)"http://schema.org/fileFormat");
        builder.add((Object)"http://schema.org/genre");
        builder.add((Object)"http://schema.org/hasPart");
        builder.add((Object)"http://schema.org/headline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/inAlbum");
        builder.add((Object)"http://schema.org/inLanguage");
        builder.add((Object)"http://schema.org/inPlaylist");
        builder.add((Object)"http://schema.org/interactionStatistic");
        builder.add((Object)"http://schema.org/interactivityType");
        builder.add((Object)"http://schema.org/isBasedOnUrl");
        builder.add((Object)"http://schema.org/isFamilyFriendly");
        builder.add((Object)"http://schema.org/isPartOf");
        builder.add((Object)"http://schema.org/isrcCode");
        builder.add((Object)"http://schema.org/keywords");
        builder.add((Object)"http://schema.org/learningResourceType");
        builder.add((Object)"http://schema.org/license");
        builder.add((Object)"http://schema.org/locationCreated");
        builder.add((Object)"http://schema.org/mainEntity");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/mentions");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/offers");
        builder.add((Object)"http://schema.org/position");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/producer");
        builder.add((Object)"http://schema.org/provider");
        builder.add((Object)"http://schema.org/publication");
        builder.add((Object)"http://schema.org/publisher");
        builder.add((Object)"http://schema.org/publishingPrinciples");
        builder.add((Object)"http://schema.org/recordedAt");
        builder.add((Object)"http://schema.org/recordingOf");
        builder.add((Object)"http://schema.org/releasedEvent");
        builder.add((Object)"http://schema.org/review");
        builder.add((Object)"http://schema.org/reviews");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/schemaVersion");
        builder.add((Object)"http://schema.org/sourceOrganization");
        builder.add((Object)"http://schema.org/text");
        builder.add((Object)"http://schema.org/thumbnailUrl");
        builder.add((Object)"http://schema.org/timeRequired");
        builder.add((Object)"http://schema.org/translator");
        builder.add((Object)"http://schema.org/typicalAgeRange");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.org/version");
        builder.add((Object)"http://schema.org/video");
        builder.add((Object)"http://schema.org/workExample");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MusicRecordingImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MusicRecording";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getByArtistList() {
        return this.getProperty("http://schema.org/byArtist");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDurationList() {
        return this.getProperty("http://schema.org/duration");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInAlbumList() {
        return this.getProperty("http://schema.org/inAlbum");
    }

    @Override
    public ImmutableList<SchemaOrgType> getInPlaylistList() {
        return this.getProperty("http://schema.org/inPlaylist");
    }

    @Override
    public ImmutableList<SchemaOrgType> getIsrcCodeList() {
        return this.getProperty("http://schema.org/isrcCode");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRecordingOfList() {
        return this.getProperty("http://schema.org/recordingOf");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MusicRecording.Builder>
    implements MusicRecording.Builder {
        BuilderImpl() {
        }

        @Override
        public MusicRecording.Builder addAbout(Thing value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/about", value);
        }

        @Override
        public MusicRecording.Builder addAbout(Thing.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/about", value.build());
        }

        @Override
        public MusicRecording.Builder addAbout(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/about", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAccessibilityAPI(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityAPI", value);
        }

        @Override
        public MusicRecording.Builder addAccessibilityAPI(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityAPI", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAccessibilityControl(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityControl", value);
        }

        @Override
        public MusicRecording.Builder addAccessibilityControl(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityControl", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAccessibilityFeature(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityFeature", value);
        }

        @Override
        public MusicRecording.Builder addAccessibilityFeature(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityFeature", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAccessibilityHazard(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityHazard", value);
        }

        @Override
        public MusicRecording.Builder addAccessibilityHazard(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accessibilityHazard", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAccountablePerson(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accountablePerson", value);
        }

        @Override
        public MusicRecording.Builder addAccountablePerson(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accountablePerson", value.build());
        }

        @Override
        public MusicRecording.Builder addAccountablePerson(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/accountablePerson", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAdditionalType(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MusicRecording.Builder addAdditionalType(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAggregateRating(AggregateRating value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/aggregateRating", value);
        }

        @Override
        public MusicRecording.Builder addAggregateRating(AggregateRating.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/aggregateRating", value.build());
        }

        @Override
        public MusicRecording.Builder addAggregateRating(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/aggregateRating", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAlternateName(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MusicRecording.Builder addAlternateName(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAlternativeHeadline(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/alternativeHeadline", value);
        }

        @Override
        public MusicRecording.Builder addAlternativeHeadline(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/alternativeHeadline", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAssociatedMedia(MediaObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/associatedMedia", value);
        }

        @Override
        public MusicRecording.Builder addAssociatedMedia(MediaObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/associatedMedia", value.build());
        }

        @Override
        public MusicRecording.Builder addAssociatedMedia(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/associatedMedia", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAudience(Audience value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audience", value);
        }

        @Override
        public MusicRecording.Builder addAudience(Audience.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audience", value.build());
        }

        @Override
        public MusicRecording.Builder addAudience(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audience", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAudio(AudioObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audio", value);
        }

        @Override
        public MusicRecording.Builder addAudio(AudioObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audio", value.build());
        }

        @Override
        public MusicRecording.Builder addAudio(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/audio", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAuthor(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicRecording.Builder addAuthor(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicRecording.Builder addAuthor(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/author", value);
        }

        @Override
        public MusicRecording.Builder addAuthor(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/author", value.build());
        }

        @Override
        public MusicRecording.Builder addAuthor(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/author", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAward(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/award", value);
        }

        @Override
        public MusicRecording.Builder addAward(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/award", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addAwards(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/awards", value);
        }

        @Override
        public MusicRecording.Builder addAwards(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/awards", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addByArtist(MusicGroup value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/byArtist", value);
        }

        @Override
        public MusicRecording.Builder addByArtist(MusicGroup.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/byArtist", value.build());
        }

        @Override
        public MusicRecording.Builder addByArtist(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/byArtist", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCharacter(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/character", value);
        }

        @Override
        public MusicRecording.Builder addCharacter(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/character", value.build());
        }

        @Override
        public MusicRecording.Builder addCharacter(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/character", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCitation(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicRecording.Builder addCitation(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/citation", value.build());
        }

        @Override
        public MusicRecording.Builder addCitation(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/citation", value);
        }

        @Override
        public MusicRecording.Builder addCitation(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/citation", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addComment(Comment value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/comment", value);
        }

        @Override
        public MusicRecording.Builder addComment(Comment.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/comment", value.build());
        }

        @Override
        public MusicRecording.Builder addComment(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/comment", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCommentCount(Integer value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/commentCount", value);
        }

        @Override
        public MusicRecording.Builder addCommentCount(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/commentCount", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addContentLocation(Place value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contentLocation", value);
        }

        @Override
        public MusicRecording.Builder addContentLocation(Place.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contentLocation", value.build());
        }

        @Override
        public MusicRecording.Builder addContentLocation(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contentLocation", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addContentRating(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contentRating", value);
        }

        @Override
        public MusicRecording.Builder addContentRating(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contentRating", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addContributor(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicRecording.Builder addContributor(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicRecording.Builder addContributor(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contributor", value);
        }

        @Override
        public MusicRecording.Builder addContributor(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contributor", value.build());
        }

        @Override
        public MusicRecording.Builder addContributor(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/contributor", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCopyrightHolder(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicRecording.Builder addCopyrightHolder(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicRecording.Builder addCopyrightHolder(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightHolder", value);
        }

        @Override
        public MusicRecording.Builder addCopyrightHolder(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightHolder", value.build());
        }

        @Override
        public MusicRecording.Builder addCopyrightHolder(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightHolder", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCopyrightYear(Number value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightYear", value);
        }

        @Override
        public MusicRecording.Builder addCopyrightYear(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/copyrightYear", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addCreator(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicRecording.Builder addCreator(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicRecording.Builder addCreator(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/creator", value);
        }

        @Override
        public MusicRecording.Builder addCreator(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/creator", value.build());
        }

        @Override
        public MusicRecording.Builder addCreator(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/creator", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDateCreated(Date value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicRecording.Builder addDateCreated(DateTime value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateCreated", value);
        }

        @Override
        public MusicRecording.Builder addDateCreated(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateCreated", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDateModified(Date value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicRecording.Builder addDateModified(DateTime value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateModified", value);
        }

        @Override
        public MusicRecording.Builder addDateModified(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/dateModified", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDatePublished(Date value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/datePublished", value);
        }

        @Override
        public MusicRecording.Builder addDatePublished(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/datePublished", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDescription(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MusicRecording.Builder addDescription(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDiscussionUrl(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/discussionUrl", value);
        }

        @Override
        public MusicRecording.Builder addDiscussionUrl(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/discussionUrl", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDuration(Duration value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/duration", value);
        }

        @Override
        public MusicRecording.Builder addDuration(Duration.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/duration", value.build());
        }

        @Override
        public MusicRecording.Builder addDuration(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/duration", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addEditor(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/editor", value);
        }

        @Override
        public MusicRecording.Builder addEditor(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/editor", value.build());
        }

        @Override
        public MusicRecording.Builder addEditor(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/editor", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addEducationalAlignment(AlignmentObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/educationalAlignment", value);
        }

        @Override
        public MusicRecording.Builder addEducationalAlignment(AlignmentObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/educationalAlignment", value.build());
        }

        @Override
        public MusicRecording.Builder addEducationalAlignment(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/educationalAlignment", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addEducationalUse(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/educationalUse", value);
        }

        @Override
        public MusicRecording.Builder addEducationalUse(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/educationalUse", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addEncoding(MediaObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encoding", value);
        }

        @Override
        public MusicRecording.Builder addEncoding(MediaObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encoding", value.build());
        }

        @Override
        public MusicRecording.Builder addEncoding(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encoding", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addEncodings(MediaObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encodings", value);
        }

        @Override
        public MusicRecording.Builder addEncodings(MediaObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encodings", value.build());
        }

        @Override
        public MusicRecording.Builder addEncodings(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/encodings", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addExampleOfWork(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/exampleOfWork", value);
        }

        @Override
        public MusicRecording.Builder addExampleOfWork(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/exampleOfWork", value.build());
        }

        @Override
        public MusicRecording.Builder addExampleOfWork(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/exampleOfWork", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addFileFormat(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/fileFormat", value);
        }

        @Override
        public MusicRecording.Builder addFileFormat(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/fileFormat", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addGenre(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicRecording.Builder addGenre(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/genre", value);
        }

        @Override
        public MusicRecording.Builder addGenre(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/genre", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addHasPart(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/hasPart", value);
        }

        @Override
        public MusicRecording.Builder addHasPart(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/hasPart", value.build());
        }

        @Override
        public MusicRecording.Builder addHasPart(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/hasPart", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addHeadline(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/headline", value);
        }

        @Override
        public MusicRecording.Builder addHeadline(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/headline", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addImage(ImageObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicRecording.Builder addImage(ImageObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MusicRecording.Builder addImage(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MusicRecording.Builder addImage(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addInAlbum(MusicAlbum value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inAlbum", value);
        }

        @Override
        public MusicRecording.Builder addInAlbum(MusicAlbum.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inAlbum", value.build());
        }

        @Override
        public MusicRecording.Builder addInAlbum(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inAlbum", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addInLanguage(Language value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicRecording.Builder addInLanguage(Language.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inLanguage", value.build());
        }

        @Override
        public MusicRecording.Builder addInLanguage(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inLanguage", value);
        }

        @Override
        public MusicRecording.Builder addInLanguage(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inLanguage", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addInPlaylist(MusicPlaylist value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inPlaylist", value);
        }

        @Override
        public MusicRecording.Builder addInPlaylist(MusicPlaylist.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inPlaylist", value.build());
        }

        @Override
        public MusicRecording.Builder addInPlaylist(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/inPlaylist", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addInteractionStatistic(InteractionCounter value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/interactionStatistic", value);
        }

        @Override
        public MusicRecording.Builder addInteractionStatistic(InteractionCounter.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/interactionStatistic", value.build());
        }

        @Override
        public MusicRecording.Builder addInteractionStatistic(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/interactionStatistic", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addInteractivityType(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/interactivityType", value);
        }

        @Override
        public MusicRecording.Builder addInteractivityType(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/interactivityType", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addIsBasedOnUrl(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isBasedOnUrl", value);
        }

        @Override
        public MusicRecording.Builder addIsBasedOnUrl(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isBasedOnUrl", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addIsFamilyFriendly(Boolean value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isFamilyFriendly", value);
        }

        @Override
        public MusicRecording.Builder addIsFamilyFriendly(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isFamilyFriendly", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addIsPartOf(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isPartOf", value);
        }

        @Override
        public MusicRecording.Builder addIsPartOf(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isPartOf", value.build());
        }

        @Override
        public MusicRecording.Builder addIsPartOf(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isPartOf", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addIsrcCode(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isrcCode", value);
        }

        @Override
        public MusicRecording.Builder addIsrcCode(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/isrcCode", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addKeywords(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/keywords", value);
        }

        @Override
        public MusicRecording.Builder addKeywords(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/keywords", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addLearningResourceType(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/learningResourceType", value);
        }

        @Override
        public MusicRecording.Builder addLearningResourceType(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/learningResourceType", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addLicense(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicRecording.Builder addLicense(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/license", value.build());
        }

        @Override
        public MusicRecording.Builder addLicense(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/license", value);
        }

        @Override
        public MusicRecording.Builder addLicense(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/license", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addLocationCreated(Place value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/locationCreated", value);
        }

        @Override
        public MusicRecording.Builder addLocationCreated(Place.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/locationCreated", value.build());
        }

        @Override
        public MusicRecording.Builder addLocationCreated(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/locationCreated", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addMainEntity(Thing value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntity", value);
        }

        @Override
        public MusicRecording.Builder addMainEntity(Thing.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntity", value.build());
        }

        @Override
        public MusicRecording.Builder addMainEntity(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntity", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addMainEntityOfPage(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicRecording.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MusicRecording.Builder addMainEntityOfPage(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MusicRecording.Builder addMainEntityOfPage(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addMentions(Thing value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mentions", value);
        }

        @Override
        public MusicRecording.Builder addMentions(Thing.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mentions", value.build());
        }

        @Override
        public MusicRecording.Builder addMentions(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/mentions", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addName(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MusicRecording.Builder addName(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addOffers(Offer value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/offers", value);
        }

        @Override
        public MusicRecording.Builder addOffers(Offer.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/offers", value.build());
        }

        @Override
        public MusicRecording.Builder addOffers(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/offers", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPosition(Integer value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicRecording.Builder addPosition(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/position", value);
        }

        @Override
        public MusicRecording.Builder addPosition(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/position", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPotentialAction(Action value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MusicRecording.Builder addPotentialAction(Action.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MusicRecording.Builder addPotentialAction(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addProducer(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicRecording.Builder addProducer(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicRecording.Builder addProducer(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/producer", value);
        }

        @Override
        public MusicRecording.Builder addProducer(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/producer", value.build());
        }

        @Override
        public MusicRecording.Builder addProducer(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/producer", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addProvider(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicRecording.Builder addProvider(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicRecording.Builder addProvider(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/provider", value);
        }

        @Override
        public MusicRecording.Builder addProvider(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/provider", value.build());
        }

        @Override
        public MusicRecording.Builder addProvider(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/provider", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPublication(PublicationEvent value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publication", value);
        }

        @Override
        public MusicRecording.Builder addPublication(PublicationEvent.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publication", value.build());
        }

        @Override
        public MusicRecording.Builder addPublication(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publication", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPublisher(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicRecording.Builder addPublisher(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicRecording.Builder addPublisher(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publisher", value);
        }

        @Override
        public MusicRecording.Builder addPublisher(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publisher", value.build());
        }

        @Override
        public MusicRecording.Builder addPublisher(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publisher", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPublishingPrinciples(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publishingPrinciples", value);
        }

        @Override
        public MusicRecording.Builder addPublishingPrinciples(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/publishingPrinciples", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addRecordedAt(Event value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordedAt", value);
        }

        @Override
        public MusicRecording.Builder addRecordedAt(Event.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordedAt", value.build());
        }

        @Override
        public MusicRecording.Builder addRecordedAt(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordedAt", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addRecordingOf(MusicComposition value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordingOf", value);
        }

        @Override
        public MusicRecording.Builder addRecordingOf(MusicComposition.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordingOf", value.build());
        }

        @Override
        public MusicRecording.Builder addRecordingOf(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/recordingOf", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addReleasedEvent(PublicationEvent value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/releasedEvent", value);
        }

        @Override
        public MusicRecording.Builder addReleasedEvent(PublicationEvent.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/releasedEvent", value.build());
        }

        @Override
        public MusicRecording.Builder addReleasedEvent(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/releasedEvent", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addReview(Review value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/review", value);
        }

        @Override
        public MusicRecording.Builder addReview(Review.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/review", value.build());
        }

        @Override
        public MusicRecording.Builder addReview(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/review", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addReviews(Review value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/reviews", value);
        }

        @Override
        public MusicRecording.Builder addReviews(Review.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/reviews", value.build());
        }

        @Override
        public MusicRecording.Builder addReviews(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/reviews", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addSameAs(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MusicRecording.Builder addSameAs(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addSchemaVersion(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicRecording.Builder addSchemaVersion(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/schemaVersion", value);
        }

        @Override
        public MusicRecording.Builder addSchemaVersion(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/schemaVersion", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addSourceOrganization(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/sourceOrganization", value);
        }

        @Override
        public MusicRecording.Builder addSourceOrganization(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/sourceOrganization", value.build());
        }

        @Override
        public MusicRecording.Builder addSourceOrganization(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/sourceOrganization", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addText(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/text", value);
        }

        @Override
        public MusicRecording.Builder addText(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/text", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addThumbnailUrl(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/thumbnailUrl", value);
        }

        @Override
        public MusicRecording.Builder addThumbnailUrl(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/thumbnailUrl", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addTimeRequired(Duration value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/timeRequired", value);
        }

        @Override
        public MusicRecording.Builder addTimeRequired(Duration.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/timeRequired", value.build());
        }

        @Override
        public MusicRecording.Builder addTimeRequired(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/timeRequired", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addTranslator(Organization value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicRecording.Builder addTranslator(Organization.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicRecording.Builder addTranslator(Person value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/translator", value);
        }

        @Override
        public MusicRecording.Builder addTranslator(Person.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/translator", value.build());
        }

        @Override
        public MusicRecording.Builder addTranslator(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/translator", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addTypicalAgeRange(Text value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/typicalAgeRange", value);
        }

        @Override
        public MusicRecording.Builder addTypicalAgeRange(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/typicalAgeRange", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addUrl(URL value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MusicRecording.Builder addUrl(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addVersion(Number value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/version", value);
        }

        @Override
        public MusicRecording.Builder addVersion(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/version", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addVideo(VideoObject value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/video", value);
        }

        @Override
        public MusicRecording.Builder addVideo(VideoObject.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/video", value.build());
        }

        @Override
        public MusicRecording.Builder addVideo(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/video", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addWorkExample(CreativeWork value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/workExample", value);
        }

        @Override
        public MusicRecording.Builder addWorkExample(CreativeWork.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/workExample", value.build());
        }

        @Override
        public MusicRecording.Builder addWorkExample(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.org/workExample", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addDetailedDescription(Article value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MusicRecording.Builder addDetailedDescription(Article.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MusicRecording.Builder addDetailedDescription(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MusicRecording.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MusicRecording.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MusicRecording.Builder addPopularityScore(String value) {
            return (MusicRecording.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MusicRecording build() {
            return new MusicRecordingImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

