/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalEntity;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalRiskCalculator;
import com.google.schemaorg.core.MedicalRiskEstimatorImpl;
import com.google.schemaorg.core.MedicalRiskFactor;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalRiskCalculatorImpl
extends MedicalRiskEstimatorImpl
implements MedicalRiskCalculator {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalRiskCalculatorImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/estimatesRiskOf");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/includedRiskFactor");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalRiskCalculatorImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalRiskCalculator";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalRiskCalculator.Builder>
    implements MedicalRiskCalculator.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalRiskCalculator.Builder addAdditionalType(URL value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addAdditionalType(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addAlternateName(Text value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addAlternateName(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addCode(MedicalCode value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addCode(MedicalCode.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addCode(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addDescription(Text value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addDescription(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addEstimatesRiskOf(MedicalEntity value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addEstimatesRiskOf(MedicalEntity.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addEstimatesRiskOf(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/estimatesRiskOf", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addGuideline(MedicalGuideline value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addGuideline(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addImage(ImageObject value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addImage(ImageObject.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addImage(URL value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addImage(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addIncludedRiskFactor(MedicalRiskFactor value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/includedRiskFactor", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addIncludedRiskFactor(MedicalRiskFactor.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/includedRiskFactor", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addIncludedRiskFactor(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/includedRiskFactor", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addMainEntityOfPage(URL value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addMainEntityOfPage(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addMedicineSystem(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addName(Text value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addName(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addPotentialAction(Action value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addPotentialAction(Action.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addPotentialAction(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addRecognizingAuthority(Organization value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addRecognizingAuthority(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addRelevantSpecialty(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addSameAs(URL value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addSameAs(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addStudy(MedicalStudy value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addStudy(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addUrl(URL value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addUrl(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addDetailedDescription(Article value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addDetailedDescription(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalRiskCalculator.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalRiskCalculator.Builder addPopularityScore(String value) {
            return (MedicalRiskCalculator.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalRiskCalculator build() {
            return new MedicalRiskCalculatorImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

