/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgType;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.AnatomicalStructure;
import com.google.schemaorg.core.AnatomicalSystem;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.DDxElement;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.MedicalCause;
import com.google.schemaorg.core.MedicalCode;
import com.google.schemaorg.core.MedicalCondition;
import com.google.schemaorg.core.MedicalConditionStage;
import com.google.schemaorg.core.MedicalEntityImpl;
import com.google.schemaorg.core.MedicalGuideline;
import com.google.schemaorg.core.MedicalRiskFactor;
import com.google.schemaorg.core.MedicalSignOrSymptom;
import com.google.schemaorg.core.MedicalSpecialty;
import com.google.schemaorg.core.MedicalStudy;
import com.google.schemaorg.core.MedicalTest;
import com.google.schemaorg.core.MedicalTherapy;
import com.google.schemaorg.core.MedicineSystem;
import com.google.schemaorg.core.Organization;
import com.google.schemaorg.core.SuperficialAnatomy;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class MedicalConditionImpl
extends MedicalEntityImpl
implements MedicalCondition {
    private static final ImmutableSet<String> PROPERTY_SET = MedicalConditionImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/associatedAnatomy");
        builder.add((Object)"http://schema.org/cause");
        builder.add((Object)"http://schema.org/code");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/differentialDiagnosis");
        builder.add((Object)"http://schema.org/epidemiology");
        builder.add((Object)"http://schema.org/expectedPrognosis");
        builder.add((Object)"http://schema.org/guideline");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/medicineSystem");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/naturalProgression");
        builder.add((Object)"http://schema.org/pathophysiology");
        builder.add((Object)"http://schema.org/possibleComplication");
        builder.add((Object)"http://schema.org/possibleTreatment");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/primaryPrevention");
        builder.add((Object)"http://schema.org/recognizingAuthority");
        builder.add((Object)"http://schema.org/relevantSpecialty");
        builder.add((Object)"http://schema.org/riskFactor");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/secondaryPrevention");
        builder.add((Object)"http://schema.org/signOrSymptom");
        builder.add((Object)"http://schema.org/stage");
        builder.add((Object)"http://schema.org/study");
        builder.add((Object)"http://schema.org/subtype");
        builder.add((Object)"http://schema.org/typicalTest");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public MedicalConditionImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/MedicalCondition";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    @Override
    public ImmutableList<SchemaOrgType> getAssociatedAnatomyList() {
        return this.getProperty("http://schema.org/associatedAnatomy");
    }

    @Override
    public ImmutableList<SchemaOrgType> getCauseList() {
        return this.getProperty("http://schema.org/cause");
    }

    @Override
    public ImmutableList<SchemaOrgType> getDifferentialDiagnosisList() {
        return this.getProperty("http://schema.org/differentialDiagnosis");
    }

    @Override
    public ImmutableList<SchemaOrgType> getEpidemiologyList() {
        return this.getProperty("http://schema.org/epidemiology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getExpectedPrognosisList() {
        return this.getProperty("http://schema.org/expectedPrognosis");
    }

    @Override
    public ImmutableList<SchemaOrgType> getNaturalProgressionList() {
        return this.getProperty("http://schema.org/naturalProgression");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPathophysiologyList() {
        return this.getProperty("http://schema.org/pathophysiology");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPossibleComplicationList() {
        return this.getProperty("http://schema.org/possibleComplication");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPossibleTreatmentList() {
        return this.getProperty("http://schema.org/possibleTreatment");
    }

    @Override
    public ImmutableList<SchemaOrgType> getPrimaryPreventionList() {
        return this.getProperty("http://schema.org/primaryPrevention");
    }

    @Override
    public ImmutableList<SchemaOrgType> getRiskFactorList() {
        return this.getProperty("http://schema.org/riskFactor");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSecondaryPreventionList() {
        return this.getProperty("http://schema.org/secondaryPrevention");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSignOrSymptomList() {
        return this.getProperty("http://schema.org/signOrSymptom");
    }

    @Override
    public ImmutableList<SchemaOrgType> getStageList() {
        return this.getProperty("http://schema.org/stage");
    }

    @Override
    public ImmutableList<SchemaOrgType> getSubtypeList() {
        return this.getProperty("http://schema.org/subtype");
    }

    @Override
    public ImmutableList<SchemaOrgType> getTypicalTestList() {
        return this.getProperty("http://schema.org/typicalTest");
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<MedicalCondition.Builder>
    implements MedicalCondition.Builder {
        BuilderImpl() {
        }

        @Override
        public MedicalCondition.Builder addAdditionalType(URL value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public MedicalCondition.Builder addAdditionalType(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addAlternateName(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public MedicalCondition.Builder addAlternateName(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(AnatomicalStructure value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(AnatomicalStructure.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(AnatomicalSystem value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(AnatomicalSystem.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(SuperficialAnatomy value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value);
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(SuperficialAnatomy.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", value.build());
        }

        @Override
        public MedicalCondition.Builder addAssociatedAnatomy(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/associatedAnatomy", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addCause(MedicalCause value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/cause", value);
        }

        @Override
        public MedicalCondition.Builder addCause(MedicalCause.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/cause", value.build());
        }

        @Override
        public MedicalCondition.Builder addCause(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/cause", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addCode(MedicalCode value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/code", value);
        }

        @Override
        public MedicalCondition.Builder addCode(MedicalCode.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/code", value.build());
        }

        @Override
        public MedicalCondition.Builder addCode(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/code", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addDescription(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public MedicalCondition.Builder addDescription(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addDifferentialDiagnosis(DDxElement value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/differentialDiagnosis", value);
        }

        @Override
        public MedicalCondition.Builder addDifferentialDiagnosis(DDxElement.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/differentialDiagnosis", value.build());
        }

        @Override
        public MedicalCondition.Builder addDifferentialDiagnosis(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/differentialDiagnosis", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addEpidemiology(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/epidemiology", value);
        }

        @Override
        public MedicalCondition.Builder addEpidemiology(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/epidemiology", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addExpectedPrognosis(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/expectedPrognosis", value);
        }

        @Override
        public MedicalCondition.Builder addExpectedPrognosis(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/expectedPrognosis", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addGuideline(MedicalGuideline value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/guideline", value);
        }

        @Override
        public MedicalCondition.Builder addGuideline(MedicalGuideline.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/guideline", value.build());
        }

        @Override
        public MedicalCondition.Builder addGuideline(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/guideline", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addImage(ImageObject value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCondition.Builder addImage(ImageObject.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public MedicalCondition.Builder addImage(URL value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public MedicalCondition.Builder addImage(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addMainEntityOfPage(CreativeWork value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCondition.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public MedicalCondition.Builder addMainEntityOfPage(URL value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public MedicalCondition.Builder addMainEntityOfPage(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addMedicineSystem(MedicineSystem value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/medicineSystem", value);
        }

        @Override
        public MedicalCondition.Builder addMedicineSystem(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/medicineSystem", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addName(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public MedicalCondition.Builder addName(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addNaturalProgression(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/naturalProgression", value);
        }

        @Override
        public MedicalCondition.Builder addNaturalProgression(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/naturalProgression", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPathophysiology(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/pathophysiology", value);
        }

        @Override
        public MedicalCondition.Builder addPathophysiology(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/pathophysiology", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPossibleComplication(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/possibleComplication", value);
        }

        @Override
        public MedicalCondition.Builder addPossibleComplication(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/possibleComplication", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPossibleTreatment(MedicalTherapy value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/possibleTreatment", value);
        }

        @Override
        public MedicalCondition.Builder addPossibleTreatment(MedicalTherapy.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/possibleTreatment", value.build());
        }

        @Override
        public MedicalCondition.Builder addPossibleTreatment(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/possibleTreatment", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPotentialAction(Action value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public MedicalCondition.Builder addPotentialAction(Action.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public MedicalCondition.Builder addPotentialAction(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPrimaryPrevention(MedicalTherapy value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/primaryPrevention", value);
        }

        @Override
        public MedicalCondition.Builder addPrimaryPrevention(MedicalTherapy.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/primaryPrevention", value.build());
        }

        @Override
        public MedicalCondition.Builder addPrimaryPrevention(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/primaryPrevention", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addRecognizingAuthority(Organization value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/recognizingAuthority", value);
        }

        @Override
        public MedicalCondition.Builder addRecognizingAuthority(Organization.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/recognizingAuthority", value.build());
        }

        @Override
        public MedicalCondition.Builder addRecognizingAuthority(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/recognizingAuthority", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addRelevantSpecialty(MedicalSpecialty value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/relevantSpecialty", value);
        }

        @Override
        public MedicalCondition.Builder addRelevantSpecialty(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/relevantSpecialty", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addRiskFactor(MedicalRiskFactor value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/riskFactor", value);
        }

        @Override
        public MedicalCondition.Builder addRiskFactor(MedicalRiskFactor.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/riskFactor", value.build());
        }

        @Override
        public MedicalCondition.Builder addRiskFactor(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/riskFactor", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addSameAs(URL value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public MedicalCondition.Builder addSameAs(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addSecondaryPrevention(MedicalTherapy value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/secondaryPrevention", value);
        }

        @Override
        public MedicalCondition.Builder addSecondaryPrevention(MedicalTherapy.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/secondaryPrevention", value.build());
        }

        @Override
        public MedicalCondition.Builder addSecondaryPrevention(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/secondaryPrevention", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addSignOrSymptom(MedicalSignOrSymptom value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/signOrSymptom", value);
        }

        @Override
        public MedicalCondition.Builder addSignOrSymptom(MedicalSignOrSymptom.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/signOrSymptom", value.build());
        }

        @Override
        public MedicalCondition.Builder addSignOrSymptom(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/signOrSymptom", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addStage(MedicalConditionStage value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/stage", value);
        }

        @Override
        public MedicalCondition.Builder addStage(MedicalConditionStage.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/stage", value.build());
        }

        @Override
        public MedicalCondition.Builder addStage(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/stage", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addStudy(MedicalStudy value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/study", value);
        }

        @Override
        public MedicalCondition.Builder addStudy(MedicalStudy.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/study", value.build());
        }

        @Override
        public MedicalCondition.Builder addStudy(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/study", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addSubtype(Text value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/subtype", value);
        }

        @Override
        public MedicalCondition.Builder addSubtype(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/subtype", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addTypicalTest(MedicalTest value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/typicalTest", value);
        }

        @Override
        public MedicalCondition.Builder addTypicalTest(MedicalTest.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/typicalTest", value.build());
        }

        @Override
        public MedicalCondition.Builder addTypicalTest(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/typicalTest", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addUrl(URL value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public MedicalCondition.Builder addUrl(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addDetailedDescription(Article value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public MedicalCondition.Builder addDetailedDescription(Article.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public MedicalCondition.Builder addDetailedDescription(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public MedicalCondition.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public MedicalCondition.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public MedicalCondition.Builder addPopularityScore(String value) {
            return (MedicalCondition.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public MedicalCondition build() {
            return new MedicalConditionImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

