/*
 * Decompiled with CFR 0.152.
 */
package com.google.schemaorg.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.schemaorg.SchemaOrgTypeImpl;
import com.google.schemaorg.ValueType;
import com.google.schemaorg.core.Action;
import com.google.schemaorg.core.Article;
import com.google.schemaorg.core.CreativeWork;
import com.google.schemaorg.core.ImageObject;
import com.google.schemaorg.core.IntangibleImpl;
import com.google.schemaorg.core.Language;
import com.google.schemaorg.core.Thing;
import com.google.schemaorg.core.datatype.Text;
import com.google.schemaorg.core.datatype.URL;
import com.google.schemaorg.goog.PopularityScoreSpecification;

public class LanguageImpl
extends IntangibleImpl
implements Language {
    private static final ImmutableSet<String> PROPERTY_SET = LanguageImpl.initializePropertySet();

    private static ImmutableSet<String> initializePropertySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)"http://schema.org/additionalType");
        builder.add((Object)"http://schema.org/alternateName");
        builder.add((Object)"http://schema.org/description");
        builder.add((Object)"http://schema.org/image");
        builder.add((Object)"http://schema.org/mainEntityOfPage");
        builder.add((Object)"http://schema.org/name");
        builder.add((Object)"http://schema.org/potentialAction");
        builder.add((Object)"http://schema.org/sameAs");
        builder.add((Object)"http://schema.org/url");
        builder.add((Object)"http://schema.googleapis.com/detailedDescription");
        builder.add((Object)"http://schema.googleapis.com/popularityScore");
        return builder.build();
    }

    public LanguageImpl(Multimap<String, ValueType> properties, Multimap<String, Thing> reverseMap) {
        super(properties, reverseMap);
    }

    @Override
    public String getFullTypeName() {
        return "http://schema.org/Language";
    }

    @Override
    public boolean includesProperty(String property) {
        return PROPERTY_SET.contains((Object)("http://schema.org/" + property)) || PROPERTY_SET.contains((Object)("http://schema.googleapis.com/" + property)) || PROPERTY_SET.contains((Object)property);
    }

    static final class BuilderImpl
    extends SchemaOrgTypeImpl.BuilderImpl<Language.Builder>
    implements Language.Builder {
        BuilderImpl() {
        }

        @Override
        public Language.Builder addAdditionalType(URL value) {
            return (Language.Builder)this.addProperty("http://schema.org/additionalType", value);
        }

        @Override
        public Language.Builder addAdditionalType(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/additionalType", Text.of(value));
        }

        @Override
        public Language.Builder addAlternateName(Text value) {
            return (Language.Builder)this.addProperty("http://schema.org/alternateName", value);
        }

        @Override
        public Language.Builder addAlternateName(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/alternateName", Text.of(value));
        }

        @Override
        public Language.Builder addDescription(Text value) {
            return (Language.Builder)this.addProperty("http://schema.org/description", value);
        }

        @Override
        public Language.Builder addDescription(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/description", Text.of(value));
        }

        @Override
        public Language.Builder addImage(ImageObject value) {
            return (Language.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Language.Builder addImage(ImageObject.Builder value) {
            return (Language.Builder)this.addProperty("http://schema.org/image", value.build());
        }

        @Override
        public Language.Builder addImage(URL value) {
            return (Language.Builder)this.addProperty("http://schema.org/image", value);
        }

        @Override
        public Language.Builder addImage(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/image", Text.of(value));
        }

        @Override
        public Language.Builder addMainEntityOfPage(CreativeWork value) {
            return (Language.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Language.Builder addMainEntityOfPage(CreativeWork.Builder value) {
            return (Language.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value.build());
        }

        @Override
        public Language.Builder addMainEntityOfPage(URL value) {
            return (Language.Builder)this.addProperty("http://schema.org/mainEntityOfPage", value);
        }

        @Override
        public Language.Builder addMainEntityOfPage(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/mainEntityOfPage", Text.of(value));
        }

        @Override
        public Language.Builder addName(Text value) {
            return (Language.Builder)this.addProperty("http://schema.org/name", value);
        }

        @Override
        public Language.Builder addName(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/name", Text.of(value));
        }

        @Override
        public Language.Builder addPotentialAction(Action value) {
            return (Language.Builder)this.addProperty("http://schema.org/potentialAction", value);
        }

        @Override
        public Language.Builder addPotentialAction(Action.Builder value) {
            return (Language.Builder)this.addProperty("http://schema.org/potentialAction", value.build());
        }

        @Override
        public Language.Builder addPotentialAction(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/potentialAction", Text.of(value));
        }

        @Override
        public Language.Builder addSameAs(URL value) {
            return (Language.Builder)this.addProperty("http://schema.org/sameAs", value);
        }

        @Override
        public Language.Builder addSameAs(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/sameAs", Text.of(value));
        }

        @Override
        public Language.Builder addUrl(URL value) {
            return (Language.Builder)this.addProperty("http://schema.org/url", value);
        }

        @Override
        public Language.Builder addUrl(String value) {
            return (Language.Builder)this.addProperty("http://schema.org/url", Text.of(value));
        }

        @Override
        public Language.Builder addDetailedDescription(Article value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value);
        }

        @Override
        public Language.Builder addDetailedDescription(Article.Builder value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", value.build());
        }

        @Override
        public Language.Builder addDetailedDescription(String value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/detailedDescription", Text.of(value));
        }

        @Override
        public Language.Builder addPopularityScore(PopularityScoreSpecification value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value);
        }

        @Override
        public Language.Builder addPopularityScore(PopularityScoreSpecification.Builder value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", value.build());
        }

        @Override
        public Language.Builder addPopularityScore(String value) {
            return (Language.Builder)this.addProperty("http://schema.googleapis.com/popularityScore", Text.of(value));
        }

        @Override
        public Language build() {
            return new LanguageImpl((Multimap<String, ValueType>)this.properties, (Multimap<String, Thing>)this.reverseMap);
        }
    }
}

