/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.contrib.gtfs;

import java.time.LocalDate;
import org.matsim.api.core.v01.Scenario;
import org.matsim.contrib.gtfs.RunGTFS2MATSim;
import org.matsim.contrib.gtfs.TransitSchedulePostProcessTools;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.network.io.NetworkWriter;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.pt.transitSchedule.api.TransitScheduleWriter;
import org.matsim.vehicles.MatsimVehicleWriter;

public final class RunGTFS2MATSimExample {
    private RunGTFS2MATSimExample() {
    }

    public static void main(String[] args) {
        String gtfsZipFile = "";
        CoordinateTransformation ct = TransformationFactory.getCoordinateTransformation((String)"WGS84", (String)"EPSG:25833");
        LocalDate date = LocalDate.parse("2020-06-25");
        String scheduleFile = "transitSchedule.xml.gz";
        String networkFile = "network.xml.gz";
        String transitVehiclesFile = "transitVehicles.xml.gz";
        Scenario scenario = ScenarioUtils.createScenario((Config)ConfigUtils.createConfig());
        RunGTFS2MATSim.convertGTFSandAddToScenario(scenario, gtfsZipFile, date, ct, true);
        TransitSchedulePostProcessTools.copyLateDeparturesToStartOfDay(scenario.getTransitSchedule(), 86400.0, "copied", false);
        TransitSchedulePostProcessTools.copyEarlyDeparturesToFollowingNight(scenario.getTransitSchedule(), 21600.0, "copied");
        new NetworkWriter(scenario.getNetwork()).write(networkFile);
        new TransitScheduleWriter(scenario.getTransitSchedule()).writeFile(scheduleFile);
        new MatsimVehicleWriter(scenario.getTransitVehicles()).writeFile(transitVehiclesFile);
    }
}

