/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import java.util.Map;
import java.util.UUID;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.Tracker;

public class LegacySettingsPorter {
    static final String LEGACY_PREF_OPT_OUT = "matomo.optout";
    static final String LEGACY_PREF_USER_ID = "tracker.userid";
    static final String LEGACY_PREF_FIRST_VISIT = "tracker.firstvisit";
    static final String LEGACY_PREF_VISITCOUNT = "tracker.visitcount";
    static final String LEGACY_PREF_PREV_VISIT = "tracker.previousvisit";
    private final SharedPreferences mLegacyPrefs;

    public LegacySettingsPorter(@NonNull Matomo matomo) {
        this.mLegacyPrefs = matomo.getPreferences();
    }

    public void port(Tracker tracker) {
        SharedPreferences newSettings = tracker.getPreferences();
        if (this.mLegacyPrefs.getBoolean(LEGACY_PREF_OPT_OUT, false)) {
            newSettings.edit().putBoolean("tracker.optout", true).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_OPT_OUT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_USER_ID)) {
            newSettings.edit().putString(LEGACY_PREF_USER_ID, this.mLegacyPrefs.getString(LEGACY_PREF_USER_ID, UUID.randomUUID().toString())).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_USER_ID).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_FIRST_VISIT)) {
            newSettings.edit().putLong(LEGACY_PREF_FIRST_VISIT, this.mLegacyPrefs.getLong(LEGACY_PREF_FIRST_VISIT, -1L)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_FIRST_VISIT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_VISITCOUNT)) {
            newSettings.edit().putLong(LEGACY_PREF_VISITCOUNT, (long)this.mLegacyPrefs.getInt(LEGACY_PREF_VISITCOUNT, 0)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_VISITCOUNT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_PREV_VISIT)) {
            newSettings.edit().putLong(LEGACY_PREF_PREV_VISIT, this.mLegacyPrefs.getLong(LEGACY_PREF_PREV_VISIT, -1L)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_PREV_VISIT).apply();
        }
        for (Map.Entry oldEntry : this.mLegacyPrefs.getAll().entrySet()) {
            if (!((String)oldEntry.getKey()).startsWith("downloaded:")) continue;
            newSettings.edit().putBoolean((String)oldEntry.getKey(), true).apply();
            this.mLegacyPrefs.edit().remove((String)oldEntry.getKey()).apply();
        }
    }
}

