/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.dispatcher.Event;
import org.matomo.sdk.dispatcher.EventDiskCache;
import timber.log.Timber;

public class EventCache {
    private static final String TAG = Matomo.tag(EventCache.class);
    private final LinkedBlockingDeque<Event> mQueue = new LinkedBlockingDeque();
    private final EventDiskCache mDiskCache;

    public EventCache(EventDiskCache cache) {
        this.mDiskCache = cache;
    }

    public void add(Event event) {
        this.mQueue.add(event);
    }

    public void drainTo(List<Event> drainedEvents) {
        this.mQueue.drainTo(drainedEvents);
    }

    public void clear() {
        this.mDiskCache.uncache();
        this.mQueue.clear();
    }

    public boolean isEmpty() {
        return this.mQueue.isEmpty() && this.mDiskCache.isEmpty();
    }

    public boolean updateState(boolean online) {
        if (online) {
            List<Event> uncache = this.mDiskCache.uncache();
            ListIterator<Event> it = uncache.listIterator(uncache.size());
            while (it.hasPrevious()) {
                this.mQueue.offerFirst(it.previous());
            }
            Timber.tag((String)TAG).d("Switched state to ONLINE, uncached %d events from disk.", new Object[]{uncache.size()});
        } else if (!this.mQueue.isEmpty()) {
            ArrayList<Event> toCache = new ArrayList<Event>();
            this.mQueue.drainTo(toCache);
            this.mDiskCache.cache(toCache);
            Timber.tag((String)TAG).d("Switched state to OFFLINE, caching %d events to disk.", new Object[]{toCache.size()});
        }
        return online && !this.mQueue.isEmpty();
    }

    public void requeue(List<Event> events) {
        for (Event e : events) {
            this.mQueue.offerFirst(e);
        }
    }
}

