/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.json.JSONObject;

public class Packet {
    private final String mTargetURL;
    private final JSONObject mPostData;
    private final long mTimeStamp;
    private final int mEventCount;

    public Packet(String targetURL) {
        this(targetURL, null, 1);
    }

    public Packet(String targetURL, @Nullable JSONObject JSONObject2, int eventCount) {
        this.mTargetURL = targetURL;
        this.mPostData = JSONObject2;
        this.mEventCount = eventCount;
        this.mTimeStamp = System.currentTimeMillis();
    }

    public String getTargetURL() {
        return this.mTargetURL;
    }

    @Nullable
    public JSONObject getPostData() {
        return this.mPostData;
    }

    public long getTimeStamp() {
        return this.mTimeStamp;
    }

    public int getEventCount() {
        return this.mEventCount;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Packet(");
        if (this.mPostData != null) {
            sb.append("type=POST, data=").append(this.mPostData);
        } else {
            sb.append("type=GET, data=").append(this.mTargetURL);
        }
        return sb.append(")").toString();
    }
}

