/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.tools;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class UrlHelper {
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static List<Pair<String, String>> parse(@NonNull URI uri, @Nullable String encoding) {
        List<Pair<String, String>> result = Collections.emptyList();
        String query = uri.getRawQuery();
        if (query != null && !query.isEmpty()) {
            result = new ArrayList<Pair<String, String>>();
            UrlHelper.parse(result, new Scanner(query), encoding);
        }
        return result;
    }

    public static void parse(@NonNull List<Pair<String, String>> parameters, @NonNull Scanner scanner, @Nullable String encoding) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String[] nameValue = scanner.next().split(NAME_VALUE_SEPARATOR);
            if (nameValue.length == 0 || nameValue.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String name = UrlHelper.decode(nameValue[0], encoding);
            String value = null;
            if (nameValue.length == 2) {
                value = UrlHelper.decode(nameValue[1], encoding);
            }
            parameters.add((Pair<String, String>)new Pair((Object)name, (Object)value));
        }
    }

    private static String decode(@NonNull String content, @Nullable String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

