/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.dispatcher.Packet;
import org.matomo.sdk.dispatcher.PacketSender;
import timber.log.Timber;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/matomo/sdk/dispatcher/DefaultPacketSender;", "Lorg/matomo/sdk/dispatcher/PacketSender;", "<init>", "()V", "mTimeout", "", "mGzip", "", "send", "packet", "Lorg/matomo/sdk/dispatcher/Packet;", "setTimeout", "", "timeout", "setGzipData", "gzip", "Companion", "tracker_release"})
@SourceDebugExtension(value={"SMAP\nDefaultPacketSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPacketSender.kt\norg/matomo/sdk/dispatcher/DefaultPacketSender\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class DefaultPacketSender
implements PacketSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long mTimeout = 5000L;
    private boolean mGzip;
    @NotNull
    private static final String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        HttpURLConnection urlConnection = null;
        try {
            Object writer;
            URLConnection uRLConnection = new URL(packet.getTargetURL()).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            urlConnection = (HttpURLConnection)uRLConnection;
            Object[] objectArray = new Object[]{urlConnection.getURL().toExternalForm()};
            Timber.Forest.tag(TAG).v("Connection is open to %s", objectArray);
            objectArray = new Object[]{packet};
            Timber.Forest.tag(TAG).v("Sending: %s", objectArray);
            urlConnection.setConnectTimeout((int)this.mTimeout);
            urlConnection.setReadTimeout((int)this.mTimeout);
            if (packet.getPostData() != null) {
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "application/json");
                urlConnection.setRequestProperty("charset", "utf-8");
                String toPost = String.valueOf(packet.getPostData());
                if (this.mGzip) {
                    urlConnection.addRequestProperty("Content-Encoding", "gzip");
                    ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
                    Closeable closeable = new GZIPOutputStream(byteArrayOS);
                    Throwable throwable = null;
                    try {
                        GZIPOutputStream gzipStream = (GZIPOutputStream)closeable;
                        boolean bl = false;
                        String string = toPost;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        byte[] byArray = string.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        gzipStream.write(byArray);
                        gzipStream = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = urlConnection.getOutputStream();
                        outputStream.write(byteArrayOS.toByteArray());
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                Timber.Forest.tag(TAG).d((Throwable)e, "Failed to close output stream after writing gzipped POST data.", new Object[0]);
                            }
                        }
                    }
                }
                writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8));
                    ((Writer)writer).write(toPost);
                }
                catch (Throwable e) {
                    if (writer == null) throw e;
                    try {
                        ((BufferedWriter)writer).close();
                        throw e;
                    }
                    catch (IOException e2) {
                        Timber.Forest.tag(TAG).d((Throwable)e2, "Failed to close output stream after writing POST data.", new Object[0]);
                    }
                    throw e;
                }
                try {
                    ((BufferedWriter)writer).close();
                }
                catch (IOException e) {
                    Timber.Forest.tag(TAG).d((Throwable)e, "Failed to close output stream after writing POST data.", new Object[0]);
                }
            } else {
                urlConnection.setDoOutput(false);
            }
            int statusCode = urlConnection.getResponseCode();
            writer = new Object[]{statusCode};
            Timber.Forest.tag(TAG).v("Transmission finished (code=%d).", (Object[])writer);
            boolean successful = DefaultPacketSender.Companion.checkResponseCode(statusCode);
            if (successful) {
                InputStream is = urlConnection.getInputStream();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Timber.Forest.tag(TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                    }
                }
            } else {
                StringBuilder errorReason = new StringBuilder();
                BufferedReader errorReader = null;
                try {
                    errorReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                    String line = null;
                    while (true) {
                        String bl;
                        String it = bl = errorReader.readLine();
                        boolean bl2 = false;
                        line = it;
                        if (bl != null) {
                            errorReason.append(line);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (errorReader == null) throw throwable;
                    try {
                        errorReader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        Timber.Forest.tag(TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                    }
                    throw throwable;
                }
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    Timber.Forest.tag(TAG).d((Throwable)e, "Failed to close the error stream.", new Object[0]);
                }
                Object[] objectArray2 = new Object[]{statusCode, errorReason.toString()};
                Timber.Forest.tag(TAG).w("Transmission failed (code=%d, reason=%s)", objectArray2);
            }
            boolean bl = successful;
            urlConnection.disconnect();
            return bl;
        }
        catch (Exception e) {
            Timber.Forest.tag(TAG).e((Throwable)e, "Transmission failed unexpectedly.", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            HttpURLConnection httpURLConnection = urlConnection;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    @Override
    public void setGzipData(boolean gzip) {
        this.mGzip = gzip;
    }

    static {
        Class[] classArray = new Class[]{DefaultPacketSender.class};
        TAG = Matomo.Companion.tag(classArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/matomo/sdk/dispatcher/DefaultPacketSender$Companion;", "", "<init>", "()V", "TAG", "", "checkResponseCode", "", "code", "", "tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean checkResponseCode(int code) {
            return code == 204 || code == 200;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

