/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.dispatcher.DefaultDispatcherFactory;
import org.matomo.sdk.dispatcher.DispatcherFactory;
import org.matomo.sdk.tools.BuildInfo;
import org.matomo.sdk.tools.Checksum;
import org.matomo.sdk.tools.DeviceHelper;
import org.matomo.sdk.tools.PropertySource;
import timber.log.Timber;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\bR\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lorg/matomo/sdk/Matomo;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "preferenceMap", "", "Lorg/matomo/sdk/Tracker;", "Landroid/content/SharedPreferences;", "getContext", "()Landroid/content/Context;", "preferences", "getPreferences", "()Landroid/content/SharedPreferences;", "dispatcherFactory", "Lorg/matomo/sdk/dispatcher/DispatcherFactory;", "getDispatcherFactory", "()Lorg/matomo/sdk/dispatcher/DispatcherFactory;", "setDispatcherFactory", "(Lorg/matomo/sdk/dispatcher/DispatcherFactory;)V", "getTrackerPreferences", "tracker", "deviceHelper", "Lorg/matomo/sdk/tools/DeviceHelper;", "getDeviceHelper", "()Lorg/matomo/sdk/tools/DeviceHelper;", "Companion", "tracker_release"})
public final class Matomo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Tracker, SharedPreferences> preferenceMap = new HashMap();
    @NotNull
    private final Context context;
    @NotNull
    private final SharedPreferences preferences;
    @NotNull
    private DispatcherFactory dispatcherFactory;
    @NotNull
    private static final String LOGGER_PREFIX = "MATOMO:";
    @NotNull
    private static final String BASE_PREFERENCE_FILE = "org.matomo.sdk";
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static volatile Matomo sInstance;

    private Matomo(Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.context = context2;
        SharedPreferences sharedPreferences = context.getSharedPreferences(BASE_PREFERENCE_FILE, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.preferences = sharedPreferences;
        this.dispatcherFactory = new DefaultDispatcherFactory();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final SharedPreferences getPreferences() {
        return this.preferences;
    }

    @NotNull
    public final DispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public final void setDispatcherFactory(@NotNull DispatcherFactory dispatcherFactory) {
        Intrinsics.checkNotNullParameter((Object)dispatcherFactory, (String)"<set-?>");
        this.dispatcherFactory = dispatcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SharedPreferences getTrackerPreferences(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Map<Tracker, SharedPreferences> map = this.preferenceMap;
        synchronized (map) {
            boolean bl = false;
            SharedPreferences newPrefs = this.preferenceMap.get(tracker);
            if (newPrefs == null) {
                String string;
                try {
                    string = "org.matomo.sdk_" + Checksum.getMD5Checksum(tracker.getName());
                }
                catch (Exception e) {
                    Timber.Forest.e((Throwable)e);
                    string = "org.matomo.sdk_" + tracker.getName();
                }
                String prefName = string;
                newPrefs = this.context.getSharedPreferences(prefName, 0);
                this.preferenceMap.put(tracker, newPrefs);
            }
            SharedPreferences sharedPreferences = newPrefs;
            return sharedPreferences;
        }
    }

    @NotNull
    public final DeviceHelper getDeviceHelper() {
        return new DeviceHelper(this.context, new PropertySource(), new BuildInfo());
    }

    @JvmStatic
    @NotNull
    public static final Matomo getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    @JvmStatic
    @NotNull
    public static final String tag(Class<?> ... classes) {
        return Companion.tag(classes);
    }

    @JvmStatic
    @NotNull
    public static final String tag(String ... tags) {
        return Companion.tag(tags);
    }

    public /* synthetic */ Matomo(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J)\u0010\f\u001a\u00020\u00052\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\"\u0006\u0012\u0002\b\u00030\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J%\u0010\f\u001a\u00020\u00052\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u000e\"\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/matomo/sdk/Matomo$Companion;", "", "<init>", "()V", "LOGGER_PREFIX", "", "BASE_PREFERENCE_FILE", "sInstance", "Lorg/matomo/sdk/Matomo;", "getInstance", "context", "Landroid/content/Context;", "tag", "classes", "", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/lang/String;", "tags", "([Ljava/lang/String;)Ljava/lang/String;", "tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final Matomo getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Matomo matomo = sInstance;
            if (matomo == null) {
                Class<Matomo> clazz = Matomo.class;
                synchronized (clazz) {
                    boolean bl = false;
                    Matomo matomo2 = sInstance;
                    if (matomo2 == null) {
                        Matomo matomo3;
                        Matomo it = matomo3 = new Matomo(context, null);
                        boolean bl2 = false;
                        sInstance = it;
                        matomo2 = matomo3;
                    }
                    Matomo matomo4 = matomo2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var2_2
                    matomo = matomo4;
                }
            }
            return matomo;
        }

        @JvmStatic
        @NotNull
        public final String tag(Class<?> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            String[] tags = new String[classes.length];
            int n = classes.length;
            for (int i = 0; i < n; ++i) {
                tags[i] = classes[i].getSimpleName();
            }
            return this.tag(Arrays.copyOf(tags, tags.length));
        }

        @JvmStatic
        @NotNull
        public final String tag(String ... tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            StringBuilder sb = new StringBuilder(Matomo.LOGGER_PREFIX);
            int n = tags.length;
            for (int i = 0; i < n; ++i) {
                sb.append(tags[i]);
                if (i >= tags.length - 1) continue;
                sb.append(":");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

