/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk;

import android.content.SharedPreferences;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.Tracker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/matomo/sdk/LegacySettingsPorter;", "", "matomo", "Lorg/matomo/sdk/Matomo;", "(Lorg/matomo/sdk/Matomo;)V", "mLegacyPrefs", "Landroid/content/SharedPreferences;", "port", "", "tracker", "Lorg/matomo/sdk/Tracker;", "Companion", "tracker_release"})
public final class LegacySettingsPorter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences mLegacyPrefs;
    @NotNull
    public static final String LEGACY_PREF_OPT_OUT = "matomo.optout";
    @NotNull
    public static final String LEGACY_PREF_USER_ID = "tracker.userid";
    @NotNull
    public static final String LEGACY_PREF_FIRST_VISIT = "tracker.firstvisit";
    @NotNull
    public static final String LEGACY_PREF_VISITCOUNT = "tracker.visitcount";
    @NotNull
    public static final String LEGACY_PREF_PREV_VISIT = "tracker.previousvisit";

    public LegacySettingsPorter(@NotNull Matomo matomo) {
        Intrinsics.checkNotNullParameter((Object)matomo, (String)"matomo");
        this.mLegacyPrefs = matomo.getPreferences();
    }

    public final void port(@NotNull Tracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        SharedPreferences newSettings = tracker.getPreferences();
        if (this.mLegacyPrefs.getBoolean(LEGACY_PREF_OPT_OUT, false)) {
            newSettings.edit().putBoolean("tracker.optout", true).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_OPT_OUT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_USER_ID)) {
            newSettings.edit().putString(LEGACY_PREF_USER_ID, this.mLegacyPrefs.getString(LEGACY_PREF_USER_ID, UUID.randomUUID().toString())).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_USER_ID).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_FIRST_VISIT)) {
            newSettings.edit().putLong(LEGACY_PREF_FIRST_VISIT, this.mLegacyPrefs.getLong(LEGACY_PREF_FIRST_VISIT, -1L)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_FIRST_VISIT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_VISITCOUNT)) {
            newSettings.edit().putLong(LEGACY_PREF_VISITCOUNT, (long)this.mLegacyPrefs.getInt(LEGACY_PREF_VISITCOUNT, 0)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_VISITCOUNT).apply();
        }
        if (this.mLegacyPrefs.contains(LEGACY_PREF_PREV_VISIT)) {
            newSettings.edit().putLong(LEGACY_PREF_PREV_VISIT, this.mLegacyPrefs.getLong(LEGACY_PREF_PREV_VISIT, -1L)).apply();
            this.mLegacyPrefs.edit().remove(LEGACY_PREF_PREV_VISIT).apply();
        }
        Map map = this.mLegacyPrefs.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAll(...)");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next().getKey();
            Intrinsics.checkNotNull((Object)key);
            if (!StringsKt.startsWith$default((String)key, (String)"downloaded:", (boolean)false, (int)2, null)) continue;
            newSettings.edit().putBoolean(key, true).apply();
            this.mLegacyPrefs.edit().remove(key).apply();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/matomo/sdk/LegacySettingsPorter$Companion;", "", "()V", "LEGACY_PREF_FIRST_VISIT", "", "LEGACY_PREF_OPT_OUT", "LEGACY_PREF_PREV_VISIT", "LEGACY_PREF_USER_ID", "LEGACY_PREF_VISITCOUNT", "tracker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

