/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.dispatcher.DispatchMode;
import org.matomo.sdk.dispatcher.Dispatcher;
import org.matomo.sdk.dispatcher.Event;
import org.matomo.sdk.dispatcher.EventCache;
import org.matomo.sdk.dispatcher.Packet;
import org.matomo.sdk.dispatcher.PacketFactory;
import org.matomo.sdk.dispatcher.PacketSender;
import org.matomo.sdk.tools.Connectivity;
import timber.log.Timber;

public class DefaultDispatcher
implements Dispatcher {
    private static final String TAG = Matomo.tag(DefaultDispatcher.class);
    private final Object mThreadControl = new Object();
    private final EventCache mEventCache;
    private final Semaphore mSleepToken = new Semaphore(0);
    private final Connectivity mConnectivity;
    private final PacketFactory mPacketFactory;
    private final PacketSender mPacketSender;
    private volatile int mTimeOut = 5000;
    private volatile long mDispatchInterval = 120000L;
    private volatile int mRetryCounter = 0;
    private volatile boolean mForcedBlocking = false;
    private boolean mDispatchGzipped = false;
    private volatile DispatchMode mDispatchMode = DispatchMode.ALWAYS;
    private volatile boolean mRunning = false;
    @Nullable
    private volatile Thread mDispatchThread = null;
    private List<Packet> mDryRunTarget = null;
    private final Runnable mLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DefaultDispatcher.this.mRetryCounter = 0;
            while (DefaultDispatcher.this.mRunning) {
                try {
                    long sleepTime = DefaultDispatcher.this.mDispatchInterval;
                    if (DefaultDispatcher.this.mRetryCounter > 1) {
                        sleepTime += Math.min((long)DefaultDispatcher.this.mRetryCounter * DefaultDispatcher.this.mDispatchInterval, 5L * DefaultDispatcher.this.mDispatchInterval);
                    }
                    DefaultDispatcher.this.mSleepToken.tryAcquire(sleepTime, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Timber.tag((String)TAG).e((Throwable)e);
                }
                if (DefaultDispatcher.this.mEventCache.updateState(DefaultDispatcher.this.isOnline())) {
                    int count = 0;
                    ArrayList<Event> drainedEvents = new ArrayList<Event>();
                    DefaultDispatcher.this.mEventCache.drainTo(drainedEvents);
                    Timber.tag((String)TAG).d("Drained %s events.", new Object[]{drainedEvents.size()});
                    for (Packet packet : DefaultDispatcher.this.mPacketFactory.buildPackets(drainedEvents)) {
                        boolean success;
                        if (DefaultDispatcher.this.mDryRunTarget != null) {
                            Timber.tag((String)TAG).d("DryRun, stored HttpRequest, now %d.", new Object[]{DefaultDispatcher.this.mDryRunTarget.size()});
                            success = DefaultDispatcher.this.mDryRunTarget.add(packet);
                        } else {
                            success = DefaultDispatcher.this.mPacketSender.send(packet);
                        }
                        if (success) {
                            count += packet.getEventCount();
                        } else {
                            Timber.tag((String)TAG).d("Failure while trying to send packet", new Object[0]);
                            DefaultDispatcher.this.mRetryCounter++;
                            break;
                        }
                        DefaultDispatcher.this.mRetryCounter = 0;
                        if (DefaultDispatcher.this.isOnline()) continue;
                        Timber.tag((String)TAG).d("Disconnected during dispatch loop", new Object[0]);
                        break;
                    }
                    Timber.tag((String)TAG).d("Dispatched %d events.", new Object[]{count});
                    if (count < drainedEvents.size()) {
                        Timber.tag((String)TAG).d("Unable to send all events, requeueing %d events", new Object[]{drainedEvents.size() - count});
                        DefaultDispatcher.this.mEventCache.requeue(drainedEvents.subList(count, drainedEvents.size()));
                        DefaultDispatcher.this.mEventCache.updateState(DefaultDispatcher.this.isOnline());
                    }
                }
                Object object = DefaultDispatcher.this.mThreadControl;
                synchronized (object) {
                    if (DefaultDispatcher.this.mForcedBlocking || DefaultDispatcher.this.mEventCache.isEmpty() || DefaultDispatcher.this.mDispatchInterval < 0L) {
                        DefaultDispatcher.this.mRunning = false;
                        break;
                    }
                }
            }
        }
    };

    public DefaultDispatcher(EventCache eventCache, Connectivity connectivity, PacketFactory packetFactory, PacketSender packetSender) {
        this.mConnectivity = connectivity;
        this.mEventCache = eventCache;
        this.mPacketFactory = packetFactory;
        this.mPacketSender = packetSender;
        packetSender.setGzipData(this.mDispatchGzipped);
        packetSender.setTimeout(this.mTimeOut);
    }

    @Override
    public int getConnectionTimeOut() {
        return this.mTimeOut;
    }

    @Override
    public void setConnectionTimeOut(int timeOut) {
        this.mTimeOut = timeOut;
        this.mPacketSender.setTimeout(this.mTimeOut);
    }

    @Override
    public void setDispatchInterval(long dispatchInterval) {
        this.mDispatchInterval = dispatchInterval;
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    @Override
    public long getDispatchInterval() {
        return this.mDispatchInterval;
    }

    @Override
    public void setDispatchGzipped(boolean dispatchGzipped) {
        this.mDispatchGzipped = dispatchGzipped;
        this.mPacketSender.setGzipData(this.mDispatchGzipped);
    }

    @Override
    public boolean getDispatchGzipped() {
        return this.mDispatchGzipped;
    }

    @Override
    public void setDispatchMode(DispatchMode dispatchMode) {
        this.mDispatchMode = dispatchMode;
    }

    @Override
    public DispatchMode getDispatchMode() {
        return this.mDispatchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean launch() {
        Object object = this.mThreadControl;
        synchronized (object) {
            if (!this.mRunning) {
                this.mRunning = true;
                Thread thread = new Thread(this.mLoop);
                thread.setPriority(1);
                thread.setName("Matomo-default-dispatcher");
                this.mDispatchThread = thread;
                thread.start();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean forceDispatch() {
        if (!this.launch()) {
            this.mRetryCounter = 0;
            this.mSleepToken.release();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDispatchBlocking() {
        Thread dispatchThread;
        Object object = this.mThreadControl;
        synchronized (object) {
            this.mForcedBlocking = true;
        }
        if (this.forceDispatch()) {
            this.mSleepToken.release();
        }
        if ((dispatchThread = this.mDispatchThread) != null) {
            try {
                dispatchThread.join();
            }
            catch (InterruptedException e) {
                Timber.tag((String)TAG).d("Interrupted while waiting for dispatch thread to complete", new Object[0]);
            }
        }
        Object object2 = this.mThreadControl;
        synchronized (object2) {
            this.mForcedBlocking = false;
        }
    }

    @Override
    public void clear() {
        this.mEventCache.clear();
        if (this.mRunning) {
            this.forceDispatch();
        }
    }

    @Override
    public void submit(TrackMe trackMe) {
        this.mEventCache.add(new Event(trackMe.toMap()));
        if (this.mDispatchInterval != -1L) {
            this.launch();
        }
    }

    private boolean isOnline() {
        if (!this.mConnectivity.isConnected()) {
            return false;
        }
        switch (this.mDispatchMode) {
            case EXCEPTION: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case WIFI_ONLY: {
                return this.mConnectivity.getType() == Connectivity.Type.WIFI;
            }
        }
        return false;
    }

    @Override
    public void setDryRunTarget(List<Packet> dryRunTarget) {
        this.mDryRunTarget = dryRunTarget;
    }

    @Override
    public List<Packet> getDryRunTarget() {
        return this.mDryRunTarget;
    }
}

