/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.dispatcher.Event;
import org.matomo.sdk.dispatcher.Packet;
import timber.log.Timber;

public class PacketFactory {
    private static final String TAG = Matomo.tag(PacketFactory.class);
    @VisibleForTesting
    public static final int PAGE_SIZE = 20;
    private final String mApiUrl;

    public PacketFactory(String apiUrl) {
        this.mApiUrl = apiUrl;
    }

    public List<Packet> buildPackets(List<Event> events) {
        if (events.isEmpty()) {
            return Collections.emptyList();
        }
        if (events.size() == 1) {
            Packet p = this.buildPacketForGet(events.get(0));
            if (p == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(p);
        }
        int packets = (int)Math.ceil((double)events.size() * 1.0 / 20.0);
        ArrayList<Packet> freshPackets = new ArrayList<Packet>(packets);
        for (int i = 0; i < events.size(); i += 20) {
            List<Event> batch = events.subList(i, Math.min(i + 20, events.size()));
            Packet packet = batch.size() == 1 ? this.buildPacketForGet(batch.get(0)) : this.buildPacketForPost(batch);
            if (packet == null) continue;
            freshPackets.add(packet);
        }
        return freshPackets;
    }

    @Nullable
    private Packet buildPacketForPost(List<Event> events) {
        if (events.isEmpty()) {
            return null;
        }
        try {
            JSONObject params = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (Event event : events) {
                jsonArray.put((Object)event.getEncodedQuery());
            }
            params.put("requests", (Object)jsonArray);
            return new Packet(this.mApiUrl, params, events.size());
        }
        catch (JSONException e) {
            Timber.tag((String)TAG).w((Throwable)e, "Cannot create json object:\n%s", new Object[]{TextUtils.join((CharSequence)", ", events)});
            return null;
        }
    }

    @Nullable
    private Packet buildPacketForGet(@NonNull Event event) {
        if (event.getEncodedQuery().isEmpty()) {
            return null;
        }
        return new Packet(this.mApiUrl + event);
    }
}

