/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.matomo.sdk.Matomo;
import org.matomo.sdk.TrackMe;
import org.matomo.sdk.Tracker;
import org.matomo.sdk.extra.TrackHelper;
import timber.log.Timber;

public class MatomoExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = Matomo.tag(MatomoExceptionHandler.class);
    private final Tracker mTracker;
    private final TrackMe mTrackMe;
    private final Thread.UncaughtExceptionHandler mDefaultExceptionHandler;

    public MatomoExceptionHandler(@NonNull Tracker tracker, @Nullable TrackMe trackMe) {
        this.mTracker = tracker;
        this.mTrackMe = trackMe;
        this.mDefaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    public Tracker getTracker() {
        return this.mTracker;
    }

    public Thread.UncaughtExceptionHandler getDefaultExceptionHandler() {
        return this.mDefaultExceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            String excInfo = ex.getMessage();
            TrackHelper.track(this.mTrackMe).exception(ex).description(excInfo).fatal(true).with(this.getTracker());
            this.getTracker().dispatch();
        }
        catch (Exception e) {
            Timber.tag((String)TAG).e((Throwable)e, "Couldn't track uncaught exception", new Object[0]);
        }
        finally {
            if (this.getDefaultExceptionHandler() != null && this.getDefaultExceptionHandler() != this) {
                this.getDefaultExceptionHandler().uncaughtException(thread, ex);
            }
        }
    }
}

