/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.extra;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.piwik.sdk.TrackMe;
import timber.log.Timber;

public class CustomDimension {
    private static final String LOGGER_TAG = "PIWIK:CustomDimension";

    public static boolean setDimension(@NonNull TrackMe trackMe, int dimensionId, @Nullable String dimensionValue) {
        if (dimensionId < 1) {
            Timber.tag((String)LOGGER_TAG).e("dimensionId should be great than 0 (arg: %d)", new Object[]{dimensionId});
            return false;
        }
        if (dimensionValue != null && dimensionValue.length() > 255) {
            dimensionValue = dimensionValue.substring(0, 255);
            Timber.tag((String)LOGGER_TAG).w("dimensionValue was truncated to 255 chars.", new Object[0]);
        }
        if (dimensionValue != null && dimensionValue.length() == 0) {
            dimensionValue = null;
        }
        trackMe.set(CustomDimension.formatDimensionId(dimensionId), dimensionValue);
        return true;
    }

    @Nullable
    public static String getDimension(TrackMe trackMe, int dimensionId) {
        return trackMe.get(CustomDimension.formatDimensionId(dimensionId));
    }

    private static String formatDimensionId(int id) {
        return "dimension" + id;
    }
}

