/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.support.annotation.NonNull;
import java.net.MalformedURLException;
import java.net.URL;

public class TrackerConfig {
    private final URL mApiUrl;
    private final int mSiteId;
    private final String mTrackerName;

    public static TrackerConfig createDefault(@NonNull String apiUrl, int siteId) {
        return new TrackerConfig(apiUrl, siteId, "Default Tracker");
    }

    public TrackerConfig(@NonNull String apiUrl, int siteId, String trackerName) {
        try {
            if (apiUrl.endsWith("piwik.php") || apiUrl.endsWith("piwik-proxy.php")) {
                this.mApiUrl = new URL(apiUrl);
            } else {
                if (!apiUrl.endsWith("/")) {
                    apiUrl = apiUrl + "/";
                }
                this.mApiUrl = new URL(apiUrl + "piwik.php");
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.mSiteId = siteId;
        this.mTrackerName = trackerName;
    }

    public URL getApiUrl() {
        return this.mApiUrl;
    }

    public int getSiteId() {
        return this.mSiteId;
    }

    public String getTrackerName() {
        return this.mTrackerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackerConfig that = (TrackerConfig)o;
        return this.mSiteId == that.mSiteId && this.mApiUrl.equals(that.mApiUrl) && this.mTrackerName.equals(that.mTrackerName);
    }

    public int hashCode() {
        int result = this.mApiUrl.hashCode();
        result = 31 * result + this.mSiteId;
        result = 31 * result + this.mTrackerName.hashCode();
        return result;
    }
}

