/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk.dispatcher;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.piwik.sdk.Tracker;
import org.piwik.sdk.dispatcher.Event;
import timber.log.Timber;

public class EventDiskCache {
    private static final String TAG = "PIWIK:EventDiskCache";
    private static final String CACHE_DIR_NAME = "piwik_cache";
    private static final String VERSION = "1";
    private final LinkedBlockingQueue<File> mEventContainer = new LinkedBlockingQueue();
    private final File mCacheDir;
    private final long mMaxAge;
    private final long mMaxSize;
    private long mCurrentSize = 0L;
    private boolean mDelayedClear = false;

    public EventDiskCache(Tracker tracker) {
        this.mMaxAge = tracker.getOfflineCacheAge();
        this.mMaxSize = tracker.getOfflineCacheSize();
        File baseDir = new File(tracker.getPiwik().getContext().getCacheDir(), CACHE_DIR_NAME);
        this.mCacheDir = new File(baseDir, tracker.getAPIUrl().getHost());
        Object[] storedContainers = this.mCacheDir.listFiles();
        if (storedContainers != null) {
            Arrays.sort(storedContainers);
            for (Object container : storedContainers) {
                this.mCurrentSize += ((File)container).length();
                this.mEventContainer.add((File)container);
            }
        } else if (!this.mCacheDir.mkdirs()) {
            Timber.tag((String)TAG).e("Failed to make disk-cache dir %s", new Object[]{this.mCacheDir});
        }
    }

    private void checkCacheLimits() {
        File head;
        Iterator<File> iterator;
        long startTime = System.currentTimeMillis();
        if (this.mMaxAge < 0L) {
            Timber.tag((String)TAG).d("Caching is disabled.", new Object[0]);
            while (!this.mEventContainer.isEmpty()) {
                File head2 = this.mEventContainer.poll();
                if (!head2.delete()) continue;
                Timber.tag((String)TAG).e("Deleted cache container %s", new Object[]{head2.getPath()});
            }
        } else if (this.mMaxAge > 0L) {
            iterator = this.mEventContainer.iterator();
            while (iterator.hasNext()) {
                long timestamp;
                head = iterator.next();
                try {
                    String[] split = head.getName().split("_");
                    timestamp = Long.valueOf(split[1]);
                }
                catch (Exception e) {
                    Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
                    timestamp = 0L;
                }
                if (timestamp < System.currentTimeMillis() - this.mMaxAge) {
                    if (head.delete()) {
                        Timber.tag((String)TAG).e("Deleted cache container %s", new Object[]{head.getPath()});
                    } else {
                        Timber.tag((String)TAG).e("Failed to delete cache container %s", new Object[]{head.getPath()});
                    }
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
        if (this.mMaxSize != 0L) {
            iterator = this.mEventContainer.iterator();
            while (iterator.hasNext() && this.mCurrentSize > this.mMaxSize) {
                head = iterator.next();
                this.mCurrentSize -= head.length();
                iterator.remove();
                if (head.delete()) {
                    Timber.tag((String)TAG).e("Deleted cache container %s", new Object[]{head.getPath()});
                    continue;
                }
                Timber.tag((String)TAG).e("Failed to delete cache container %s", new Object[]{head.getPath()});
            }
        }
        long stopTime = System.currentTimeMillis();
        Timber.tag((String)TAG).d("Cache check took %dms", new Object[]{stopTime - startTime});
    }

    private boolean isCachingEnabled() {
        return this.mMaxAge >= 0L;
    }

    public synchronized void cache(@NonNull List<Event> toCache) {
        if (!this.isCachingEnabled() || toCache.isEmpty()) {
            return;
        }
        this.checkCacheLimits();
        long startTime = System.currentTimeMillis();
        File container = this.writeEventFile(toCache);
        if (container != null) {
            this.mEventContainer.add(container);
            this.mCurrentSize += container.length();
        }
        long stopTime = System.currentTimeMillis();
        Timber.tag((String)TAG).d("Caching of %d events took %dms (%s)", new Object[]{toCache.size(), stopTime - startTime, container});
    }

    @NonNull
    public synchronized List<Event> uncache() {
        ArrayList<Event> events = new ArrayList<Event>();
        if (!this.isCachingEnabled()) {
            return events;
        }
        this.checkCacheLimits();
        long startTime = System.currentTimeMillis();
        while (!this.mEventContainer.isEmpty()) {
            File head = this.mEventContainer.poll();
            if (head == null) continue;
            events.addAll(this.readEventFile(head));
            if (head.delete()) continue;
            Timber.tag((String)TAG).e("Failed to delete cache container %s", new Object[]{head.getPath()});
        }
        long stopTime = System.currentTimeMillis();
        Timber.tag((String)TAG).d("Uncaching of %d events took %dms", new Object[]{events.size(), stopTime - startTime});
        return events;
    }

    public synchronized boolean isEmpty() {
        if (!this.mDelayedClear) {
            this.checkCacheLimits();
            this.mDelayedClear = true;
        }
        return this.mEventContainer.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> readEventFile(@NonNull File file) {
        ArrayList<Event> events = new ArrayList<Event>();
        if (!file.exists()) {
            return events;
        }
        FileInputStream in = null;
        try {
            String line;
            in = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String versionLine = bufferedReader.readLine();
            if (!VERSION.equals(versionLine)) {
                ArrayList<Event> arrayList = events;
                return arrayList;
            }
            long cutoff = System.currentTimeMillis() - this.mMaxAge;
            while ((line = bufferedReader.readLine()) != null) {
                int split = line.indexOf(" ");
                if (split == -1) continue;
                try {
                    long timestamp = Long.parseLong(line.substring(0, split));
                    if (this.mMaxAge > 0L && timestamp < cutoff) continue;
                    String query = line.substring(split + 1);
                    events.add(new Event(timestamp, query));
                }
                catch (Exception e) {
                    Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
                }
            }
        }
        catch (IOException e) {
            Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
                }
            }
        }
        Timber.tag((String)TAG).d("Restored %d events from %s", new Object[]{events.size(), file.getPath()});
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private File writeEventFile(@NonNull List<Event> events) {
        if (events.isEmpty()) {
            return null;
        }
        File newFile = new File(this.mCacheDir, "events_" + events.get(events.size() - 1).getTimeStamp());
        FileWriter out = null;
        boolean dataWritten = false;
        try {
            out = new FileWriter(newFile);
            out.append(VERSION).append("\n");
            long cutoff = System.currentTimeMillis() - this.mMaxAge;
            for (Event event : events) {
                if (this.mMaxAge > 0L && event.getTimeStamp() < cutoff) continue;
                out.append(String.valueOf(event.getTimeStamp())).append(" ").append(event.getEncodedQuery()).append("\n");
                dataWritten = true;
            }
        }
        catch (IOException e) {
            Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
            newFile.deleteOnExit();
            File file = null;
            return file;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Timber.tag((String)TAG).e((Throwable)e, null, new Object[0]);
                }
            }
        }
        Timber.tag((String)TAG).d("Saved %d events to %s", new Object[]{events.size(), newFile.getPath()});
        if (dataWritten) {
            return newFile;
        }
        newFile.delete();
        return null;
    }
}

