/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.piwik.sdk.QueryParams;

public class TrackMe {
    private static final int DEFAULT_QUERY_CAPACITY = 14;
    private final HashMap<String, String> mQueryParams = new HashMap(14);

    public TrackMe() {
    }

    public TrackMe(TrackMe trackMe) {
        this.mQueryParams.putAll(trackMe.mQueryParams);
    }

    public TrackMe putAll(@NonNull TrackMe trackMe) {
        this.mQueryParams.putAll(trackMe.toMap());
        return this;
    }

    public synchronized TrackMe set(@NonNull String key, String value) {
        if (value == null) {
            this.mQueryParams.remove(key);
        } else if (value.length() > 0) {
            this.mQueryParams.put(key, value);
        }
        return this;
    }

    @Nullable
    public synchronized String get(@NonNull String queryParams) {
        return this.mQueryParams.get(queryParams);
    }

    public synchronized TrackMe set(@NonNull QueryParams key, String value) {
        this.set(key.toString(), value);
        return this;
    }

    public synchronized TrackMe set(@NonNull QueryParams key, int value) {
        this.set(key, Integer.toString(value));
        return this;
    }

    public synchronized TrackMe set(@NonNull QueryParams key, float value) {
        this.set(key, Float.toString(value));
        return this;
    }

    public synchronized TrackMe set(@NonNull QueryParams key, long value) {
        this.set(key, Long.toString(value));
        return this;
    }

    public synchronized boolean has(@NonNull QueryParams queryParams) {
        return this.mQueryParams.containsKey(queryParams.toString());
    }

    public synchronized TrackMe trySet(@NonNull QueryParams key, int value) {
        return this.trySet(key, String.valueOf(value));
    }

    public synchronized TrackMe trySet(@NonNull QueryParams key, float value) {
        return this.trySet(key, String.valueOf(value));
    }

    public synchronized TrackMe trySet(@NonNull QueryParams key, long value) {
        return this.trySet(key, String.valueOf(value));
    }

    public synchronized TrackMe trySet(@NonNull QueryParams key, String value) {
        if (!this.has(key)) {
            this.set(key, value);
        }
        return this;
    }

    public synchronized Map<String, String> toMap() {
        return new HashMap<String, String>(this.mQueryParams);
    }

    public synchronized String get(@NonNull QueryParams queryParams) {
        return this.mQueryParams.get(queryParams.toString());
    }

    public synchronized boolean isEmpty() {
        return this.mQueryParams.isEmpty();
    }
}

