/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUBIBO;
import apdu4j.BIBO;
import apdu4j.CardBIBO;
import apdu4j.CommandAPDU;
import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import apdu4j.i.SmartCardApp;
import apdu4j.terminals.LoggingCardTerminal;
import com.google.auto.service.AutoService;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import pro.javacard.AID;
import pro.javacard.CAPFile;
import pro.javacard.gp.DMTokenizer;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCardProfile;
import pro.javacard.gp.GPCommandLineInterface;
import pro.javacard.gp.GPCommands;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSecureChannel;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.i.CardKeysProvider;

@AutoService(value={SmartCardApp.class})
public final class GPTool
extends GPCommandLineInterface
implements SmartCardApp {
    private static boolean isVerbose = false;

    static void setupLogging(OptionSet args) {
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        if (args.has(OPT_VERBOSE)) {
            isVerbose = true;
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        }
        if (args.has(OPT_DEBUG) && args.has(OPT_VERBOSE)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
        }
        if (args.has(OPT_DEBUG) && System.getenv().containsKey("GP_TRACE")) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Card c = null;
        int ret = 1;
        try {
            Optional<CardTerminal> t;
            OptionSet args = GPTool.parseArguments(argv);
            GPTool.setupLogging(args);
            if (args.has(OPT_VERBOSE) || args.has(OPT_VERSION)) {
                System.out.println("# " + String.join((CharSequence)" ", System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("GP_")).map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.toList())));
                System.out.println("# gp " + String.join((CharSequence)" ", argv));
            }
            TerminalFactory tf = TerminalManager.getTerminalFactory();
            String reader = (String)args.valueOf(OPT_READER);
            if (reader == null) {
                reader = System.getenv("GP_READER");
            }
            if (!(t = TerminalManager.getInstance((CardTerminals)tf.terminals()).dwim(reader, System.getenv("GP_READER_IGNORE"), Collections.emptyList())).isPresent()) {
                System.err.println("Specify reader with -r/$GP_READER");
                System.exit(1);
            }
            t = t.map(e -> args.has(OPT_DEBUG) ? LoggingCardTerminal.getInstance((CardTerminal)e) : e);
            c = t.get().connect("*");
            ret = new GPTool().run((BIBO)CardBIBO.wrap((Card)c), argv);
        }
        catch (IllegalArgumentException e2) {
            System.err.println("Invalid argument: " + e2.getMessage());
            if (isVerbose) {
                e2.printStackTrace();
            }
        }
        catch (Exception e3) {
            System.err.println("Error: " + e3.getMessage());
            if (isVerbose) {
                e3.printStackTrace();
            }
        }
        finally {
            if (c != null) {
                try {
                    c.disconnect(true);
                }
                catch (CardException e2) {}
            }
        }
        System.exit(ret);
    }

    static boolean onlyHasArg(OptionSet args, OptionSpec<?> s) {
        long needle = args.specs().stream().filter(e -> args.has(e)).count();
        long hay = args.specs().stream().filter(e -> args.has(e) && e != s).count();
        return needle == 1L && hay == 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int run(BIBO bibo, String[] argv) {
        try {
            List blobs;
            Object k;
            List<CAPFile> caps;
            Object aid2;
            GPCardKeys keys;
            Optional<GPCardKeys> key;
            GPSession gp;
            OptionSet args = GPTool.parseArguments(argv);
            GPTool.setupLogging(args);
            if (args.has(OPT_VERSION) || args.has(OPT_VERBOSE) || args.has(OPT_DEBUG) || args.has(OPT_INFO)) {
                String version = GPSession.getVersion();
                version = version + "\n# Running on " + System.getProperty("os.name");
                version = version + " " + System.getProperty("os.version");
                version = version + " " + System.getProperty("os.arch");
                version = version + ", Java " + System.getProperty("java.version");
                version = version + " by " + System.getProperty("java.vendor");
                System.out.println("# GlobalPlatformPro " + version);
                if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                    System.err.println("Unlimited crypto policy is NOT installed!");
                }
                if (GPTool.onlyHasArg(args, OPT_VERSION)) {
                    return 0;
                }
            }
            CAPFile cap = null;
            if (args.has(OPT_CAP)) {
                File capfile = (File)args.valueOf(OPT_CAP);
                cap = CAPFile.fromFile((Path)capfile.toPath());
                if (args.has(OPT_INFO)) {
                    System.out.println("**** CAP info of " + capfile.getName());
                    cap.dump(System.out);
                    if (args.specs().size() == 2) {
                        return 0;
                    }
                }
            }
            APDUBIBO channel = new APDUBIBO(bibo);
            if (args.has(OPT_APDU)) {
                AID target = null;
                if (args.has(OPT_APPLET)) {
                    target = AID.fromString((Object)args.valueOf(OPT_APPLET));
                } else if (cap != null) {
                    target = (AID)cap.getAppletAIDs().get(0);
                }
                if (target != null) {
                    this.verbose("Selecting " + target);
                    channel.transmit(new CommandAPDU(0, 164, 4, 0, target.getBytes()));
                }
                for (String s : args.valuesOf(OPT_APDU)) {
                    CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)s));
                    channel.transmit(c);
                }
            }
            Map<String, String> env = System.getenv();
            if (args.has(OPT_SDAID)) {
                System.err.println("# -sdaid is deprecated, use -c/--connect <AID>");
                gp = GPSession.connect((APDUBIBO)channel, (AID)AID.fromString((Object)args.valueOf(OPT_SDAID)));
            } else {
                gp = args.has(OPT_CONNECT) ? GPSession.connect((APDUBIBO)channel, (AID)AID.fromString((Object)args.valueOf(OPT_CONNECT))) : (env.containsKey("GP_AID") ? GPSession.connect((APDUBIBO)channel, (AID)AID.fromString((Object)env.get("GP_AID"))) : GPSession.discover((APDUBIBO)channel));
            }
            if (args.has(OPT_DM_KEY)) {
                RSAPrivateKey pkey = (RSAPrivateKey)GPCrypto.pem2PrivateKey((InputStream)Files.newInputStream(Paths.get((String)args.valueOf(OPT_DM_KEY), new String[0]), new OpenOption[0]));
                gp.setTokenizer(DMTokenizer.forPrivateKey((RSAPrivateKey)pkey));
            } else if (args.has(OPT_DM_TOKEN)) {
                byte[] token = HexUtils.stringToBin((String)((String)args.valueOf(OPT_DM_TOKEN)));
                gp.setTokenizer(DMTokenizer.forToken((byte[])token));
            }
            if (args.has(OPT_INFO)) {
                GPData.dump((APDUBIBO)channel);
            }
            if ((key = GPTool.keyFromPlugin((String)args.valueOf(OPT_KEY))).isPresent()) {
                keys = key.get();
            } else {
                Optional envKeys = PlaintextKeys.fromEnvironment();
                Optional cliKeys = PlaintextKeys.fromStrings((String)((String)args.valueOf(OPT_KEY_ENC)), (String)((String)args.valueOf(OPT_KEY_MAC)), (String)((String)args.valueOf(OPT_KEY_DEK)), (String)((String)args.valueOf(OPT_KEY)), (String)((String)args.valueOf(OPT_KEY_KDF)), null, (String)((String)args.valueOf(OPT_KEY_VERSION)));
                if (envKeys.isPresent() && cliKeys.isPresent()) {
                    System.err.println("Warning: keys set on command line shadow environment!");
                } else if (!envKeys.isPresent() && !cliKeys.isPresent()) {
                    System.err.println("Warning: no keys given, defaulting to " + HexUtils.bin2hex((byte[])PlaintextKeys.defaultKeyBytes));
                }
                PlaintextKeys keyz = cliKeys.map(Optional::of).orElse(envKeys).orElse(PlaintextKeys.defaultKey());
                if (args.has(OPT_VISA2)) {
                    keyz.setDiversifier(PlaintextKeys.Diversification.VISA2);
                } else if (args.has(OPT_EMV)) {
                    keyz.setDiversifier(PlaintextKeys.Diversification.EMV);
                } else if (args.has(OPT_KDF3)) {
                    keyz.setDiversifier(PlaintextKeys.Diversification.KDF3);
                } else if (args.has(OPT_KEY_KDF)) {
                    PlaintextKeys.Diversification div = PlaintextKeys.Diversification.lookup((String)((String)args.valueOf(OPT_KEY_KDF)));
                    if (div == null) {
                        throw new IllegalArgumentException("Invalid KDF: " + (String)args.valueOf(OPT_KEY_KDF) + "\nValid values are: " + Arrays.asList(PlaintextKeys.Diversification.values()).stream().map(i -> i.toString()).collect(Collectors.joining(", ")));
                    }
                    keyz.setDiversifier(div);
                }
                if (args.has(OPT_KEY_VERSION)) {
                    keyz.setVersion(GPUtils.intValue((String)((String)args.valueOf(OPT_KEY_VERSION))));
                }
                keys = keyz;
            }
            if (args.has(OPT_BS)) {
                gp.setBlockSize(((Integer)args.valueOf(OPT_BS)).intValue());
            }
            if (args.has(OPT_PROFILE)) {
                Optional p = GPCardProfile.fromName((String)((String)args.valueOf(OPT_PROFILE)));
                if (!p.isPresent()) {
                    System.err.println(String.format("Unknown profile '%s', known profiles: %s", args.valueOf(OPT_PROFILE), String.join((CharSequence)", ", GPCardProfile.profiles.keySet())));
                    return 1;
                }
                gp.profile = (GPCardProfile)p.get();
            }
            if (!GPTool.needsAuthentication(args)) return 0;
            Object mode = GPSession.defaultMode.clone();
            if (args.has(OPT_SC_MODE)) {
                ((AbstractCollection)mode).clear();
                for (String s : args.valuesOf(OPT_SC_MODE)) {
                    ((AbstractCollection)mode).add(GPSession.APDUMode.fromString((String)s));
                }
            }
            try {
                gp.openSecureChannel(keys, null, null, (EnumSet)mode);
            }
            catch (GPException e2) {
                System.err.println("Failed to open secure channel: " + e2.getMessage() + "\nRead more from https://github.com/martinpaljak/GlobalPlatformPro/wiki/Keys");
                return 1;
            }
            if (args.has(OPT_SECURE_APDU)) {
                for (String s : args.valuesOf(OPT_SECURE_APDU)) {
                    CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)s));
                    gp.transmit(c);
                }
            }
            if (args.has(OPT_DELETE)) {
                GPRegistry reg = gp.getRegistry();
                if (args.has(OPT_DEFAULT)) {
                    Optional def = reg.getDefaultSelectedAID();
                    if (def.isPresent()) {
                        gp.deleteAID((AID)def.get(), false);
                    } else {
                        System.err.println("Could not identify default selected application!");
                    }
                }
                boolean failure = false;
                List aidList = args.valuesOf(OPT_DELETE).stream().map(a -> AID.fromString((Object)a)).collect(Collectors.toList());
                Iterator iterator = aidList.iterator();
                while (iterator.hasNext()) {
                    aid2 = (AID)iterator.next();
                    try {
                        boolean deleteDeps = reg.allPackageAIDs().contains(aid2) && args.has(OPT_FORCE);
                        gp.deleteAID((AID)aid2, deleteDeps);
                    }
                    catch (GPException e3) {
                        failure = true;
                        if (!reg.allAIDs().contains(aid2)) {
                            System.err.println("Could not delete AID (not present on card): " + aid2);
                            continue;
                        }
                        if (e3.sw == 27013) {
                            System.err.println("Could not delete " + aid2 + ". Some app still active?");
                            continue;
                        }
                        System.err.println("Could not delete AID: " + aid2);
                    }
                }
                if (failure && !args.has(OPT_FORCE)) {
                    return 1;
                }
            }
            if (args.has(OPT_UNINSTALL)) {
                caps = GPTool.getCapFileList(args, (OptionSpec<File>)OPT_UNINSTALL);
                boolean failure = false;
                for (CAPFile instcap : caps) {
                    aid2 = instcap.getPackageAID();
                    if (!gp.getRegistry().allAIDs().contains(aid2)) {
                        System.err.println(aid2 + " is not present on card!");
                    }
                    try {
                        gp.deleteAID((AID)aid2, true);
                        System.out.println(aid2 + " deleted.");
                    }
                    catch (GPException e4) {
                        failure = true;
                    }
                }
                if (failure && !args.has(OPT_FORCE)) {
                    return 1;
                }
            }
            if (args.has(OPT_LOAD)) {
                caps = GPTool.getCapFileList(args, (OptionSpec<File>)OPT_LOAD);
                for (CAPFile loadcap : caps) {
                    if (isVerbose) {
                        loadcap.dump(System.out);
                    }
                    GPTool.loadCAP(args, gp, loadcap);
                }
            }
            if (args.has(OPT_PUT_KEY) || args.has(OPT_REPLACE_KEY)) {
                String kv = args.has(OPT_PUT_KEY) ? (String)args.valueOf(OPT_PUT_KEY) : (String)args.valueOf(OPT_REPLACE_KEY);
                int keyVersion = GPUtils.intValue((String)((String)args.valueOf(OPT_NEW_KEY_VERSION)));
                if (keyVersion < 1 || keyVersion > 127) {
                    System.err.println("Invalid key version: " + GPUtils.intString((int)keyVersion) + ", some possible values:");
                    System.err.println(GPKeyInfo.keyVersionPurposes.entrySet().stream().map(e -> String.format("%s - %s", GPUtils.intString((int)((Integer)e.getKey())), e.getValue())).collect(Collectors.joining("\n")));
                    throw new IllegalArgumentException("Invalid key version: " + GPUtils.intString((int)keyVersion));
                }
                boolean replace = args.has(OPT_REPLACE_KEY);
                if (Files.exists(Paths.get(kv, new String[0]), new LinkOption[0])) {
                    FileInputStream fin = new FileInputStream(kv);
                    aid2 = null;
                    try {
                        PublicKey pubkey = GPCrypto.pem2PublicKey((InputStream)fin);
                        gp.putKey((Key)pubkey, keyVersion, replace);
                    }
                    catch (Throwable pubkey) {
                        aid2 = pubkey;
                        throw pubkey;
                    }
                    finally {
                        if (fin != null) {
                            if (aid2 != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable pubkey) {
                                    ((Throwable)aid2).addSuppressed(pubkey);
                                }
                            } else {
                                fin.close();
                            }
                        }
                    }
                } else {
                    k = HexUtils.hex2bin((String)kv);
                    if (((Object)k).length != 16) {
                        throw new IllegalArgumentException("Invalid key length: " + ((Object)k).length);
                    }
                    gp.putKey(GPCrypto.des3key((byte[])k), keyVersion, replace);
                }
            }
            if (args.has(OPT_INSTALL)) {
                AID appaid;
                CAPFile instcap;
                File capfile = (File)args.valueOf(OPT_INSTALL);
                FileInputStream fin = new FileInputStream(capfile);
                k = null;
                try {
                    instcap = CAPFile.fromStream((InputStream)fin);
                }
                catch (Throwable aid2) {
                    k = aid2;
                    throw aid2;
                }
                finally {
                    if (fin != null) {
                        if (k != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable aid2) {
                                ((Throwable)k).addSuppressed(aid2);
                            }
                        } else {
                            fin.close();
                        }
                    }
                }
                if (args.has(OPT_VERBOSE)) {
                    instcap.dump(System.out);
                }
                GPRegistry reg = gp.getRegistry();
                if (args.has(OPT_FORCE) && reg.allPackageAIDs().contains(instcap.getPackageAID())) {
                    gp.deleteAID(instcap.getPackageAID(), true);
                }
                if (instcap.getAppletAIDs().size() == 0) {
                    throw new IllegalArgumentException("CAP file has no applets!");
                }
                if (instcap.getAppletAIDs().size() > 1) {
                    if (!args.has(OPT_APPLET)) throw new IllegalArgumentException("CAP contains more than one applet, specify the right one with --" + OPT_APPLET);
                    appaid = AID.fromString((Object)args.valueOf(OPT_APPLET));
                } else {
                    appaid = (AID)instcap.getAppletAIDs().get(0);
                }
                AID instanceaid = args.has(OPT_CREATE) ? AID.fromString((Object)args.valueOf(OPT_CREATE)) : appaid;
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                GPTool.loadCAP(args, gp, instcap);
                if (args.has(OPT_FORCE) && reg.getDefaultSelectedAID().isPresent() && privs.contains(GPRegistryEntry.Privilege.CardReset)) {
                    gp.deleteAID((AID)reg.getDefaultSelectedAID().get(), false);
                }
                if (gp.getRegistry().allAppletAIDs().contains(instanceaid)) {
                    System.err.println("WARNING: Applet " + instanceaid + " already present on card");
                }
                byte[] params = args.has(OPT_PARAMS) ? HexUtils.stringToBin((String)((String)args.valueOf(OPT_PARAMS))) : new byte[]{};
                gp.installAndMakeSelectable(instcap.getPackageAID(), appaid, instanceaid, privs, params);
            }
            if (args.has(OPT_CREATE) && !args.has(OPT_INSTALL)) {
                AID packageAID = null;
                AID appletAID = null;
                if (cap != null) {
                    packageAID = cap.getPackageAID();
                    if (cap.getAppletAIDs().size() > 1 && !args.has(OPT_APPLET)) {
                        throw new IllegalArgumentException("There should be only one applet in CAP. Use --" + OPT_APPLET + " to specify one of " + cap.getAppletAIDs());
                    }
                    appletAID = (AID)cap.getAppletAIDs().get(0);
                }
                if (args.has(OPT_PACKAGE)) {
                    packageAID = AID.fromString((Object)args.valueOf(OPT_PACKAGE));
                }
                if (args.has(OPT_APPLET)) {
                    appletAID = AID.fromString((Object)args.valueOf(OPT_APPLET));
                }
                if (packageAID == null || appletAID == null) {
                    throw new IllegalArgumentException("Need --" + OPT_PACKAGE + " and --" + OPT_APPLET + " or --" + OPT_CAP);
                }
                AID instanceAID = AID.fromString((Object)args.valueOf(OPT_CREATE));
                if (gp.getRegistry().allAIDs().contains(appletAID)) {
                    System.err.println("WARNING: Applet " + appletAID + " already present on card");
                }
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                byte[] params = args.has(OPT_PARAMS) ? HexUtils.stringToBin((String)((String)args.valueOf(OPT_PARAMS))) : new byte[]{};
                gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, privs, params);
            }
            if (args.has(OPT_DOMAIN)) {
                AID appletAID;
                AID packageAID;
                byte[] params;
                BerTlvs parameters = null;
                if (args.has(OPT_PARAMS)) {
                    params = HexUtils.stringToBin((String)((String)args.valueOf(OPT_PARAMS)));
                    BerTlvParser parser = new BerTlvParser();
                    try {
                        parameters = parser.parse(params);
                    }
                    catch (Exception e5) {
                        if (args.has(OPT_ALLOW_FROM) || args.has(OPT_ALLOW_TO)) {
                            throw new IllegalArgumentException(OPT_ALLOW_FROM + " and " + OPT_ALLOW_TO + " not available, could not parse parameters: " + HexUtils.bin2hex((byte[])params));
                        }
                        System.err.println("Warning: could not parse parameters: " + HexUtils.bin2hex((byte[])params));
                    }
                } else {
                    params = new byte[]{};
                }
                if (args.has(OPT_PACKAGE) && args.has(OPT_APPLET)) {
                    packageAID = AID.fromString((Object)args.valueOf(OPT_PACKAGE));
                    appletAID = AID.fromString((Object)args.valueOf(OPT_APPLET));
                } else {
                    packageAID = gp.getRegistry().allPackageAIDs().contains(new AID("A0000000035350")) ? new AID("A0000000035350") : new AID("A0000001515350");
                    appletAID = gp.getRegistry().allPackageAIDs().contains(new AID("A0000000035350")) ? new AID("A000000003535041") : new AID("A000000151535041");
                    this.verbose("Note: using detected default AID-s for SSD instantiation: " + appletAID + " from " + packageAID);
                }
                AID instanceAID = AID.fromString((Object)args.valueOf(OPT_DOMAIN));
                EnumSet<GPRegistryEntry.Privilege> privs = GPTool.getPrivileges(args);
                privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                if (!args.has(OPT_SAD) && !gp.profile.oldStyleSSDParameters()) {
                    if (parameters != null && parameters.find(new BerTag(129)) == null) {
                        params = GPUtils.concatenate((byte[][])new byte[][]{params, {-127, 2, gp.getSecureChannel().getValue(), (byte)gp.getSecureChannel().getI()}});
                    } else {
                        System.err.println("Notice: 0x81 already in parameters or no parameters");
                    }
                }
                if (args.has(OPT_ALLOW_TO) && parameters != null) {
                    if (parameters.find(new BerTag(130)) == null) {
                        params = GPUtils.concatenate((byte[][])new byte[][]{params, {-126, 2, 32, 32}});
                    } else {
                        System.err.println("Warning: 0x82 already in parameters, " + OPT_ALLOW_TO + " not applied");
                    }
                }
                if (args.has(OPT_ALLOW_FROM) && parameters != null) {
                    if (parameters.find(new BerTag(135)) == null) {
                        params = GPUtils.concatenate((byte[][])new byte[][]{params, {-121, 2, 32, 32}});
                    } else {
                        System.err.println("Warning: 0x87 already in parameters, " + OPT_ALLOW_FROM + " not applied");
                    }
                }
                if (args.has(OPT_ALLOW_TO) && gp.profile.oldStyleSSDParameters()) {
                    params = HexUtils.hex2bin((String)"C90145");
                }
                if (parameters != null || args.has(OPT_ALLOW_TO) || args.has(OPT_ALLOW_FROM)) {
                    this.verbose(String.format("Final parameters: %s", HexUtils.bin2hex((byte[])params)));
                }
                gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, privs, params);
            }
            if (args.has(OPT_MOVE)) {
                AID what = AID.fromString((Object)args.valueOf(OPT_MOVE));
                AID to = AID.fromString((Object)args.valueOf(OPT_TO));
                gp.extradite(what, to);
            }
            if (args.has(OPT_STORE_DATA)) {
                blobs = args.valuesOf(OPT_STORE_DATA).stream().map(e -> HexUtils.stringToBin((String)e)).collect(Collectors.toList());
                for (byte[] blob : blobs) {
                    if (args.has(OPT_APPLET)) {
                        gp.personalize(AID.fromString((Object)args.valueOf(OPT_APPLET)), blob, 1);
                        continue;
                    }
                    gp.storeData(blob, 1);
                }
            }
            if (args.has(OPT_STORE_DATA_CHUNK)) {
                blobs = args.valuesOf(OPT_STORE_DATA_CHUNK).stream().map(e -> HexUtils.stringToBin((String)e)).collect(Collectors.toList());
                if (args.has(OPT_APPLET)) {
                    gp.personalize(AID.fromString((Object)args.valueOf(OPT_APPLET)), blobs, 1);
                } else {
                    gp.storeData(blobs, 1);
                }
            }
            if (args.has(OPT_LOCK_CARD)) {
                gp.setCardStatus((byte)127);
            }
            if (args.has(OPT_UNLOCK_CARD)) {
                gp.setCardStatus((byte)15);
            }
            if (args.has(OPT_INITIALIZE_CARD)) {
                gp.setCardStatus((byte)7);
            }
            if (args.has(OPT_SECURE_CARD)) {
                GPRegistryEntry isd = (GPRegistryEntry)gp.getRegistry().getISD().orElseThrow(() -> new GPException("ISD not present, are you in a subtree?"));
                if (isd.getLifeCycle() != 7 && args.has(OPT_FORCE)) {
                    System.out.println("Note: forcing status to INITIALIZED");
                    gp.setCardStatus((byte)7);
                }
                gp.setCardStatus((byte)15);
            }
            if (args.has(OPT_LOCK_APPLET)) {
                gp.lockUnlockApplet(AID.fromString((Object)args.valueOf(OPT_LOCK_APPLET)), true);
            }
            if (args.has(OPT_UNLOCK_APPLET)) {
                gp.lockUnlockApplet(AID.fromString((Object)args.valueOf(OPT_UNLOCK_APPLET)), false);
            }
            if (args.has(OPT_LIST)) {
                GPCommands.listRegistry((GPRegistry)gp.getRegistry(), (PrintStream)System.out, (boolean)args.has(OPT_VERBOSE));
            }
            if (args.has(OPT_DELETE_KEY)) {
                int keyver = GPUtils.intValue((String)((String)args.valueOf(OPT_DELETE_KEY)));
                System.out.println("Deleting key " + GPUtils.intString((int)keyver));
                gp.deleteKey(keyver);
            }
            if (args.has(OPT_UNLOCK)) {
                int kv;
                boolean replace;
                List current = gp.getKeyInfoTemplate();
                if (gp.getScpKeyVersion() == 255 || current.size() == 0) {
                    replace = false;
                    kv = args.has(OPT_NEW_KEY_VERSION) ? GPUtils.intValue((String)((String)args.valueOf(OPT_NEW_KEY_VERSION))) : 1;
                } else {
                    kv = gp.getScpKeyVersion();
                    replace = true;
                }
                PlaintextKeys new_key = PlaintextKeys.defaultKey();
                new_key.setVersion(kv);
                new_key.diversify(gp.getSecureChannel(), new byte[0]);
                gp.putKeys((GPCardKeys)new_key, replace);
                System.out.println("Default " + HexUtils.bin2hex((byte[])PlaintextKeys.defaultKeyBytes) + " set as key for " + gp.getAID());
            }
            if (args.has(OPT_LOCK) || args.has(OPT_LOCK_ENC) || args.has(OPT_LOCK_MAC) || args.has(OPT_LOCK_DEK)) {
                boolean replace = true;
                Optional<GPCardKeys> lockKey = GPTool.keyFromPlugin((String)args.valueOf(OPT_LOCK));
                GPCardKeys newKeys = lockKey.isPresent() ? lockKey.get() : (GPCardKeys)PlaintextKeys.fromStrings((String)((String)args.valueOf(OPT_LOCK_ENC)), (String)((String)args.valueOf(OPT_LOCK_MAC)), (String)((String)args.valueOf(OPT_LOCK_DEK)), (String)((String)args.valueOf(OPT_LOCK)), (String)((String)args.valueOf(OPT_LOCK_KDF)), null, (String)((String)args.valueOf(OPT_NEW_KEY_VERSION))).orElseThrow(() -> new IllegalArgumentException("Can not lock without keys :)"));
                if (newKeys instanceof PlaintextKeys) {
                    int keyver;
                    PlaintextKeys pk = (PlaintextKeys)newKeys;
                    List current = gp.getKeyInfoTemplate();
                    if (args.has(OPT_NEW_KEY_VERSION)) {
                        keyver = GPUtils.intValue((String)((String)args.valueOf(OPT_NEW_KEY_VERSION)));
                        if (current.stream().filter(e -> e.getVersion() == keyver).count() > 0L) {
                            replace = false;
                        }
                    } else if (current.size() == 0 || gp.getScpKeyVersion() == 255) {
                        keyver = 1;
                        replace = false;
                    } else {
                        keyver = gp.getScpKeyVersion();
                    }
                    pk.setVersion(keyver);
                }
                int keyver = newKeys.getKeyInfo().getVersion();
                this.verbose("Keyset version: " + keyver);
                byte[] kdd = newKeys.getKDD().orElseGet(() -> (byte[])keys.getKDD().get());
                System.out.println("Looking at key version");
                if (keyver >= 16 && keyver <= 31) {
                    newKeys.diversify(GPSecureChannel.SCP01, kdd);
                } else if (keyver >= 32 && keyver <= 47) {
                    newKeys.diversify(GPSecureChannel.SCP02, kdd);
                } else if (keyver >= 48 && keyver <= 63) {
                    newKeys.diversify(GPSecureChannel.SCP03, kdd);
                } else {
                    newKeys.diversify(gp.getSecureChannel(), kdd);
                }
                gp.putKeys(newKeys, replace);
                if (args.has(OPT_LOCK) && newKeys instanceof PlaintextKeys) {
                    PlaintextKeys pk = (PlaintextKeys)newKeys;
                    if (pk.getMasterKey().isPresent()) {
                        System.out.println(gp.getAID() + " locked with: " + HexUtils.bin2hex((byte[])((byte[])pk.getMasterKey().get())));
                    }
                    if (pk.diversifier != PlaintextKeys.Diversification.NONE) {
                        System.out.println("Keys were diversified with " + pk.diversifier + " and " + HexUtils.bin2hex((byte[])kdd));
                    }
                    System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                } else {
                    System.out.println("Card locked with new keys.");
                    System.out.println("Write them down, DO NOT FORGET/LOSE THEM!");
                }
            }
            if (args.has(OPT_MAKE_DEFAULT)) {
                gp.makeDefaultSelected(AID.fromString((Object)args.valueOf(OPT_MAKE_DEFAULT)));
            }
            if (args.has(OPT_RENAME_ISD)) {
                gp.renameISD(AID.fromString((Object)args.valueOf(OPT_RENAME_ISD)));
            }
            if (args.has(OPT_SET_PRE_PERSO)) {
                byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf(OPT_SET_PRE_PERSO)));
                if (args.has(OPT_TODAY)) {
                    System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
                }
                GPCommands.setPrePerso((GPSession)gp, (byte[])payload);
            }
            if (!args.has(OPT_SET_PERSO)) return 0;
            byte[] payload = HexUtils.stringToBin((String)((String)args.valueOf(OPT_SET_PERSO)));
            if (args.has(OPT_TODAY)) {
                System.arraycopy(GPData.CPLC.today(), 0, payload, 2, 2);
            }
            GPCommands.setPerso((GPSession)gp, (byte[])payload);
            return 0;
        }
        catch (IOException | NoSuchAlgorithmException e6) {
            System.err.println("ERROR: " + e6.getMessage());
            if (!isVerbose) return 1;
            e6.printStackTrace();
            return 1;
        }
    }

    private static Optional<GPCardKeys> keyFromPlugin(String spec) {
        try {
            ServiceLoader<CardKeysProvider> sl = ServiceLoader.load(CardKeysProvider.class, GPTool.class.getClassLoader());
            ArrayList list = new ArrayList();
            sl.iterator().forEachRemaining(list::add);
            return list.stream().map(e -> e.getCardKeys(spec)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        catch (ServiceConfigurationError e2) {
            System.err.println("Could not load key provider: " + e2.getMessage());
            return Optional.empty();
        }
    }

    private static void loadCAP(OptionSet args, GPSession gp, CAPFile capFile) throws GPException, IOException {
        try {
            AID to = args.has(OPT_TO) ? AID.fromString((Object)args.valueOf(OPT_TO)) : gp.getAID();
            AID dapDomain = args.has(OPT_DAP_DOMAIN) ? AID.fromString((Object)args.valueOf(OPT_DAP_DOMAIN)) : null;
            GPData.LFDBH lfdbh = args.has(OPT_SHA256) ? GPData.LFDBH.SHA256 : null;
            GPCommands.load((GPSession)gp, (CAPFile)capFile, (AID)to, (AID)dapDomain, (GPData.LFDBH)lfdbh);
            System.out.println(capFile.getFile().map(Path::toString).orElse("CAP") + " loaded");
        }
        catch (GPException e) {
            switch (e.sw) {
                case 27264: {
                    System.err.println("Applet loading failed. Are you sure the card can handle it?");
                    break;
                }
                case 27013: {
                    System.err.println("Applet loading not allowed. Are you sure the domain can accept it?");
                    break;
                }
            }
            throw e;
        }
    }

    private static AID appletAIDfromCAP(CAPFile cap) {
        return (AID)cap.getAppletAIDs().get(0);
    }

    private static EnumSet<GPRegistryEntry.Privilege> getPrivileges(OptionSet args) {
        EnumSet<GPRegistryEntry.Privilege> privs = EnumSet.noneOf(GPRegistryEntry.Privilege.class);
        if (args.has(OPT_PRIVS)) {
            for (String p : args.valuesOf(OPT_PRIVS)) {
                for (String s : p.split(",")) {
                    privs.add((GPRegistryEntry.Privilege)GPRegistryEntry.Privilege.lookup((String)s.trim()).orElseThrow(() -> new IllegalArgumentException("Unknown privilege: " + s.trim() + "\nValid values are: " + Arrays.asList(GPRegistryEntry.Privilege.values()).stream().map(i -> i.toString()).collect(Collectors.joining(", ")))));
                }
            }
        }
        return privs;
    }

    private static List<CAPFile> getCapFileList(OptionSet args, OptionSpec<File> arg) {
        return args.valuesOf(arg).stream().map(File::toPath).map(e -> {
            try {
                return CAPFile.fromFile((Path)e);
            }
            catch (IOException x) {
                throw new IllegalArgumentException("Could not read CAP: " + x.getMessage());
            }
        }).collect(Collectors.toList());
    }

    private static boolean needsAuthentication(OptionSet args) {
        OptionSpec[] yes = new OptionSpec[]{OPT_CONNECT, OPT_LIST, OPT_LOAD, OPT_INSTALL, OPT_DELETE, OPT_DELETE_KEY, OPT_CREATE, OPT_LOCK, OPT_UNLOCK, OPT_LOCK_ENC, OPT_LOCK_MAC, OPT_LOCK_DEK, OPT_MAKE_DEFAULT, OPT_UNINSTALL, OPT_SECURE_APDU, OPT_DOMAIN, OPT_LOCK_CARD, OPT_UNLOCK_CARD, OPT_LOCK_APPLET, OPT_UNLOCK_APPLET, OPT_STORE_DATA, OPT_STORE_DATA_CHUNK, OPT_INITIALIZE_CARD, OPT_SECURE_CARD, OPT_RENAME_ISD, OPT_SET_PERSO, OPT_SET_PRE_PERSO, OPT_MOVE, OPT_PUT_KEY, OPT_REPLACE_KEY};
        return Arrays.stream(yes).anyMatch(arg_0 -> ((OptionSet)args).has(arg_0));
    }

    private void verbose(String s) {
        if (isVerbose) {
            System.out.println("# " + s);
        }
    }
}

