/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.util.EnumSet;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPSessionKeyProvider;
import pro.javacard.gp.GlobalPlatform;

abstract class SecureChannelWrapper {
    protected int blockSize = 0;
    protected GPSessionKeyProvider sessionKeys = null;
    protected boolean mac = false;
    protected boolean enc = false;
    protected boolean rmac = false;
    protected boolean renc = false;

    SecureChannelWrapper() {
    }

    public void setSecurityLevel(EnumSet<GlobalPlatform.APDUMode> securityLevel) {
        this.mac = securityLevel.contains((Object)GlobalPlatform.APDUMode.MAC);
        this.enc = securityLevel.contains((Object)GlobalPlatform.APDUMode.ENC);
        this.rmac = securityLevel.contains((Object)GlobalPlatform.APDUMode.RMAC);
        this.renc = securityLevel.contains((Object)GlobalPlatform.APDUMode.RENC);
    }

    protected int getBlockSize() {
        int res = this.blockSize;
        if (this.mac) {
            res -= 8;
        }
        if (this.enc) {
            res -= 8;
        }
        return res;
    }

    protected abstract CommandAPDU wrap(CommandAPDU var1) throws GPException;

    protected abstract ResponseAPDU unwrap(ResponseAPDU var1) throws GPException;
}

