/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GPUtils {
    public static int intValue(String s) {
        if (s.trim().toLowerCase().startsWith("0x")) {
            return Integer.parseInt(s.substring(2), 16);
        }
        return Integer.parseInt(s);
    }

    public static String byteArrayToReadableString(byte[] array) {
        if (array == null) {
            return "(null)";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            char c = (char)array[i];
            s.append(c >= ' ' && c < '\u007f' ? Character.valueOf(c) : ".");
        }
        return "|" + s.toString() + "|";
    }

    public static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }

    public static List<byte[]> splitArray(byte[] array, int blockSize) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        int len = array.length;
        int offset = 0;
        int left = len - offset;
        while (left > 0) {
            int currentLen = 0;
            currentLen = left >= blockSize ? blockSize : left;
            byte[] block = new byte[currentLen];
            System.arraycopy(array, offset, block, 0, currentLen);
            result.add(block);
            left -= currentLen;
            offset += currentLen;
        }
        return result;
    }

    public static byte[] encodeLength(int len) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        if (len < 128) {
            bo.write((byte)len);
        } else if (len <= 255) {
            bo.write(-127);
            bo.write((byte)len);
        } else if (len <= 65535) {
            bo.write(-126);
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        } else {
            bo.write(-125);
            bo.write((byte)((len & 0xFF0000) >> 16));
            bo.write((byte)((len & 0xFF00) >> 8));
            bo.write((byte)(len & 0xFF));
        }
        return bo.toByteArray();
    }

    static byte[] positive(byte[] bytes) {
        if (bytes[0] == 0 && bytes.length % 2 == 1) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    static byte[] positive(BigInteger i) {
        byte[] bytes = i.toByteArray();
        return GPUtils.positive(bytes);
    }
}

