/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.AID;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPRegistryEntryApp;
import pro.javacard.gp.GPRegistryEntryPkg;
import pro.javacard.gp.GlobalPlatform;

public class GPRegistry
implements Iterable<GPRegistryEntry> {
    private static final Logger logger = LoggerFactory.getLogger(GPRegistry.class);
    boolean tags = true;
    LinkedHashMap<AID, GPRegistryEntry> entries = new LinkedHashMap();

    public void add(GPRegistryEntry entry) {
        GPRegistryEntry existing;
        GPRegistryEntryApp app;
        if (entry instanceof GPRegistryEntryApp && (app = (GPRegistryEntryApp)entry).getPrivileges().has(GPRegistryEntry.Privilege.SecurityDomain) && entry.getType() == GPRegistryEntry.Kind.Application) {
            entry.setType(GPRegistryEntry.Kind.SecurityDomain);
        }
        if ((existing = this.entries.get(entry.getAID())) != null && existing.getType() != entry.getType()) {
            logger.warn("Duplicate entry! " + existing + " vs " + entry);
            return;
        }
        this.entries.put(entry.getAID(), entry);
    }

    @Override
    public Iterator<GPRegistryEntry> iterator() {
        return this.entries.values().iterator();
    }

    public List<GPRegistryEntryPkg> allPackages() {
        ArrayList<GPRegistryEntryPkg> res = new ArrayList<GPRegistryEntryPkg>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isPackage()) continue;
            res.add((GPRegistryEntryPkg)e);
        }
        return res;
    }

    public List<AID> allPackageAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isPackage()) continue;
            res.add(e.getAID());
        }
        return res;
    }

    public List<AID> allAppletAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isApplet()) continue;
            res.add(e.getAID());
        }
        return res;
    }

    public List<AID> allAIDs() {
        ArrayList<AID> res = new ArrayList<AID>();
        for (GPRegistryEntry e : this.entries.values()) {
            res.add(e.getAID());
        }
        return res;
    }

    public GPRegistryEntryApp getDomain(AID aid) {
        for (GPRegistryEntryApp e : this.allDomains()) {
            if (!e.aid.equals((Object)aid)) continue;
            return e;
        }
        return null;
    }

    public List<GPRegistryEntryApp> allApplets() {
        ArrayList<GPRegistryEntryApp> res = new ArrayList<GPRegistryEntryApp>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isApplet()) continue;
            res.add((GPRegistryEntryApp)e);
        }
        return res;
    }

    public List<GPRegistryEntryApp> allDomains() {
        ArrayList<GPRegistryEntryApp> res = new ArrayList<GPRegistryEntryApp>();
        for (GPRegistryEntry e : this.entries.values()) {
            if (!e.isDomain()) continue;
            res.add((GPRegistryEntryApp)e);
        }
        return res;
    }

    public AID getDefaultSelectedAID() {
        for (GPRegistryEntryApp e : this.allApplets()) {
            if (!e.getPrivileges().has(GPRegistryEntry.Privilege.CardReset)) continue;
            return e.getAID();
        }
        return null;
    }

    public AID getDefaultSelectedPackageAID() {
        AID defaultAID = this.getDefaultSelectedAID();
        if (defaultAID != null) {
            for (GPRegistryEntryPkg e : this.allPackages()) {
                if (!e.getModules().contains(defaultAID)) continue;
                return e.getAID();
            }
            for (GPRegistryEntryPkg e : this.allPackages()) {
                if (!defaultAID.toString().startsWith(e.getAID().toString())) continue;
                return e.getAID();
            }
        }
        return null;
    }

    public GPRegistryEntryApp getISD() {
        for (GPRegistryEntryApp a : this.allDomains()) {
            if (a.getType() != GPRegistryEntry.Kind.IssuerSecurityDomain) continue;
            return a;
        }
        return null;
    }

    private void populate_legacy(int p1, byte[] data, GPRegistryEntry.Kind type, GlobalPlatform.GPSpec spec) throws GPDataException {
        int offset = 0;
        try {
            while (offset < data.length) {
                int len = data[offset++];
                AID aid = new AID(data, offset, len);
                offset += len;
                int lifecycle = data[offset++] & 0xFF;
                byte privileges = data[offset++];
                if (type == GPRegistryEntry.Kind.IssuerSecurityDomain || type == GPRegistryEntry.Kind.Application) {
                    GPRegistryEntryApp app = new GPRegistryEntryApp();
                    app.setType(type);
                    app.setAID(aid);
                    app.setPrivileges(GPRegistryEntry.Privileges.fromByte(privileges));
                    app.setLifeCycle(lifecycle);
                    this.add(app);
                    continue;
                }
                if (type != GPRegistryEntry.Kind.ExecutableLoadFile) continue;
                if (privileges != 0) {
                    throw new GPDataException("Privileges of Load File is not 0x00");
                }
                GPRegistryEntryPkg pkg = new GPRegistryEntryPkg();
                pkg.setAID(aid);
                pkg.setLifeCycle(lifecycle);
                pkg.setType(type);
                if (spec != GlobalPlatform.GPSpec.OP201 && p1 != 32) {
                    int num = data[offset++];
                    for (int i = 0; i < num; ++i) {
                        len = data[offset++] & 0xFF;
                        aid = new AID(data, offset, len);
                        offset += len;
                        pkg.addModule(aid);
                    }
                }
                this.add(pkg);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GPDataException("Invalid response to GET STATUS", e);
        }
    }

    private void populate_tags(byte[] data, GPRegistryEntry.Kind type) throws GPDataException {
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        for (BerTlv t : tlvs.findAll(new BerTag(227))) {
            GPRegistryEntryApp app = new GPRegistryEntryApp();
            GPRegistryEntryPkg pkg = new GPRegistryEntryPkg();
            if (t.isConstructed()) {
                BerTlv versiontag;
                BerTlv privstag;
                BerTlv lifecycletag;
                BerTlv aid = t.find(new BerTag(79));
                if (aid != null) {
                    AID aidv = new AID(aid.getBytesValue());
                    app.setAID(aidv);
                    pkg.setAID(aidv);
                }
                if ((lifecycletag = t.find(new BerTag(159, 112))) != null) {
                    app.setLifeCycle(lifecycletag.getBytesValue()[0] & 0xFF);
                    pkg.setLifeCycle(lifecycletag.getBytesValue()[0] & 0xFF);
                }
                if ((privstag = t.find(new BerTag(197))) != null) {
                    GPRegistryEntry.Privileges privs = GPRegistryEntry.Privileges.fromBytes(privstag.getBytesValue());
                    app.setPrivileges(privs);
                }
                for (BerTlv cf : t.findAll(new BerTag(207))) {
                    logger.debug("CF=" + cf.getHexValue());
                }
                BerTlv loadfiletag = t.find(new BerTag(196));
                if (loadfiletag != null) {
                    app.setLoadFile(new AID(loadfiletag.getBytesValue()));
                }
                if ((versiontag = t.find(new BerTag(206))) != null) {
                    pkg.setVersion(versiontag.getBytesValue());
                }
                for (BerTlv lf : t.findAll(new BerTag(132))) {
                    pkg.addModule(new AID(lf.getBytesValue()));
                }
                BerTlv domaintag = t.find(new BerTag(204));
                if (domaintag != null) {
                    app.setDomain(new AID(domaintag.getBytesValue()));
                    pkg.setDomain(new AID(domaintag.getBytesValue()));
                }
            }
            if (type == GPRegistryEntry.Kind.ExecutableLoadFile) {
                pkg.setType(type);
                this.add(pkg);
                continue;
            }
            app.setType(type);
            this.add(app);
        }
    }

    public void parse(int p1, byte[] data, GPRegistryEntry.Kind type, GlobalPlatform.GPSpec spec) throws GPDataException {
        if (this.tags) {
            this.populate_tags(data, type);
        } else {
            this.populate_legacy(p1, data, type, spec);
        }
    }
}

