/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.HexUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.Arrays;
import pro.javacard.gp.AID;
import pro.javacard.gp.GPDataException;

public class SEAccessControl {
    public static final AID ACR_AID = new AID("A00000015141434C00");
    public static final byte ACR_GET_DATA_ALL = 64;
    public static final byte ACR_GET_DATA_NEXT = 96;
    private static final byte[] ACR_GET_DATA_RESP = new byte[]{-1, 64};
    private static final byte REF_AR_DO = -30;
    private static final byte REF_DO = -31;
    private static final byte AID_REF_DO = 79;
    private static final byte HASH_REF_DO = -63;
    private static final byte AR_DO = -29;
    private static final byte APDU_AR_DO = -48;
    private static final byte NFC_AR_DO = -47;
    private static final byte HASH_MAX_LENGTH = 20;
    private static final byte HASH_MIN_LENGTH = 0;
    private static final byte STORE_AR_DO = -16;
    private static final byte DELETE_AR_DO = -15;
    public static final Map<Integer, String> ACR_STORE_DATA_ERROR;
    public static final Map<Integer, String> ACR_GET_DATA_ERROR;

    public static RefArDo parseRefArDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == -30 && (data[1] & 0xFF) <= data.length - 2) {
            RefDo refDo = SEAccessControl.parseRefDo(Arrays.copyOfRange((byte[])data, (int)2, (int)data.length));
            ArDo arDo = SEAccessControl.parseArDo(Arrays.copyOfRange((byte[])data, (int)(2 + (2 + (data[3] & 0xFF))), (int)data.length));
            return new RefArDo(refDo, arDo);
        }
        throw new GPDataException("ACR get data : bad response format (REF_AR_DO)");
    }

    public static RefDo parseRefDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == -31 && (data[1] & 0xFF) <= data.length - 2) {
            AidRefDo aidRefDo = SEAccessControl.parseAidRefDo(Arrays.copyOfRange((byte[])data, (int)2, (int)data.length));
            HashRefDo hashRefDo = SEAccessControl.parseHashRefDo(Arrays.copyOfRange((byte[])data, (int)(2 + (2 + (data[3] & 0xFF))), (int)data.length));
            return new RefDo(aidRefDo, hashRefDo);
        }
        throw new GPDataException("ACR get data : bad response format (REF_DO)");
    }

    public static AidRefDo parseAidRefDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == 79 && (data[1] & 0xFF) <= data.length - 2) {
            return new AidRefDo(Arrays.copyOfRange((byte[])data, (int)2, (int)((data[1] & 0xFF) + 2)));
        }
        throw new GPDataException("ACR get data : bad response format (AID_REF_DO)");
    }

    public static HashRefDo parseHashRefDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == -63 && (data[1] & 0xFF) <= data.length - 2 && ((data[1] & 0xFF) == 20 || (data[1] & 0xFF) == 0)) {
            return new HashRefDo(Arrays.copyOfRange((byte[])data, (int)2, (int)((data[1] & 0xFF) + 2)));
        }
        throw new GPDataException("ACR get data : bad response format (HASH_REF_DO)");
    }

    public static ArDo parseArDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == -29 && (data[1] & 0xFF) <= data.length - 2) {
            ApduArDo apduArDo = null;
            NfcArDo nfcArDo = null;
            switch (data[2]) {
                case -48: {
                    apduArDo = SEAccessControl.parseApduArDo(Arrays.copyOfRange((byte[])data, (int)2, (int)data.length));
                    if ((data[1] & 0xFF) == (data[3] & 0xFF) + 2) break;
                    nfcArDo = SEAccessControl.parseNfcArDo(Arrays.copyOfRange((byte[])data, (int)(2 + (2 + (data[3] & 0xFF))), (int)data.length));
                    break;
                }
                case -47: {
                    nfcArDo = SEAccessControl.parseNfcArDo(Arrays.copyOfRange((byte[])data, (int)2, (int)data.length));
                    break;
                }
            }
            return new ArDo(apduArDo, nfcArDo);
        }
        throw new GPDataException("ACR get data : bad response format (AR_DO)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApduArDo parseApduArDo(byte[] data) throws GPDataException {
        if (data.length <= 2 || data[0] != -48 || (data[1] & 0xFF) > data.length - 2 || (data[1] & 0xFF) != 1 && (data[1] & 0xFF) % 8 != 0) throw new GPDataException("ACR get data : bad response format (APDU_AR_DO)");
        if ((data[1] & 0xFF) != 1) return new ApduArDo(EventAccessRules.CUSTOM, Arrays.copyOfRange((byte[])data, (int)2, (int)(2 + (data[1] & 0xFF))));
        switch (data[2] & 0xFF) {
            case 1: {
                return new ApduArDo(EventAccessRules.ALWAYS, new byte[0]);
            }
            case 0: {
                return new ApduArDo(EventAccessRules.NEVER, new byte[0]);
            }
        }
        return null;
    }

    public static NfcArDo parseNfcArDo(byte[] data) throws GPDataException {
        if (data.length > 2 && data[0] == -47 && (data[1] & 0xFF) <= data.length - 2 && (data[1] & 0xFF) == 1) {
            switch (data[2] & 0xFF) {
                case 1: {
                    return new NfcArDo(EventAccessRules.ALWAYS);
                }
                case 0: {
                    return new NfcArDo(EventAccessRules.NEVER);
                }
            }
        } else {
            throw new GPDataException("ACR get data : bad response format (NFC_AR_DO)");
        }
        return null;
    }

    public static void printList(List<RefArDo> acrList) {
        if (acrList.size() == 0) {
            System.out.println("No Rule found");
            return;
        }
        for (int i = 0; i < acrList.size(); ++i) {
            System.out.println("RULE #" + i + " :");
            System.out.println("       AID  : " + acrList.get((int)i).refDo.aidRefDo);
            System.out.println("       HASH : " + acrList.get((int)i).refDo.hashRefDo);
            if (acrList.get((int)i).arDo.apduArDo != null) {
                System.out.println("       APDU rule   : " + (Object)((Object)acrList.get((int)i).arDo.apduArDo.rule) + "(" + String.format("0x%02X", acrList.get((int)i).arDo.apduArDo.rule.getValue()) + ")");
                System.out.println("       APDU filter : " + HexUtils.bin2hex((byte[])acrList.get((int)i).arDo.apduArDo.filter));
            }
            if (acrList.get((int)i).arDo.nfcArDo == null) continue;
            System.out.println("       NFC  rule   : " + (Object)((Object)acrList.get((int)i).arDo.nfcArDo.rule) + "(" + String.format("0x%02X", acrList.get((int)i).arDo.nfcArDo.rule.getValue()) + ")");
        }
    }

    static {
        HashMap<Integer, String> tmp = new HashMap<Integer, String>();
        tmp.put(25473, "Rule successfully stored but an access rule already exists for this target");
        tmp.put(25985, "Memory problem");
        tmp.put(26368, "Wrong length in Lc");
        tmp.put(27010, "Security status not satisfied");
        tmp.put(27013, "Conditions not satisfied");
        tmp.put(27264, "Incorrect values in the command data");
        tmp.put(27268, "Not enough memory space");
        tmp.put(27270, "Incorrect P1 P2");
        tmp.put(27272, "Referenced data not found");
        tmp.put(27273, "Conflicting access rule already exists in the Secure Element");
        tmp.put(27904, "Invalid instruction");
        tmp.put(28160, "Invalid class");
        ACR_STORE_DATA_ERROR = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put(25985, "Memory problem");
        tmp.put(26368, "Wrong length in Lc");
        tmp.put(27013, "Conditions not satisfied");
        tmp.put(27264, "Incorrect values in the command data");
        tmp.put(27270, "Incorrect P1 P2");
        tmp.put(27272, "Referenced data not found");
        tmp.put(27904, "Invalid instruction");
        tmp.put(28160, "Invalid class");
        ACR_GET_DATA_ERROR = Collections.unmodifiableMap(tmp);
    }

    public static class AcrListResponse {
        public List<RefArDo> acrList;

        public AcrListResponse(List<RefArDo> acrList) {
            this.acrList = acrList;
        }

        public static BerTlvData getAcrListData(BerTlvData previousData, byte[] data) throws GPDataException {
            if (previousData == null && data.length > 2 && data[0] == ACR_GET_DATA_RESP[0] && data[1] == ACR_GET_DATA_RESP[1]) {
                int first = data[2] & 0xFF;
                int length = 0;
                int offset = 3;
                if (first < 128) {
                    length = first & 0xFF;
                } else {
                    switch (first) {
                        case 129: {
                            length = data[3] & 0xFF;
                            ++offset;
                            break;
                        }
                        case 130: {
                            length = (data[3] & 0xFF) << 8 | data[4] & 0xFF;
                            offset += 2;
                            break;
                        }
                        case 131: {
                            length = (data[3] & 0xFF) << 16 | (data[4] & 0xFF) << 8 | data[5] & 0xFF;
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new GPDataException("ACR get data : bad BER TLV response format (GET_DATA)");
                        }
                    }
                }
                byte[] berData = new byte[length];
                System.arraycopy(data, offset, berData, 0, data.length - offset);
                return new BerTlvData(berData, length, data.length - offset);
            }
            if (previousData != null) {
                System.arraycopy(data, 0, previousData.getData(), previousData.currentIndex, data.length);
                previousData.setCurrentIndex(data.length + previousData.currentIndex);
                return previousData;
            }
            throw new GPDataException("ACR get data : bad response format (GET_DATA)");
        }

        public static AcrListResponse fromBytes(int length, byte[] data) throws GPDataException {
            ArrayList<RefArDo> acrList = new ArrayList<RefArDo>();
            for (int offset = 0; length > offset; offset += (data[1 + offset] & 0xFF) + 2) {
                acrList.add(SEAccessControl.parseRefArDo(Arrays.copyOfRange((byte[])data, (int)offset, (int)data.length)));
            }
            return new AcrListResponse(acrList);
        }
    }

    public static class BerTlvData {
        private byte[] data;
        private int length;
        private int currentIndex;

        public BerTlvData(byte[] data, int length, int index) {
            this.data = data;
            this.length = length;
            this.currentIndex = index;
        }

        public void setCurrentIndex(int index) {
            this.currentIndex = index;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }
    }

    static enum EventAccessRules {
        NEVER(0),
        ALWAYS(1),
        CUSTOM(2);

        private byte value;

        private EventAccessRules(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static class NfcArDo
    extends TLV {
        EventAccessRules rule;

        public NfcArDo(EventAccessRules rule) {
            this.rule = rule;
        }

        public String toString() {
            return "rule : " + (Object)((Object)this.rule);
        }

        @Override
        public byte getTag() {
            return -47;
        }

        @Override
        public byte[] getData() {
            if (this.enabled) {
                return new byte[]{this.rule.getValue()};
            }
            return new byte[0];
        }
    }

    public static class ApduArDo
    extends TLV {
        EventAccessRules rule;
        byte[] filter;

        public ApduArDo(EventAccessRules rule, byte[] filter) {
            this.rule = rule;
            this.filter = filter;
        }

        public ApduArDo(byte[] data) {
            if (data.length == 0) {
                switch (data[0]) {
                    case 0: {
                        this.rule = EventAccessRules.NEVER;
                        break;
                    }
                    case 1: {
                        this.rule = EventAccessRules.ALWAYS;
                        break;
                    }
                }
            } else {
                this.rule = EventAccessRules.CUSTOM;
                this.filter = new byte[data.length];
                System.arraycopy(data, 0, this.filter, 0, data.length);
            }
        }

        public String toString() {
            return "rule : " + (Object)((Object)this.rule) + " | filter : " + HexUtils.bin2hex((byte[])this.filter);
        }

        @Override
        public byte getTag() {
            return -48;
        }

        @Override
        public byte[] getData() {
            if (this.enabled) {
                if (this.rule == EventAccessRules.CUSTOM) {
                    return this.filter;
                }
                return new byte[]{this.rule.getValue()};
            }
            return new byte[0];
        }
    }

    public static class ArDo
    extends TLV {
        ApduArDo apduArDo;
        NfcArDo nfcArDo;

        public ArDo(ApduArDo apduArDo, NfcArDo nfcArDo) {
            this.apduArDo = apduArDo;
            this.nfcArDo = nfcArDo;
        }

        public String toString() {
            return "apdu : " + this.apduArDo + " | nfc : " + this.nfcArDo;
        }

        @Override
        public byte getTag() {
            return -29;
        }

        @Override
        public byte[] getData() {
            if (this.apduArDo != null && this.nfcArDo == null) {
                return this.apduArDo.getBytes();
            }
            if (this.apduArDo == null && this.nfcArDo != null) {
                return this.nfcArDo.getBytes();
            }
            if (this.apduArDo != null && this.nfcArDo != null) {
                byte[] apduBytes = this.apduArDo.getBytes();
                byte[] nfcBytes = this.nfcArDo.getBytes();
                byte[] data = new byte[apduBytes.length + nfcBytes.length];
                System.arraycopy(apduBytes, 0, data, 0, apduBytes.length);
                System.arraycopy(nfcBytes, 0, data, apduBytes.length, nfcBytes.length);
                return data;
            }
            return new byte[0];
        }
    }

    public static class HashRefDo
    extends TLV {
        byte[] hash;

        public HashRefDo(byte[] data) {
            this.hash = data;
        }

        public String toString() {
            return HexUtils.bin2hex((byte[])this.hash);
        }

        @Override
        public byte getTag() {
            return -63;
        }

        @Override
        public byte[] getData() {
            return this.hash;
        }
    }

    public static class AidRefDo
    extends TLV {
        byte[] aid;

        public AidRefDo(byte[] data) {
            this.aid = data;
        }

        public String toString() {
            return HexUtils.bin2hex((byte[])this.aid);
        }

        @Override
        public byte getTag() {
            return 79;
        }

        @Override
        public byte[] getData() {
            return this.aid;
        }
    }

    public static class RefDo
    extends TLV {
        AidRefDo aidRefDo;
        HashRefDo hashRefDo;

        public RefDo(AidRefDo aidRefDo, HashRefDo hashRefDo) {
            this.aidRefDo = aidRefDo;
            this.hashRefDo = hashRefDo;
        }

        public String toString() {
            return this.aidRefDo + " | " + this.hashRefDo;
        }

        @Override
        public byte getTag() {
            return -31;
        }

        @Override
        public byte[] getData() {
            byte[] aidRefBytes = this.aidRefDo.getBytes();
            byte[] hashRefBytes = this.hashRefDo.getBytes();
            byte[] data = new byte[aidRefBytes.length + hashRefBytes.length];
            System.arraycopy(aidRefBytes, 0, data, 0, aidRefBytes.length);
            System.arraycopy(hashRefBytes, 0, data, aidRefBytes.length, hashRefBytes.length);
            return data;
        }
    }

    public static class RefArDo
    extends TLV {
        RefDo refDo;
        ArDo arDo;

        public RefArDo(RefDo refDo, ArDo arDo) {
            this.refDo = refDo;
            this.arDo = arDo;
        }

        public RefArDo(AID aid, byte[] hash) {
            this.refDo = new RefDo(new AidRefDo(aid.getBytes()), new HashRefDo(hash));
            this.arDo = new ArDo(new ApduArDo(EventAccessRules.ALWAYS, new byte[0]), null);
        }

        public RefArDo(AID aid, byte[] hash, byte[] rules) {
            this.refDo = new RefDo(new AidRefDo(aid.getBytes()), new HashRefDo(hash));
            this.arDo = new ArDo(new ApduArDo(rules), null);
        }

        public String toString() {
            return this.refDo + " | " + this.arDo;
        }

        @Override
        public byte getTag() {
            return -30;
        }

        @Override
        public byte[] getData() {
            byte[] refDoBytes = this.refDo.getBytes();
            byte[] arDoBytes = this.arDo.getBytes();
            byte[] data = new byte[refDoBytes.length + arDoBytes.length];
            System.arraycopy(refDoBytes, 0, data, 0, refDoBytes.length);
            System.arraycopy(arDoBytes, 0, data, refDoBytes.length, arDoBytes.length);
            return data;
        }
    }

    public static class StoreArDo
    extends TLV {
        RefArDo refArDo;

        public StoreArDo(RefArDo refArDo) {
            this.refArDo = refArDo;
        }

        @Override
        public byte getTag() {
            return -16;
        }

        @Override
        public byte[] getData() {
            return this.refArDo.getBytes();
        }
    }

    public static class DeleteArDo
    extends TLV {
        RefArDo refArDo;

        public DeleteArDo(RefArDo refArDo) {
            this.refArDo = refArDo;
            if (this.refArDo.arDo.apduArDo != null) {
                this.refArDo.arDo.apduArDo.setEnable(false);
            }
            if (this.refArDo.arDo.nfcArDo != null) {
                this.refArDo.arDo.nfcArDo.setEnable(false);
            }
        }

        @Override
        public byte getTag() {
            return -15;
        }

        @Override
        public byte[] getData() {
            return this.refArDo.getBytes();
        }
    }

    public static class DeleteAidDo
    extends TLV {
        AidRefDo aidRefDo;

        public DeleteAidDo(AidRefDo aidRefDo) {
            this.aidRefDo = aidRefDo;
        }

        @Override
        public byte getTag() {
            return -15;
        }

        @Override
        public byte[] getData() {
            return this.aidRefDo.getBytes();
        }
    }

    public static abstract class TLV
    implements ITLV {
        protected boolean enabled = true;

        public byte[] getBytes() {
            byte[] tlvData = this.getData();
            byte[] data = new byte[tlvData.length + 2];
            data[0] = this.getTag();
            data[1] = (byte)tlvData.length;
            System.arraycopy(tlvData, 0, data, 2, tlvData.length);
            return data;
        }

        public void setEnable(boolean status) {
            this.enabled = status;
        }
    }

    static interface ITLV {
        public byte getTag();

        public byte[] getData();
    }
}

