/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.APDUReplayProvider;
import apdu4j.HexUtils;
import apdu4j.LoggingCardTerminal;
import apdu4j.TerminalManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.TerminalFactory;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import pro.javacard.gp.AID;
import pro.javacard.gp.CAPFile;
import pro.javacard.gp.GPCommands;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKey;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPRegistryEntryApp;
import pro.javacard.gp.GlobalPlatform;
import pro.javacard.gp.PlaintextKeys;
import pro.javacard.gp.PythiaKeys;
import pro.javacard.gp.SEAccessControlUtility;

public final class GPTool {
    private static final String OPT_APDU = "apdu";
    private static final String OPT_APPLET = "applet";
    private static final String OPT_BS = "bs";
    private static final String OPT_CAP = "cap";
    private static final String OPT_CREATE = "create";
    private static final String OPT_DEBUG = "debug";
    private static final String OPT_DEFAULT = "default";
    private static final String OPT_DELETE = "delete";
    private static final String OPT_DELETE_KEY = "delete-key";
    private static final String OPT_DOMAIN = "domain";
    private static final String OPT_DUMP = "dump";
    private static final String OPT_EMV = "emv";
    private static final String OPT_FORCE = "force";
    private static final String OPT_INFO = "info";
    private static final String OPT_INITIALIZED = "initialized";
    private static final String OPT_INSTALL = "install";
    private static final String OPT_KCV = "kcv";
    private static final String OPT_KEY = "key";
    private static final String OPT_KEYS = "keys";
    private static final String OPT_KEY_ENC = "key-enc";
    private static final String OPT_KEY_ID = "key-id";
    private static final String OPT_KEY_DEK = "key-dek";
    private static final String OPT_KEY_MAC = "key-mac";
    private static final String OPT_KEY_VERSION = "key-ver";
    private static final String OPT_LIST = "list";
    private static final String OPT_LIST_PRIVS = "list-privs";
    private static final String OPT_LOAD = "load";
    private static final String OPT_LOCK = "lock";
    private static final String OPT_LOCK_APPLET = "lock-applet";
    private static final String OPT_LOCK_CARD = "lock-card";
    private static final String OPT_MAKE_DEFAULT = "make-default";
    private static final String OPT_NEW_KEY_VERSION = "new-keyver";
    private static final String OPT_OP201 = "op201";
    private static final String OPT_PACKAGE = "package";
    private static final String OPT_PARAMS = "params";
    private static final String OPT_PRIVS = "privs";
    private static final String OPT_READER = "reader";
    private static final String OPT_RENAME_ISD = "rename-isd";
    private static final String OPT_REPLAY = "replay";
    private static final String OPT_SC_MODE = "mode";
    private static final String OPT_SDAID = "sdaid";
    private static final String OPT_SECURE_APDU = "secure-apdu";
    private static final String OPT_SECURED = "secured";
    private static final String OPT_STORE_DATA = "store-data";
    private static final String OPT_TERMINALS = "terminals";
    private static final String OPT_TERMINATE = "terminate";
    private static final String OPT_UNINSTALL = "uninstall";
    private static final String OPT_UNLOCK = "unlock";
    private static final String OPT_UNLOCK_APPLET = "unlock-applet";
    private static final String OPT_UNLOCK_CARD = "unlock-card";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_VERSION = "version";
    private static final String OPT_VISA2 = "visa2";
    private static final String OPT_ORACLE = "oracle";
    private static final String OPT_ACR_LIST = "acr-list";
    private static final String OPT_ACR_ADD = "acr-add";
    private static final String OPT_ACR_DELETE = "acr-delete";
    private static final String OPT_ACR_RULE = "acr-rule";
    private static final String OPT_ACR_CERT_HASH = "acr-hash";

    private static OptionSet parseArguments(String[] argv) throws IOException {
        OptionSet args = null;
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("V", OPT_VERSION), "Show information about the program");
        parser.acceptsAll(Arrays.asList("h", "?", "help"), "Shows this help string").forHelp();
        parser.acceptsAll(Arrays.asList("d", OPT_DEBUG), "Show PC/SC and APDU trace");
        parser.acceptsAll(Arrays.asList("v", OPT_VERBOSE), "Be verbose about operations");
        parser.acceptsAll(Arrays.asList("r", OPT_READER), "Use specific reader").withRequiredArg();
        parser.acceptsAll(Arrays.asList("l", OPT_LIST), "List the contents of the card");
        parser.acceptsAll(Arrays.asList("i", OPT_INFO), "Show information");
        parser.acceptsAll(Arrays.asList("a", OPT_APDU), "Send raw APDU (hex)").withRequiredArg().describedAs("APDU");
        parser.acceptsAll(Arrays.asList("s", OPT_SECURE_APDU), "Send raw APDU (hex) via SCP").withRequiredArg().describedAs("APDU");
        parser.acceptsAll(Arrays.asList("f", OPT_FORCE), "Force operation");
        parser.accepts(OPT_DUMP, "Dump APDU communication to <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_REPLAY, "Replay APDU responses from <File>").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_TERMINALS, "Use PC/SC provider from <jar:class>").withRequiredArg();
        parser.accepts(OPT_CAP, "Use a CAP file as source").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_LOAD, "Load a CAP file").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_INSTALL, "Install applet(s) from CAP").withOptionalArg().ofType(File.class);
        parser.accepts(OPT_PARAMS, "Installation parameters").withRequiredArg().describedAs("HEX");
        parser.accepts(OPT_PRIVS, "Specify privileges for installation").withRequiredArg();
        parser.accepts(OPT_LIST_PRIVS, "List known privileges");
        parser.accepts(OPT_UNINSTALL, "Uninstall applet/package").withRequiredArg().ofType(File.class);
        parser.accepts(OPT_DEFAULT, "Indicate Default Selected privilege");
        parser.accepts(OPT_TERMINATE, "Indicate Card Lock+Terminate privilege");
        parser.accepts(OPT_DOMAIN, "Create supplementary security domain").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_LOCK_APPLET, "Lock applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_UNLOCK_APPLET, "Unlock applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_LOCK_CARD, "Lock card");
        parser.accepts(OPT_UNLOCK_CARD, "Unlock card");
        parser.accepts(OPT_SECURED, "Transition ISD to SECURED state");
        parser.accepts(OPT_INITIALIZED, "Transition ISD to INITIALIZED state");
        parser.accepts(OPT_STORE_DATA, "STORE DATA to applet").withRequiredArg().describedAs("data");
        parser.accepts(OPT_MAKE_DEFAULT, "Make AID the default").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_RENAME_ISD, "Rename ISD").withRequiredArg().describedAs("new AID");
        parser.accepts(OPT_DELETE, "Delete applet/package").withOptionalArg().describedAs("AID");
        parser.accepts(OPT_DELETE_KEY, "Delete key with version").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_CREATE, "Create new instance of an applet").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_APPLET, "Applet AID").withRequiredArg().describedAs("AID");
        parser.acceptsAll(Arrays.asList(OPT_PACKAGE, "pkg"), "Package AID").withRequiredArg().describedAs("AID");
        parser.accepts(OPT_KEY, "Specify master key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KCV, "Specify master key check value").withRequiredArg().describedAs("KCV");
        parser.accepts(OPT_KEY_MAC, "Specify card MAC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KEY_ENC, "Specify card ENC key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_KEY_DEK, "Specify card DEK key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_EMV, "Use EMV diversification");
        parser.accepts(OPT_VISA2, "Use VISA2 diversification");
        parser.accepts(OPT_ORACLE, "Use an oracle for keying information").withOptionalArg().describedAs("URL");
        parser.accepts(OPT_KEY_ID, "Specify key ID").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_KEY_VERSION, "Specify key version").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_LOCK, "Set new key").withRequiredArg().describedAs(OPT_KEY);
        parser.accepts(OPT_UNLOCK, "Set default key for card key");
        parser.accepts(OPT_NEW_KEY_VERSION, "Key version for the new key").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_ACR_LIST, "List access rules");
        parser.accepts(OPT_ACR_ADD, "Add an access rule");
        parser.accepts(OPT_ACR_DELETE, "Delete an access rule");
        parser.accepts(OPT_ACR_RULE, "Access control rule (can be 0x00(NEVER),0x01(ALWAYS) or an apdu filter").withRequiredArg();
        parser.accepts(OPT_ACR_CERT_HASH, "Certificate hash (sha1)").withRequiredArg();
        parser.accepts(OPT_SC_MODE, "Secure channel to use (mac/enc/clr)").withRequiredArg();
        parser.accepts(OPT_BS, "maximum APDU payload size").withRequiredArg().ofType(Integer.class);
        parser.accepts(OPT_OP201, "Enable OpenPlatform 2.0.1 mode");
        parser.accepts(OPT_SDAID, "ISD AID").withRequiredArg().describedAs("AID");
        try {
            args = parser.parse(argv);
        }
        catch (OptionException e) {
            if (e.getCause() != null) {
                System.err.println(e.getMessage() + ": " + e.getCause().getMessage());
            } else {
                System.err.println(e.getMessage());
            }
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        if (args.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws Exception {
        OptionSet args = GPTool.parseArguments(argv);
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        if (args.has(OPT_VERBOSE)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", OPT_DEBUG);
        } else if (args.has(OPT_DEBUG)) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "trace");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "warn");
        }
        if (args.has(OPT_VERSION) || args.has(OPT_VERBOSE) || args.has(OPT_DEBUG) || args.has(OPT_INFO)) {
            String version = GlobalPlatform.getVersion();
            version = version + "\nRunning on " + System.getProperty("os.name");
            version = version + " " + System.getProperty("os.version");
            version = version + " " + System.getProperty("os.arch");
            version = version + ", Java " + System.getProperty("java.version");
            version = version + " by " + System.getProperty("java.vendor");
            System.out.println("GlobalPlatformPro " + version);
            if (Cipher.getMaxAllowedKeyLength("AES") == 128) {
                System.out.println("Unlimited crypto policy is NOT installed!");
            }
        }
        CAPFile cap = null;
        if (args.has(OPT_CAP)) {
            File capfile = (File)args.valueOf(OPT_CAP);
            cap = new CAPFile(new FileInputStream(capfile));
            if (args.has(OPT_INFO)) {
                System.out.println("**** CAP info of " + capfile.getName());
                cap.dump(System.out);
            }
        }
        if (args.has(OPT_LIST_PRIVS)) {
            System.out.println("# Known privileges:");
            System.out.println(Arrays.asList(GPRegistryEntry.Privilege.values()).stream().map(i -> i.toString()).collect(Collectors.joining("\n")));
        }
        try {
            List<CardTerminal> do_readers;
            TerminalFactory tf;
            if (args.has(OPT_REPLAY)) {
                File f = (File)args.valueOf(OPT_REPLAY);
                tf = TerminalFactory.getInstance("PC/SC", (Object)new FileInputStream(f), (Provider)new APDUReplayProvider());
            } else {
                tf = TerminalManager.getTerminalFactory((String)((String)args.valueOf(OPT_TERMINALS)));
            }
            CardTerminals terminals = tf.terminals();
            if (args.has(OPT_DEBUG)) {
                System.out.println("# Detected readers from " + tf.getProvider().getName());
                for (CardTerminal term : terminals.list()) {
                    System.out.println((term.isCardPresent() ? "[*] " : "[ ] ") + term.getName());
                }
            }
            if (args.has(OPT_READER) || System.getenv("GP_READER") != null) {
                CardTerminal t;
                String reader = System.getenv("GP_READER");
                if (args.has(OPT_READER)) {
                    reader = (String)args.valueOf(OPT_READER);
                }
                if ((t = terminals.getTerminal(reader)) == null) {
                    GPTool.fail("Reader \"" + reader + "\" not found.");
                }
                do_readers = Arrays.asList(t);
            } else {
                do_readers = terminals.list(CardTerminals.State.CARD_PRESENT);
            }
            if (do_readers.size() == 0) {
                GPTool.fail("No smart card readers with a card found");
            }
            for (CardTerminal reader : do_readers) {
                if (do_readers.size() > 1) {
                    System.out.println("# " + reader.getName());
                }
                if (args.has(OPT_DEBUG)) {
                    FileOutputStream o = null;
                    if (args.has(OPT_DUMP)) {
                        File f = (File)args.valueOf(OPT_DUMP);
                        o = new FileOutputStream(f);
                    }
                    reader = LoggingCardTerminal.getInstance((CardTerminal)reader, o);
                }
                Card card = null;
                try {
                    List<GPKey> current;
                    AID instanceAID;
                    AID appletAID;
                    AID packageAID;
                    CAPFile instcap;
                    File capfile;
                    PlaintextKeys keys;
                    try {
                        card = reader.connect("*");
                        card.beginExclusive();
                    }
                    catch (CardException e) {
                        System.err.println("Could not connect to " + reader.getName() + ": " + TerminalManager.getExceptionMessage((Exception)e));
                        if (card == null) continue;
                        card.endExclusive();
                        card.disconnect(true);
                        card = null;
                        continue;
                    }
                    if (args.has(OPT_INFO) || args.has(OPT_VERBOSE)) {
                        System.out.println("Reader: " + reader.getName());
                        System.out.println("ATR: " + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println("More information about your card:");
                        System.out.println("    http://smartcard-atr.appspot.com/parse?ATR=" + HexUtils.bin2hex((byte[])card.getATR().getBytes()));
                        System.out.println();
                    }
                    if (args.has(OPT_APDU)) {
                        for (Object s : args.valuesOf(OPT_APDU)) {
                            CommandAPDU c = new CommandAPDU((byte[])s);
                            card.getBasicChannel().transmit(c);
                        }
                    }
                    GlobalPlatform gp = args.has(OPT_SDAID) ? GlobalPlatform.connect(card.getBasicChannel(), AID.fromString(args.valueOf(OPT_SDAID))) : GlobalPlatform.discover(card.getBasicChannel());
                    if (args.has(OPT_KEYS)) {
                        GPTool.fail("Not yet implemented");
                        keys = PlaintextKeys.fromMasterKey(GPData.defaultKey);
                    } else if (args.has(OPT_ORACLE)) {
                        keys = PythiaKeys.ask(card.getATR().getBytes(), gp.fetchCPLC(), gp.getKeyInfoTemplateBytes());
                    } else {
                        PlaintextKeys keyz;
                        if (args.has(OPT_KEY)) {
                            GPKey k = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf(OPT_KEY))));
                            if (args.has(OPT_KCV)) {
                                byte[] given = HexUtils.stringToBin((String)((String)args.valueOf(OPT_KCV)));
                                byte[] expected = k.getKCV();
                                if (expected.length == 0) {
                                    GPTool.fail("Don't know how to calculate KCV for the key");
                                }
                                if (!Arrays.equals(given, expected)) {
                                    GPTool.fail("KCV does not match, expected " + HexUtils.bin2hex((byte[])expected) + " but given " + HexUtils.bin2hex((byte[])given));
                                }
                            }
                            keyz = PlaintextKeys.fromMasterKey(k);
                        } else if (args.has(OPT_KEY_MAC) && args.has(OPT_KEY_ENC) && args.has(OPT_KEY_DEK)) {
                            GPKey enc = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf(OPT_KEY_ENC))));
                            GPKey mac = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf(OPT_KEY_MAC))));
                            GPKey dek = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf(OPT_KEY_DEK))));
                            keyz = PlaintextKeys.fromKeys(enc, mac, dek);
                        } else {
                            System.out.println("Warning: no keys given, using default test key " + HexUtils.bin2hex((byte[])GPData.defaultKeyBytes));
                            keyz = PlaintextKeys.fromMasterKey(GPData.defaultKey);
                        }
                        if (args.has(OPT_VISA2)) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.VISA2);
                        } else if (args.has(OPT_EMV)) {
                            keyz.setDiversifier(PlaintextKeys.Diversification.EMV);
                        }
                        if (args.has(OPT_KEY_VERSION)) {
                            keyz.setVersion((Integer)args.valueOf(OPT_KEY_VERSION));
                        }
                        keys = keyz;
                    }
                    if (args.has(OPT_OP201)) {
                        gp.setSpec(GlobalPlatform.GPSpec.OP201);
                    }
                    if (args.has(OPT_BS)) {
                        gp.setBlockSize((Integer)args.valueOf(OPT_BS));
                    }
                    if (args.has(OPT_ACR_LIST)) {
                        SEAccessControlUtility.acrList(gp, card);
                    }
                    if (args.has(OPT_INFO)) {
                        System.out.println("***** Card info:");
                        GPData.print_card_info(gp);
                    }
                    if (!GPTool.needsAuthentication(args)) continue;
                    Object mode = GlobalPlatform.defaultMode.clone();
                    if (args.has(OPT_SC_MODE)) {
                        ((AbstractCollection)mode).clear();
                        ((AbstractCollection)mode).add(GlobalPlatform.APDUMode.fromString((String)args.valueOf(OPT_SC_MODE)));
                    }
                    gp.openSecureChannel(keys, null, 0, (EnumSet<GlobalPlatform.APDUMode>)mode);
                    if (args.has(OPT_SECURE_APDU)) {
                        for (Object s : args.valuesOf(OPT_SECURE_APDU)) {
                            CommandAPDU c = new CommandAPDU(HexUtils.stringToBin((String)((String)s)));
                            gp.transmit(c);
                        }
                    }
                    if (args.has(OPT_DELETE)) {
                        GPRegistry reg = gp.getRegistry();
                        if (args.has(OPT_DEFAULT) && reg.getDefaultSelectedAID() != null) {
                            if (reg.getDefaultSelectedPackageAID() != null) {
                                gp.deleteAID(reg.getDefaultSelectedPackageAID(), true);
                            } else {
                                System.err.println("Could not identify default selected application!");
                            }
                        }
                        List aids = args.valuesOf(OPT_DELETE);
                        for (String s : aids) {
                            AID aid = AID.fromString(s);
                            try {
                                gp.deleteAID(aid, reg.allPackageAIDs().contains(aid) || args.has(OPT_FORCE));
                            }
                            catch (GPException e) {
                                if (!gp.getRegistry().allAIDs().contains(aid)) {
                                    System.err.println("Could not delete AID (not present on card): " + aid);
                                    continue;
                                }
                                System.err.println("Could not delete AID: " + aid);
                                if (e.sw != 27013) throw e;
                                System.err.println("Deletion not allowed. Some app still active?");
                            }
                        }
                    }
                    if (args.has(OPT_UNINSTALL)) {
                        capfile = (File)args.valueOf(OPT_UNINSTALL);
                        instcap = new CAPFile(new FileInputStream(capfile));
                        AID aid = instcap.getPackageAID();
                        if (!gp.getRegistry().allAIDs().contains(aid)) {
                            System.out.println(aid + " is not present on card!");
                        } else {
                            gp.deleteAID(aid, true);
                            System.out.println(aid + " deleted.");
                        }
                    }
                    if (args.has(OPT_LOAD)) {
                        capfile = (File)args.valueOf(OPT_LOAD);
                        CAPFile loadcap = new CAPFile(new FileInputStream(capfile));
                        if (args.has(OPT_VERBOSE)) {
                            loadcap.dump(System.out);
                        }
                        try {
                            gp.loadCapFile(loadcap);
                        }
                        catch (GPException e) {
                            if (e.sw != 27013) throw e;
                            System.err.println("Applet loading failed. Are you sure the CAP file target is compatible with your card?");
                        }
                    }
                    if (args.has(OPT_INSTALL)) {
                        AID appaid;
                        capfile = (File)args.valueOf(OPT_INSTALL);
                        instcap = new CAPFile(new FileInputStream(capfile));
                        if (args.has(OPT_VERBOSE)) {
                            instcap.dump(System.out);
                        }
                        if (instcap.getAppletAIDs().size() == 0) {
                            GPTool.fail("No applets in CAP, use --load instead");
                        }
                        if (instcap.getAppletAIDs().size() > 1) {
                            if (!args.has(OPT_APPLET)) {
                                GPTool.fail("CAP contains more than one applet, specify the right one with --applet");
                                return;
                            }
                            appaid = AID.fromString(args.valueOf(OPT_APPLET));
                        } else {
                            appaid = instcap.getAppletAIDs().get(0);
                        }
                        AID instanceaid = args.has(OPT_CREATE) ? AID.fromString(args.valueOf(OPT_CREATE)) : appaid;
                        GPRegistry reg = gp.getRegistry();
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        if (args.has(OPT_FORCE) && reg.getDefaultSelectedAID() != null && privs.has(GPRegistryEntry.Privilege.CardReset)) {
                            gp.deleteAID(reg.getDefaultSelectedAID(), false);
                        }
                        if (args.has(OPT_FORCE) && reg.allPackageAIDs().contains(instcap.getPackageAID())) {
                            gp.deleteAID(instcap.getPackageAID(), true);
                        }
                        try {
                            gp.loadCapFile(instcap);
                            System.out.println("CAP loaded");
                        }
                        catch (GPException e) {
                            if (e.sw != 27013) {
                                if (e.sw != 27264) throw e;
                            }
                            System.err.println("Applet loading failed. Are you sure the CAP file (JC version, packages) is compatible with your card?");
                            throw e;
                        }
                        if (gp.getRegistry().allAIDs().contains(instanceaid)) {
                            System.err.println("WARNING: Applet " + instanceaid + " already present on card");
                        }
                        gp.installAndMakeSelectable(instcap.getPackageAID(), appaid, instanceaid, privs, GPTool.getInstParams(args), null);
                    }
                    if (args.has(OPT_CREATE)) {
                        packageAID = null;
                        appletAID = null;
                        if (cap != null) {
                            packageAID = cap.getPackageAID();
                            if (cap.getAppletAIDs().size() != 1) {
                                throw new IllegalArgumentException("There should be only one applet in CAP. Use --applet instead.");
                            }
                            appletAID = cap.getAppletAIDs().get(0);
                        }
                        if (args.has(OPT_PACKAGE)) {
                            packageAID = AID.fromString(args.valueOf(OPT_PACKAGE));
                        }
                        if (args.has(OPT_APPLET)) {
                            appletAID = AID.fromString(args.valueOf(OPT_APPLET));
                        }
                        if (packageAID == null) throw new IllegalArgumentException("Need --package and --applet or --cap");
                        if (appletAID == null) {
                            throw new IllegalArgumentException("Need --package and --applet or --cap");
                        }
                        if (gp.getRegistry().allAIDs().contains(appletAID)) {
                            System.err.println("WARNING: Applet " + appletAID + " already present on card");
                        }
                        instanceAID = AID.fromString(args.valueOf(OPT_CREATE));
                        gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, GPTool.getInstPrivs(args), GPTool.getInstParams(args), null);
                    }
                    if (args.has(OPT_DOMAIN)) {
                        packageAID = new AID("A0000001515350");
                        appletAID = new AID("A000000151535041");
                        if (args.has(OPT_PACKAGE) && args.has(OPT_APPLET)) {
                            packageAID = AID.fromString(args.valueOf(OPT_PACKAGE));
                            appletAID = AID.fromString(args.valueOf(OPT_APPLET));
                        } else {
                            System.out.println("Note: using default AID-s for SSD: " + appletAID + " from " + packageAID);
                        }
                        instanceAID = AID.fromString(args.valueOf(OPT_DOMAIN));
                        GPRegistryEntry.Privileges privs = GPTool.getInstPrivs(args);
                        privs.add(GPRegistryEntry.Privilege.SecurityDomain);
                        gp.installAndMakeSelectable(packageAID, appletAID, instanceAID, privs, null, null);
                    }
                    if (args.has(OPT_STORE_DATA)) {
                        if (args.has(OPT_APPLET)) {
                            gp.storeData(AID.fromString(args.valueOf(OPT_APPLET)), HexUtils.stringToBin((String)((String)args.valueOf(OPT_STORE_DATA))));
                        } else {
                            System.err.println("Must specify target application with -applet");
                        }
                    }
                    if (args.has(OPT_ACR_ADD)) {
                        if (!args.has(OPT_ACR_CERT_HASH)) {
                            System.err.println("Must specify certificate hash with -acr-hash");
                        } else if (!args.has(OPT_APPLET)) {
                            System.err.println("Must specify target application id with -applet");
                        } else if (!args.has(OPT_ACR_RULE)) {
                            System.err.println("Must specify an access rule with -acr-rule (00, 01 or an apdu filter)");
                        } else if (HexUtils.stringToBin((String)((String)args.valueOf(OPT_ACR_CERT_HASH))).length == 20) {
                            SEAccessControlUtility.acrAdd(gp, AID.fromString(args.valueOf(OPT_APPLET)), HexUtils.stringToBin((String)((String)args.valueOf(OPT_ACR_CERT_HASH))), HexUtils.stringToBin((String)((String)args.valueOf(OPT_ACR_RULE))));
                        } else {
                            System.err.println("certificate hash must be 20 bytes");
                        }
                    }
                    if (args.has(OPT_ACR_DELETE)) {
                        if (!args.has(OPT_APPLET)) {
                            System.err.println("Must specify target application id with -applet");
                        } else if (args.has(OPT_ACR_CERT_HASH)) {
                            if (((byte[])args.valueOf(OPT_ACR_CERT_HASH)).length == 20) {
                                SEAccessControlUtility.acrDelete(gp, AID.fromString(args.valueOf(OPT_APPLET)), HexUtils.stringToBin((String)((String)args.valueOf(OPT_ACR_CERT_HASH))));
                            } else {
                                System.err.println("certificate hash must be 20 bytes");
                            }
                        } else {
                            SEAccessControlUtility.acrDelete(gp, AID.fromString(args.valueOf(OPT_APPLET)), null);
                        }
                    }
                    if (args.has(OPT_LOCK_CARD)) {
                        gp.setCardStatus((byte)127);
                    }
                    if (args.has(OPT_UNLOCK_CARD)) {
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has(OPT_INITIALIZED)) {
                        gp.setCardStatus((byte)7);
                    }
                    if (args.has(OPT_SECURED)) {
                        GPRegistryEntryApp isd = gp.getRegistry().getISD();
                        if (isd == null) {
                            GPCommands.listRegistry(gp.getRegistry(), System.out, true);
                            GPTool.fail("ISD is null");
                        }
                        if (isd.getLifeCycle() != 7 && args.has(OPT_FORCE)) {
                            gp.setCardStatus((byte)7);
                        }
                        gp.setCardStatus((byte)15);
                    }
                    if (args.has(OPT_LOCK_APPLET)) {
                        gp.lockUnlockApplet(AID.fromString(args.valueOf(OPT_LOCK_APPLET)), true);
                    }
                    if (args.has(OPT_UNLOCK_APPLET)) {
                        gp.lockUnlockApplet(AID.fromString(args.valueOf(OPT_UNLOCK_APPLET)), false);
                    }
                    if (args.has(OPT_LIST)) {
                        GPCommands.listRegistry(gp.getRegistry(), System.out, args.has(OPT_VERBOSE));
                    }
                    if (args.has(OPT_DELETE_KEY)) {
                        int keyver = (Integer)args.valueOf(OPT_DELETE_KEY);
                        System.out.println("Deleting key " + keyver);
                        gp.deleteKey(keyver);
                    }
                    if (args.has(OPT_UNLOCK)) {
                        ArrayList<GPKey> newkeys = new ArrayList<GPKey>();
                        current = gp.getKeyInfoTemplate();
                        if (current.size() != 3) {
                            throw new GPException("Template has bad length!");
                        }
                        GPKey new_key = new GPKey(GPData.defaultKeyBytes, gp.getSCPVersion() == 3 ? GPKey.Type.AES : GPKey.Type.DES3);
                        newkeys.add(new GPKey(1, current.get(0).getID(), new_key));
                        newkeys.add(new GPKey(1, current.get(1).getID(), new_key));
                        newkeys.add(new GPKey(1, current.get(2).getID(), new_key));
                        boolean replace = true;
                        if (current.get(0).getVersion() == 255) {
                            replace = false;
                        }
                        gp.putKeys(newkeys, replace);
                        System.out.println("Default " + new_key.toString() + " set as master key.");
                    }
                    if (args.has(OPT_LOCK)) {
                        boolean replace = true;
                        current = gp.getKeyInfoTemplate();
                        if (current.size() > 0 && current.get(0).getVersion() == 255) {
                            replace = false;
                        }
                        GPKey nk = new GPKey(HexUtils.stringToBin((String)((String)args.valueOf(OPT_LOCK))));
                        if (gp.getSCPVersion() == 3) {
                            nk.become(GPKey.Type.AES);
                        } else {
                            nk.become(GPKey.Type.DES3);
                        }
                        int new_version = 1;
                        if (args.has(OPT_NEW_KEY_VERSION)) {
                            new_version = (Integer)args.valueOf(OPT_NEW_KEY_VERSION);
                            System.out.println("New version: " + new_version);
                            replace = false;
                        }
                        ArrayList<GPKey> updatekeys = new ArrayList<GPKey>();
                        updatekeys.add(new GPKey(new_version, 1, nk));
                        updatekeys.add(new GPKey(new_version, 2, nk));
                        updatekeys.add(new GPKey(new_version, 3, nk));
                        gp.putKeys(updatekeys, replace);
                        System.out.println("Card locked with: " + nk.toString());
                        System.out.println("Write this down, DO NOT FORGET/LOSE IT!");
                    }
                    if (args.has(OPT_MAKE_DEFAULT)) {
                        gp.makeDefaultSelected(AID.fromString(args.valueOf(OPT_MAKE_DEFAULT)));
                    }
                    if (!args.has(OPT_RENAME_ISD)) continue;
                    gp.renameISD(AID.fromString(args.valueOf(OPT_RENAME_ISD)));
                }
                catch (GPException e) {
                    if (args.has(OPT_FORCE)) continue;
                    GPTool.fail(e.getMessage());
                }
                catch (CardException e) {
                    System.out.println("Failed to communicate with card in " + reader + ": " + e.getMessage());
                }
                finally {
                    if (card == null) continue;
                    card.endExclusive();
                    card.disconnect(true);
                    card = null;
                }
            }
        }
        catch (CardException e) {
            if (TerminalManager.getExceptionMessage((Exception)e) != null) {
                System.out.println("PC/SC failure: " + TerminalManager.getExceptionMessage((Exception)e));
            }
            e.printStackTrace();
            GPTool.fail("CardException, terminating");
        }
        System.exit(0);
    }

    private static GPRegistryEntry.Privileges getInstPrivs(OptionSet args) {
        GPRegistryEntry.Privileges privs = new GPRegistryEntry.Privileges();
        if (args.has(OPT_PRIVS)) {
            GPTool.addPrivs(privs, (String)args.valueOf(OPT_PRIVS));
        }
        if (args.has(OPT_DEFAULT)) {
            privs.add(GPRegistryEntry.Privilege.CardReset);
        }
        if (args.has(OPT_TERMINATE)) {
            privs.add(GPRegistryEntry.Privilege.CardLock);
            privs.add(GPRegistryEntry.Privilege.CardTerminate);
        }
        return privs;
    }

    private static GPRegistryEntry.Privileges addPrivs(GPRegistryEntry.Privileges privs, String v) {
        String[] parts;
        if (v == null) {
            return privs;
        }
        for (String s : parts = v.split(",")) {
            GPRegistryEntry.Privilege p = GPRegistryEntry.Privilege.lookup(s.trim());
            if (p == null) {
                throw new IllegalArgumentException("Unknown privilege: " + s.trim());
            }
            privs.add(p);
        }
        return privs;
    }

    private static byte[] getInstParams(OptionSet args) {
        byte[] params = null;
        if (args.has(OPT_PARAMS)) {
            params = HexUtils.stringToBin((String)((String)args.valueOf(OPT_PARAMS)));
            if (params == null || params.length == 0) {
                return params;
            }
            if (params[0] != -55) {
                byte[] newparams = new byte[params.length + 2];
                newparams[0] = -55;
                newparams[1] = (byte)params.length;
                System.arraycopy(params, 0, newparams, 2, params.length);
                params = newparams;
            }
        }
        return params;
    }

    private static boolean needsAuthentication(OptionSet args) {
        if (args.has(OPT_LIST) || args.has(OPT_LOAD) || args.has(OPT_INSTALL)) {
            return true;
        }
        if (args.has(OPT_DELETE_KEY) || args.has(OPT_DELETE) || args.has(OPT_CREATE)) {
            return true;
        }
        if (args.has(OPT_ACR_ADD) || args.has(OPT_ACR_DELETE)) {
            return true;
        }
        if (args.has(OPT_LOCK) || args.has(OPT_UNLOCK) || args.has(OPT_MAKE_DEFAULT)) {
            return true;
        }
        if (args.has(OPT_UNINSTALL) || args.has(OPT_SECURE_APDU) || args.has(OPT_DOMAIN)) {
            return true;
        }
        if (args.has(OPT_LOCK_CARD) || args.has(OPT_UNLOCK_CARD) || args.has(OPT_LOCK_APPLET) || args.has(OPT_UNLOCK_APPLET)) {
            return true;
        }
        return args.has(OPT_STORE_DATA) || args.has(OPT_INITIALIZED) || args.has(OPT_SECURED) || args.has(OPT_RENAME_ISD);
    }

    private static void fail(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

