/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import pro.javacard.CAPFile;

public class CAPFileSigner {
    static final ECParameterSpec secp256r1;

    public static void addSignature(CAPFile cap, PrivateKey key) throws GeneralSecurityException {
        ECPrivateKey ekey;
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rkey = (RSAPrivateKey)key;
            if ((rkey.getModulus().bitLength() + 7) / 8 == 128) {
                Signature signer = Signature.getInstance("SHA1withRSA");
                signer.initSign(key);
                signer.update(cap.getLoadFileDataHash("SHA1"));
                byte[] dap = signer.sign();
                cap.entries.put("META-INF/dap.rsa.sha1", dap);
                signer.initSign(key);
                signer.update(cap.getLoadFileDataHash("SHA-256"));
                dap = signer.sign();
                cap.entries.put("META-INF/dap.rsa.sha256", dap);
                return;
            }
        } else if (key instanceof ECPrivateKey && (ekey = (ECPrivateKey)key).getParams().equals(secp256r1)) {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA-1"));
            byte[] dap = signer.sign();
            cap.entries.put("META-INF/dap.p256.sha1", dap);
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA-256"));
            dap = signer.sign();
            cap.entries.put("META-INF/dap.p256.sha256", dap);
            return;
        }
        throw new IllegalArgumentException("Only 1024 bit RSA and P256 EC keys are supported!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrivateKey pem2privatekey(String f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            PEMParser pem = new PEMParser((Reader)new InputStreamReader((InputStream)in, "UTF-8"));
            Object ohh = pem.readObject();
            if (ohh instanceof PEMKeyPair) {
                PEMKeyPair kp = (PEMKeyPair)ohh;
                PrivateKey privateKey = new JcaPEMKeyConverter().getKeyPair(kp).getPrivate();
                return privateKey;
            }
            if (!(ohh instanceof PrivateKeyInfo)) throw new IllegalArgumentException("Can not read PEM");
            PrivateKey privateKey = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)ohh);
            return privateKey;
            finally {
                pem.close();
            }
        }
    }

    static {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(new ECGenParameterSpec("secp256r1"));
            KeyPair tmp = generator.generateKeyPair();
            secp256r1 = ((ECPublicKey)tmp.getPublic()).getParams();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Can not generate key for parameter extraction!");
        }
    }
}

