/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class JavaCardSDK {
    private final Version version;
    private final File path;

    public static JavaCardSDK detectSDK(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        File root = new File(path);
        if (!root.isDirectory()) {
            return null;
        }
        Version version = JavaCardSDK.detectSDKVersion(root);
        if (version == null) {
            return null;
        }
        return new JavaCardSDK(root, version);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Version detectSDKVersion(File root) {
        Version version = null;
        File libDir = new File(root, "lib");
        if (new File(libDir, "tools.jar").exists()) {
            if (new File(libDir, "api_classic-3.1.0.jar").exists()) {
                return Version.V310;
            }
            File api = new File(libDir, "api_classic.jar");
            try (ZipFile apiZip = new ZipFile(api);){
                if (apiZip.getEntry("javacard/framework/SensitiveArrays.class") != null) {
                    Version version2 = Version.V305;
                    return version2;
                }
                if (apiZip.getEntry("javacardx/framework/string/StringUtil.class") != null) {
                    Version version3 = Version.V304;
                    return version3;
                }
                Version version4 = Version.V301;
                return version4;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (new File(libDir, "api21.jar").exists()) {
            return Version.V212;
        }
        if (Files.exists(Paths.get(root.toString(), "bin", "api.jar"), new LinkOption[0])) {
            return Version.V211;
        }
        if (!new File(libDir, "converter.jar").exists()) return version;
        version = Version.V221;
        File api = new File(libDir, "api.jar");
        try (ZipFile apiZip = new ZipFile(api);){
            ZipEntry testEntry = apiZip.getEntry("javacardx/apdu/ExtendedLength.class");
            if (testEntry == null) return version;
            version = Version.V222;
            return version;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JavaCardSDK(File root, Version version) {
        this.path = root;
        this.version = version;
    }

    public File getRoot() {
        return this.path;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getJavaVersion() {
        switch (this.version) {
            case V310: {
                return "1.7";
            }
            case V301: 
            case V304: 
            case V305: {
                return "1.6";
            }
            case V222: {
                return "1.5";
            }
            case V221: {
                return "1.2";
            }
        }
        return "1.1";
    }

    public ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                try {
                    if (JavaCardSDK.this.version.isV3()) {
                        return new URLClassLoader(new URL[]{JavaCardSDK.this.getJar("tools.jar").toURI().toURL()}, this.getClass().getClassLoader());
                    }
                    return new URLClassLoader(new URL[]{JavaCardSDK.this.getJar("offcardverifier.jar").toURI().toURL()}, this.getClass().getClassLoader());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not load classes: " + e.getMessage());
                }
            }
        });
    }

    public String getRelease() {
        if (this.version == Version.V305) {
            try {
                Class<?> verifier = Class.forName("com.sun.javacard.offcardverifier.Verifier", false, this.getClassLoader());
                try {
                    verifier.getDeclaredMethod("verifyTargetPlatform", String.class);
                    return "3.0.5u3";
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        verifier.getDeclaredMethod("verifyCap", FileInputStream.class, String.class, Vector.class);
                        return "3.0.5u1";
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        return "3.0.5u2";
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not figure out SDK release: " + e.getMessage());
            }
        }
        return this.version.toString();
    }

    public File getJar(String name) {
        File libDir = new File(this.path, "lib");
        return new File(libDir, name);
    }

    public List<File> getApiJars() {
        ArrayList<File> jars = new ArrayList<File>();
        switch (this.version) {
            case V211: {
                jars.add(new File(new File(this.path, "bin"), "api.jar"));
                break;
            }
            case V212: {
                jars.add(this.getJar("api21.jar"));
                break;
            }
            case V301: 
            case V304: 
            case V305: {
                jars.add(this.getJar("api_classic.jar"));
                break;
            }
            case V310: {
                jars.add(this.getJar("api_classic-3.1.0.jar"));
                jars.add(this.getJar("api_classic_annotations-3.1.0.jar"));
                break;
            }
            default: {
                jars.add(this.getJar("api.jar"));
            }
        }
        if (this.version == Version.V304 || this.version == Version.V305) {
            jars.add(this.getJar("api_classic_annotations.jar"));
        }
        return jars;
    }

    public File getExportDir() {
        switch (this.version) {
            case V212: {
                return new File(this.path, "api21_export_files");
            }
            case V310: {
                return new File(this.path, "api_export_files_3.1.0");
            }
        }
        return new File(this.path, "api_export_files");
    }

    public List<File> getToolJars() {
        ArrayList<File> jars = new ArrayList<File>();
        if (this.version.isOneOf(Version.V211)) {
            jars.add(new File(new File(this.path, "bin"), "converter.jar"));
        } else if (this.version.isV3()) {
            jars.add(this.getJar("tools.jar"));
        } else {
            jars.add(this.getJar("converter.jar"));
            jars.add(this.getJar("offcardverifier.jar"));
        }
        return jars;
    }

    public List<File> getCompilerJars() {
        ArrayList<File> jars = new ArrayList<File>();
        if (this.version == Version.V304) {
            jars.add(this.getJar("tools.jar"));
            jars.add(this.getJar("api_classic_annotations.jar"));
        }
        return jars;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaCardSDK) {
            JavaCardSDK other = (JavaCardSDK)o;
            return this.path.getAbsolutePath().equals(other.path.getAbsolutePath()) && this.version.equals((Object)other.version);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public static enum Version {
        NONE,
        V211,
        V212,
        V221,
        V222,
        V301,
        V304,
        V305,
        V310;


        public String toString() {
            if (this.equals((Object)V310)) {
                return "3.1.0";
            }
            if (this.equals((Object)V305)) {
                return "3.0.5";
            }
            if (this.equals((Object)V304)) {
                return "3.0.4";
            }
            if (this.equals((Object)V301)) {
                return "3.0.1";
            }
            if (this.equals((Object)V222)) {
                return "2.2.2";
            }
            if (this.equals((Object)V221)) {
                return "2.2.1";
            }
            if (this.equals((Object)V212)) {
                return "2.1.2";
            }
            if (this.equals((Object)V211)) {
                return "2.1.1";
            }
            return "unknown";
        }

        public boolean isV3() {
            return this.name().startsWith("V3");
        }

        public boolean isOneOf(Version ... versions) {
            for (Version v : versions) {
                if (!this.equals((Object)v)) continue;
                return true;
            }
            return false;
        }
    }
}

