/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import pro.javacard.CAPFile;

public class CAPFileSigner {
    static final ECParameterSpec secp256r1;

    public static void addSignature(CAPFile cap, PrivateKey key) throws GeneralSecurityException {
        ECPrivateKey ekey;
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rkey = (RSAPrivateKey)key;
            if ((rkey.getModulus().bitLength() + 7) / 8 == 128) {
                Signature signer = Signature.getInstance("SHA1withRSA");
                signer.initSign(key);
                signer.update(cap.getLoadFileDataHash("SHA1"));
                byte[] dap = signer.sign();
                cap.entries.put("META-INF/dap.rsa.sha1", dap);
                signer.initSign(key);
                signer.update(cap.getLoadFileDataHash("SHA-256"));
                dap = signer.sign();
                cap.entries.put("META-INF/dap.rsa.sha256", dap);
                return;
            }
        } else if (key instanceof ECPrivateKey && (ekey = (ECPrivateKey)key).getParams().equals(secp256r1)) {
            Signature signer = Signature.getInstance("SHA256withECDSA");
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA-1"));
            byte[] dap = signer.sign();
            cap.entries.put("META-INF/dap.p256.sha1", dap);
            signer.initSign(key);
            signer.update(cap.getLoadFileDataHash("SHA-256"));
            dap = signer.sign();
            cap.entries.put("META-INF/dap.p256.sha256", dap);
            return;
        }
        throw new IllegalArgumentException("Only 1024 bit RSA and P256 EC keys are supported!");
    }

    /*
     * Exception decompiling
     */
    public static KeyPair pem2keypair(String f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(new ECGenParameterSpec("secp256r1"));
            KeyPair tmp = generator.generateKeyPair();
            secp256r1 = ((ECPublicKey)tmp.getPublic()).getParams();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Can not generate key for parameter extraction!");
        }
    }
}

