/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import pro.javacard.CAPFile;
import pro.javacard.JavaCardSDK;
import pro.javacard.VerifierError;

public class OffCardVerifier {
    private final JavaCardSDK sdk;

    @Deprecated
    public static OffCardVerifier forSDK(JavaCardSDK sdk) {
        return OffCardVerifier.withSDK(sdk);
    }

    public static OffCardVerifier withSDK(JavaCardSDK sdk) {
        if (sdk.getVersion().equals((Object)JavaCardSDK.Version.V211) || sdk.getVersion().equals((Object)JavaCardSDK.Version.V212)) {
            throw new RuntimeException("Verification is supported with JavaCard SDK 2.2.1 or later");
        }
        return new OffCardVerifier(sdk);
    }

    private OffCardVerifier(JavaCardSDK sdk) {
        this.sdk = sdk;
        if (!sdk.getRelease().equals("3.0.5u3")) {
            System.err.println("NB! Please use JavaCard SDK 3.0.5u3 or later for verifying!");
        }
    }

    public void verifyAgainst(File f, JavaCardSDK target, Vector<File> exps) throws VerifierError {
        Vector<File> exports = new Vector<File>(exps);
        exports.add(target.getExportDir());
        this.verify(f, exports);
    }

    public void verify(File f, Vector<File> exps) throws VerifierError {
        File tmp = this.makeTemp();
        try {
            CAPFile cap = CAPFile.fromStream(new FileInputStream(f));
            Class<?> verifier = Class.forName("com.sun.javacard.offcardverifier.Verifier", true, this.sdk.getClassLoader());
            final Vector<File> expfiles = new Vector<File>();
            for (File e : exps) {
                if (e.isDirectory()) {
                    Files.walkFileTree(e.toPath().toRealPath(new LinkOption[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (file.toString().endsWith(".exp")) {
                                expfiles.add(file.toFile());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                if (!e.isFile()) continue;
                if (e.toString().endsWith(".exp")) {
                    expfiles.add(e);
                    continue;
                }
                if (!e.toString().endsWith(".jar")) continue;
                expfiles.addAll(OffCardVerifier.extractExps(e, tmp));
            }
            String packagename = cap.getPackageName();
            try (FileInputStream input = new FileInputStream(f);){
                Method m;
                if (this.sdk.getRelease().equals("3.0.5u3") || this.sdk.getRelease().equals("3.0.5u2")) {
                    m = verifier.getMethod("verifyCap", File.class, String.class, Vector.class);
                    m.invoke(null, f, packagename, expfiles);
                } else {
                    m = verifier.getMethod("verifyCap", FileInputStream.class, String.class, Vector.class);
                    m.invoke(null, input, packagename, expfiles);
                }
            }
            catch (InvocationTargetException e) {
                throw new VerifierError(e.getTargetException().getMessage(), e.getTargetException());
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Could not run verifier: " + e.getMessage());
        }
        finally {
            OffCardVerifier.rmminusrf(tmp.toPath());
        }
    }

    private static void rmminusrf(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File makeTemp() {
        try {
            return Files.createTempDirectory("capfile", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can not make temporary folder", e);
        }
    }

    public static Vector<File> extractExps(File in, File out) throws IOException {
        Vector<File> exps = new Vector<File>();
        try (JarFile jarfile = new JarFile(in);){
            Enumeration<JarEntry> entries = jarfile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().toLowerCase().endsWith(".exp")) continue;
                File f = new File(out, entry.getName());
                if (!f.exists()) {
                    if (!f.getParentFile().mkdirs()) {
                        throw new IOException("Failed to create folder: " + f.getParentFile());
                    }
                    f = new File(out, entry.getName());
                }
                try (InputStream is = jarfile.getInputStream(entry);
                     FileOutputStream fo = new FileOutputStream(f);){
                    int r;
                    byte[] buf = new byte[1024];
                    while ((r = is.read(buf)) != -1) {
                        fo.write(buf, 0, r);
                    }
                }
                exps.add(f);
            }
        }
        return exps;
    }
}

