/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.stream.Collectors;
import org.bouncycastle.util.encoders.Hex;
import pro.javacard.CAPFile;
import pro.javacard.CAPFileSigner;
import pro.javacard.JavaCardSDK;
import pro.javacard.OffCardVerifier;
import pro.javacard.VerifierError;

public class CAPFileTool {
    private static final ArrayList<String> help = new ArrayList();

    private static boolean has(Vector<String> args, String v) {
        for (String s : args) {
            if (!s.equalsIgnoreCase(v)) continue;
            args.remove(s);
            return true;
        }
        return false;
    }

    public static void main(String[] argv) {
        Vector<String> args = new Vector<String>(Arrays.asList(argv));
        if (args.size() < 1 || CAPFileTool.has(args, "-h")) {
            System.err.println("Usage:");
            help.stream().forEach(s -> System.err.println((String)s));
            System.exit(1);
        }
        try {
            if (CAPFileTool.has(args, "-s")) {
                if (args.size() < 2) {
                    CAPFileTool.fail("Usage:\n" + help.get(2));
                }
                String keyfile = args.remove(0);
                Path capfile = Paths.get(args.remove(0), new String[0]);
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(capfile));
                cap.dump(System.out);
                try {
                    KeyPair kp = CAPFileSigner.pem2keypair(keyfile);
                    CAPFileSigner.addSignature(cap, kp.getPrivate());
                    Path where = capfile.getParent();
                    if (where == null) {
                        where = Paths.get(".", new String[0]);
                    }
                    Path tmpfile = Files.createTempFile(where, "capfile", "unsigned", new FileAttribute[0]);
                    cap.store(Files.newOutputStream(tmpfile, new OpenOption[0]));
                    Files.move(tmpfile, capfile, StandardCopyOption.ATOMIC_MOVE);
                    System.out.println("Signed " + capfile);
                }
                catch (GeneralSecurityException e) {
                    CAPFileTool.fail("Failed to sign: " + e.getMessage());
                }
            } else if (CAPFileTool.has(args, "-v")) {
                String capfile;
                String targetsdkpath;
                if (args.size() < 2) {
                    CAPFileTool.fail("Usage:\n" + help.get(1));
                }
                String sdkpath = args.remove(0);
                String next = args.remove(0);
                if (Files.isDirectory(Paths.get(next, new String[0]), new LinkOption[0])) {
                    targetsdkpath = next;
                    capfile = args.remove(0);
                } else {
                    capfile = next;
                    targetsdkpath = sdkpath;
                }
                Vector<File> exps = new Vector<File>(args.stream().map(i -> new File((String)i)).collect(Collectors.toList()));
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(Paths.get(capfile, new String[0])));
                cap.dump(System.out);
                try {
                    JavaCardSDK sdk = JavaCardSDK.detectSDK(sdkpath);
                    JavaCardSDK target = JavaCardSDK.detectSDK(targetsdkpath);
                    OffCardVerifier verifier = OffCardVerifier.withSDK(sdk);
                    verifier.verifyAgainst(new File(capfile), target, exps);
                    System.out.println("Verified " + capfile);
                }
                catch (VerifierError e) {
                    CAPFileTool.fail("Verification failed: " + e.getMessage());
                }
            } else if (CAPFileTool.has(args, "-sha256")) {
                if (args.size() < 1) {
                    CAPFileTool.fail("Usage:\n" + help.get(3));
                }
                String capfile = args.remove(0);
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(Paths.get(capfile, new String[0])));
                System.out.println(Hex.toHexString((byte[])cap.getLoadFileDataHash("SHA-256")));
            } else {
                String capfile = args.remove(0);
                CAPFile cap = CAPFile.fromBytes(Files.readAllBytes(Paths.get(capfile, new String[0])));
                cap.dump(System.out);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            CAPFileTool.fail(e.getMessage());
        }
    }

    private static void fail(String message) {
        System.err.println(message);
        System.exit(1);
    }

    static {
        help.add("    dump:   capfile <capfile>");
        help.add("    verify: capfile -v <sdkpath> [<targetsdkpath>] <capfile> [<expfiles...>]");
        help.add("    sign:   capfile -s <keyfile> <capfile>");
        help.add("    lfdbh:  capfile -sha256 <capfile>");
    }
}

