/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Vector;
import pro.javacard.CAPFile;
import pro.javacard.CAPPackage;
import pro.javacard.JavaCardSDK;
import pro.javacard.VerifierError;
import pro.javacard.WellKnownAID;

public class OffCardVerifier {
    private final JavaCardSDK sdk;

    public static OffCardVerifier forSDK(JavaCardSDK sdk) {
        if (sdk.getVersion().equals((Object)JavaCardSDK.Version.V21)) {
            throw new RuntimeException("Verification is supported with JavaCard SDK 2.2.1 or later");
        }
        return new OffCardVerifier(sdk);
    }

    private OffCardVerifier(JavaCardSDK sdk) {
        this.sdk = sdk;
        System.out.println("Verifying with " + sdk.getRelease());
        if (!sdk.getRelease().equals("3.0.5u3")) {
            System.err.println("NB! Please use at least JavaCard SDK 3.0.5u3 when verifying!");
        }
    }

    public void verify(File f) throws VerifierError {
        try {
            CAPFile cap = CAPFile.fromStream(new FileInputStream(f));
            for (CAPPackage p : cap.getImports()) {
                if (WellKnownAID.getJavaCardName(p.aid) != null) continue;
                throw new VerifierError("Can only verify plain JavaCard CAP files at the moment: import " + p.name);
            }
        }
        catch (IOException e) {
            throw new VerifierError("Could not open CAP: " + e.getMessage(), e);
        }
        Vector<File> exps = new Vector<File>();
        this.verify(f, exps);
    }

    public void verify(File f, Vector<File> exps) throws VerifierError {
        try {
            CAPFile cap = CAPFile.fromStream(new FileInputStream(f));
            Class<?> verifier = Class.forName("com.sun.javacard.offcardverifier.Verifier", true, this.sdk.getClassLoader());
            exps.add(this.sdk.getExportDir());
            final Vector<File> expfiles = new Vector<File>();
            for (File e : exps) {
                if (e.isDirectory()) {
                    Files.walkFileTree(e.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (file.toString().endsWith(".exp")) {
                                expfiles.add(file.toFile());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    continue;
                }
                if (!e.isFile()) continue;
                expfiles.add(e);
            }
            String packagename = cap.getPackageName();
            try (FileInputStream input = new FileInputStream(f);){
                Method m;
                if (this.sdk.getRelease().equals("3.0.5u3") || this.sdk.getRelease().equals("3.0.5u2")) {
                    m = verifier.getMethod("verifyCap", File.class, String.class, Vector.class);
                    m.invoke(null, f, packagename, expfiles);
                } else {
                    m = verifier.getMethod("verifyCap", FileInputStream.class, String.class, Vector.class);
                    m.invoke(null, input, packagename, expfiles);
                }
            }
            catch (InvocationTargetException e) {
                throw new VerifierError(e.getTargetException().getMessage(), e.getTargetException());
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Could not run verifier: " + e.getMessage());
        }
    }
}

