/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.SCTool;
import apdu4j.remote.RemoteTerminalThread;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTerminalServer {
    private static Logger logger = LoggerFactory.getLogger(RemoteTerminalServer.class);
    private static final String BACKLOG = "apdu4j.remote.http.backlog";
    private static final String HTTPPOOL = "apdu4j.remote.http.threadpool";
    private static final String SESSIONS = "apdu4j.remote.http.maxsessions";
    private static final String THREADTIMEOUT = "apdu4j.remote.thread.timeout";
    private static final String BACKENDPOOL = "apdu4j.remote.backend.threadpool";
    private final ConcurrentHashMap<UUID, Session> sessions;
    private final ExecutorService e = Executors.newFixedThreadPool(Integer.parseInt(System.getProperty("apdu4j.remote.http.threadpool", "200")));
    private final Class<? extends RemoteTerminalThread> processor;
    private HttpServer server;

    public RemoteTerminalServer(Class<? extends RemoteTerminalThread> task) {
        this.sessions = new ConcurrentHashMap(Integer.parseInt(System.getProperty(SESSIONS, "200")));
        this.processor = task;
    }

    public static void drop(HttpExchange req) throws IOException {
        RemoteTerminalServer.setStandardHeaders(req);
        req.sendResponseHeaders(418, 0L);
        try (OutputStream body = req.getResponseBody();){
            body.write(("apdu4j/" + SCTool.getVersion()).getBytes(StandardCharsets.UTF_8));
        }
    }

    public void start(InetSocketAddress address) throws IOException {
        this.server = HttpServer.create(address, Integer.parseInt(System.getProperty(BACKLOG, "10")));
        this.server.setExecutor(Executors.newWorkStealingPool(Integer.parseInt(System.getProperty(HTTPPOOL, "10"))));
        this.server.createContext("/", new MsgHandler());
        this.server.createContext("/status", new StatusHandler());
        logger.info("Server started on {} ", (Object)this.server.getAddress());
        this.server.start();
    }

    public void stop(int timeout) {
        this.server.stop(timeout);
    }

    public void gc(long oldest) {
        for (Session s : this.sessions.values()) {
            if (s.timestamp >= oldest) continue;
            logger.debug("Pruning session: {}", (Object)s.id);
            this.sessions.remove(s.id);
        }
    }

    private static void setStandardHeaders(HttpExchange req) {
        Headers h = req.getResponseHeaders();
        h.set("Server", "apdu4j/" + SCTool.getVersion());
    }

    private class StatusHandler
    implements HttpHandler {
        private StatusHandler() {
        }

        @Override
        public void handle(HttpExchange req) throws IOException {
            RemoteTerminalServer.setStandardHeaders(req);
            req.sendResponseHeaders(200, 0L);
            try (OutputStream body = req.getResponseBody();){
                String s = "apdu4j/" + SCTool.getVersion() + " OK: " + RemoteTerminalServer.this.sessions.size();
                body.write(s.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private class MsgHandler
    implements HttpHandler {
        private MsgHandler() {
        }

        private void transceive(HttpExchange r, Map<String, Object> msg, Session session) throws IOException {
            try {
                session.timestamp = System.currentTimeMillis();
                logger.trace("to thread: {}", (Object)new JSONObject(msg).toJSONString());
                if (!session.toThread.offer(msg)) {
                    logger.warn("Could not add to thread queue!");
                    throw new IOException("Could not add to thread queue!");
                }
                Map<String, Object> resp = session.fromThread.poll(Long.parseLong(System.getProperty(RemoteTerminalServer.THREADTIMEOUT, "60")), TimeUnit.SECONDS);
                if (resp == null) {
                    logger.warn("Timeout");
                    HashMap<String, String> stop = new HashMap<String, String>();
                    stop.put("cmd", "STOP");
                    stop.put("message", "Timeout waiting for reply from thread");
                    if (!session.toThread.offer(stop)) {
                        logger.warn("Could not queue STOP message");
                    }
                    throw new IOException("Timeout");
                }
                logger.trace("from thread: {}", (Object)new JSONObject(resp).toJSONString());
                resp.put("session", session.id.toString());
                JSONObject respjson = new JSONObject(resp);
                logger.trace("SEND: {}", (Object)respjson.toJSONString());
                RemoteTerminalServer.setStandardHeaders(r);
                r.getResponseHeaders().set("Content-type", "application/json");
                byte[] payload = respjson.toJSONString().getBytes("UTF-8");
                r.sendResponseHeaders(200, payload.length);
                try (OutputStream body = r.getResponseBody();){
                    body.write(payload);
                }
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted");
                throw new IOException(e);
            }
        }

        @Override
        public void handle(HttpExchange req) throws IOException {
            if (req.getRequestMethod().equals("POST")) {
                try (InputStream inp = req.getRequestBody();){
                    Headers h = req.getRequestHeaders();
                    int len = Integer.parseInt(h.getFirst("Content-Length"));
                    logger.trace("Content-length: {}", (Object)len);
                    if (len > 2048 || len <= 0) {
                        logger.info("Too huge request, dropping");
                        RemoteTerminalServer.drop(req);
                    }
                    byte[] data = new byte[len];
                    int readlen = inp.read(data);
                    if (readlen == len) {
                        UUID sid;
                        JSONObject msg;
                        try {
                            JSONObject obj = (JSONObject)JSONValue.parseWithException((String)new String(data, "UTF-8"));
                            logger.trace("RECV: {}", (Object)obj.toJSONString());
                            msg = obj;
                        }
                        catch (ParseException e) {
                            throw new IOException("Could not parse JSON", e);
                        }
                        if (req.getRequestHeaders().containsKey("X-Forwarded-For")) {
                            msg.put("clientip", req.getRequestHeaders().getFirst("X-Forwarded-For"));
                        } else {
                            msg.put("clientip", req.getRemoteAddress().getHostString());
                        }
                        if (!msg.containsKey("session")) {
                            try {
                                sid = UUID.randomUUID();
                                logger.debug("New session: {}", (Object)sid.toString());
                                Session sess = new Session(sid);
                                msg.put("session", sid.toString());
                                if (req.getRequestHeaders().containsKey("User-Agent")) {
                                    msg.put("useragent", req.getRequestHeaders().getFirst("User-Agent"));
                                }
                                RemoteTerminalThread thread = (RemoteTerminalThread)RemoteTerminalServer.this.processor.newInstance();
                                thread.setQueues(sess.toThread, sess.fromThread);
                                thread.setSession(sid.toString());
                                RemoteTerminalServer.this.e.execute(thread);
                                this.transceive(req, (Map<String, Object>)msg, sess);
                                RemoteTerminalServer.this.sessions.put(sid, sess);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                                logger.error("Could not start worker thread", (Throwable)e);
                                throw new RuntimeException("Could not initiate a worker thread!", e);
                            }
                        }
                        sid = UUID.fromString((String)msg.get("session"));
                        if (!RemoteTerminalServer.this.sessions.containsKey(sid)) {
                            logger.warn("Session {} not found", (Object)sid.toString());
                            RemoteTerminalServer.drop(req);
                            return;
                        }
                        logger.trace("Resuming session {}", (Object)sid.toString());
                        Session sess = (Session)RemoteTerminalServer.this.sessions.get(sid);
                        try {
                            this.transceive(req, (Map<String, Object>)msg, sess);
                        }
                        catch (IOException e) {
                            logger.debug("Thread communication failed, removing session", (Throwable)e);
                            RemoteTerminalServer.this.sessions.remove(sid);
                            throw e;
                        }
                    }
                    logger.debug("Read {} instead, closing", (Object)readlen);
                    RemoteTerminalServer.drop(req);
                    return;
                }
            } else {
                RemoteTerminalServer.drop(req);
                return;
            }
        }
    }

    static class Session {
        final UUID id;
        final BlockingQueue<Map<String, Object>> toThread;
        final BlockingQueue<Map<String, Object>> fromThread;
        long timestamp;

        Session(UUID sid) {
            this.id = sid;
            this.toThread = new ArrayBlockingQueue<Map<String, Object>>(1);
            this.fromThread = new ArrayBlockingQueue<Map<String, Object>>(1);
            this.timestamp = System.currentTimeMillis();
        }
    }
}

