/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.JSONProtocol;
import java.io.IOException;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

class JSONCardTerminalClient {
    private final CardTerminal terminal;
    private final JSONMessagePipe pipe;
    protected Card card = null;
    String protocol = null;
    boolean transact = true;

    public JSONCardTerminalClient(CardTerminal terminal, JSONMessagePipe pipe) {
        this.terminal = terminal;
        this.pipe = pipe;
    }

    public boolean processMessage(Map<String, Object> msg) throws IOException, CardException {
        if (!msg.containsKey("cmd")) {
            throw new IOException("No command field in message: " + msg.toString());
        }
        String cmd = (String)msg.get("cmd");
        if (cmd.equals("CONNECT")) {
            try {
                if (msg.containsKey("protocol") && this.protocol == null) {
                    this.protocol = (String)msg.get("protocol");
                }
                this.card = this.terminal.connect(this.protocol);
                if (this.transact) {
                    this.card.beginExclusive();
                }
                Map<String, Object> m = JSONProtocol.ok(msg);
                m.put("atr", HexUtils.bin2hex(this.card.getATR().getBytes()));
                m.put("reader", this.terminal.getName());
                m.put("protocol", this.card.getProtocol());
                this.pipe.send(m);
            }
            catch (CardException e) {
                this.fail(msg, e);
                throw e;
            }
        } else if (cmd.equals("APDU")) {
            try {
                CommandAPDU command = new CommandAPDU(HexUtils.stringToBin((String)msg.get("bytes")));
                ResponseAPDU r = this.card.getBasicChannel().transmit(command);
                Map<String, Object> m = JSONProtocol.ok(msg);
                m.put("bytes", HexUtils.bin2hex(r.getBytes()));
                this.pipe.send(m);
            }
            catch (CardException e) {
                this.fail(msg, e);
            }
        } else if (cmd.equals("DISCONNECT")) {
            try {
                this.card.endExclusive();
                this.card.disconnect(true);
                this.pipe.send(JSONProtocol.ok(msg));
            }
            catch (CardException e) {
                this.fail(msg, e);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        return this.card != null;
    }

    private void fail(Map<String, Object> msg, Exception e) throws IOException {
        this.pipe.send(JSONProtocol.nok(msg, TerminalManager.getExceptionMessage(e)));
    }
}

