/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.JSONProtocol;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

class JSONCardTerminal
extends CardTerminal {
    private String terminalName = null;
    private ATR atr = null;
    private String protocol = null;
    private final JSONMessagePipe client;

    public JSONCardTerminal(JSONMessagePipe c) {
        this.client = c;
    }

    @Override
    public Card connect(String protocol) throws CardException {
        try {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("cmd", "CONNECT");
            m.put("protocol", protocol);
            this.client.send(m);
            Map<String, Object> r = this.client.recv();
            if (r.containsKey("CONNECT") && ((String)r.get("CONNECT")).equals("OK") && r.containsKey("atr") && r.containsKey("protocol") && r.containsKey("reader")) {
                this.terminalName = (String)r.get("reader");
                this.atr = new ATR(HexUtils.stringToBin((String)r.get("atr")));
                this.protocol = (String)r.get("protocol");
                return new JSONCard(this);
            }
            throw new CardException("Could not connect to client");
        }
        catch (IOException e) {
            throw new CardException("Could not connect to client", e);
        }
    }

    @Override
    public String getName() {
        if (this.terminalName == null) {
            return "RemoteTerminal (not connected)";
        }
        return "RemoteTerminal (" + this.terminalName + ")";
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return true;
    }

    @Override
    public boolean waitForCardAbsent(long arg0) throws CardException {
        throw new CardException("JSONCardTerminal does not support polling for card removal");
    }

    @Override
    public boolean waitForCardPresent(long arg0) throws CardException {
        throw new CardException("JSONCardTerminal does not support polling");
    }

    private class JSONCard
    extends Card {
        private final JSONCardTerminal terminal;
        private JSONCardChannel channel = null;

        protected JSONCard(JSONCardTerminal t) {
            this.terminal = t;
        }

        @Override
        public void beginExclusive() throws CardException {
        }

        @Override
        public void disconnect(boolean reset) throws CardException {
            try {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("cmd", "DISCONNECT");
                m.put("action", reset ? "reset" : "leave");
                this.terminal.client.send(m);
                this.terminal.client.recv();
            }
            catch (IOException e) {
                throw new CardException("Disconnect failed", e);
            }
        }

        @Override
        public void endExclusive() throws CardException {
        }

        @Override
        public ATR getATR() {
            return JSONCardTerminal.this.atr;
        }

        @Override
        public synchronized CardChannel getBasicChannel() {
            if (this.channel == null) {
                this.channel = new JSONCardChannel(this);
            }
            return this.channel;
        }

        @Override
        public String getProtocol() {
            return JSONCardTerminal.this.protocol;
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            throw new CardException("JSONCard does not support logical channels");
        }

        @Override
        public byte[] transmitControlCommand(int arg0, byte[] arg1) throws CardException {
            throw new CardException("JSONCard does not yet support control commands");
        }

        protected class JSONCardChannel
        extends CardChannel {
            private final JSONCard card;

            public JSONCardChannel(JSONCard c) {
                this.card = c;
            }

            @Override
            public void close() throws CardException {
            }

            @Override
            public Card getCard() {
                return this.card;
            }

            @Override
            public int getChannelNumber() {
                return 0;
            }

            @Override
            public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
                try {
                    String apdustring = HexUtils.bin2hex(apdu.getBytes());
                    Map<String, Object> m = JSONProtocol.cmd("APDU");
                    m.put("bytes", apdustring);
                    JSONCardTerminal.this.client.send(m);
                    Map<String, Object> r = JSONCardTerminal.this.client.recv();
                    if (!JSONProtocol.check(m, r)) {
                        throw new CardException((String)r.get("ERROR"));
                    }
                    return new ResponseAPDU(HexUtils.hex2bin((String)r.get("bytes")));
                }
                catch (IOException e) {
                    throw new CardException(e);
                }
            }

            @Override
            public int transmit(ByteBuffer arg0, ByteBuffer arg1) throws CardException {
                throw new CardException("JSONCardChannel only supports APDU based interface");
            }
        }
    }
}

