/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import apdu4j.remote.JSONCardTerminalClient;
import apdu4j.remote.JSONMessagePipe;
import apdu4j.remote.JSONProtocol;
import java.io.Console;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class CmdlineRemoteTerminal
implements Runnable {
    private JSONMessagePipe pipe;
    JSONCardTerminalClient jsonterminal;

    public CmdlineRemoteTerminal(JSONMessagePipe pipe, CardTerminal terminal) {
        this.pipe = pipe;
        this.jsonterminal = new JSONCardTerminalClient(terminal, pipe);
    }

    @Override
    public void run() {
        try {
            Map<String, Object> m;
            Map<String, Object> st = JSONProtocol.cmd("start");
            st.put("lang", Locale.getDefault().getLanguage());
            this.pipe.send(st);
            while (this.jsonterminal.processMessage(m = this.pipe.recv()) || this.processMessage(m)) {
            }
        }
        catch (IOException e) {
            System.out.println("Messaging failed: " + e.getMessage());
        }
        catch (CardException e) {
            System.out.println("\nReader failed: " + TerminalManager.getExceptionMessage(e));
        }
    }

    public void forceProtocol(String protocol) {
        this.jsonterminal.protocol = protocol;
    }

    public void transact(boolean yes) {
        this.jsonterminal.transact = yes;
    }

    private void verify(Map<String, Object> msg) throws IOException {
        if (!this.jsonterminal.isConnected()) {
            throw new IllegalStateException("Can not verify PIN codes if no connection to a card is established!");
        }
        Console c = System.console();
        int p2 = ((Long)msg.get("p2")).intValue();
        System.out.println((String)msg.get("text"));
        char[] input = c.readPassword("Enter PIN: ", new Object[0]);
        if (input == null) {
            this.pipe.send(JSONProtocol.nok(msg, "No pin entered"));
            return;
        }
        byte[] pin = new String(input).getBytes(StandardCharsets.UTF_8);
        CommandAPDU verify = new CommandAPDU(0, 32, 0, p2, pin);
        try {
            ResponseAPDU r = this.jsonterminal.card.getBasicChannel().transmit(verify);
            Map<String, Object> m = null;
            if (r.getSW() == 36864) {
                m = JSONProtocol.ok(msg);
            } else {
                m = JSONProtocol.nok(msg, "Verification failed");
                m.put("bytes", HexUtils.bin2hex(r.getBytes()));
            }
            this.pipe.send(m);
        }
        catch (CardException e) {
            this.pipe.send(JSONProtocol.nok(msg, e.getMessage()));
        }
    }

    private void dialog(Map<String, Object> msg) throws IOException {
        System.out.println("# " + msg.get("text"));
        Map<String, Object> m = JSONProtocol.ok(msg);
        boolean yes = this.get_yes_or_no_console("Decision");
        if (!yes) {
            m.put("button", "red");
        } else {
            m.put("button", "green");
        }
        this.pipe.send(m);
    }

    private void input(Map<String, Object> msg) throws IOException {
        System.out.println("# " + msg.get("text"));
        Map<String, Object> m = JSONProtocol.ok(msg);
        Console c = System.console();
        String input = c.readLine("> ", new Object[0]);
        if (input == null) {
            Map<String, Object> nack = JSONProtocol.nok(msg, "Input was null");
            this.pipe.send(nack);
            return;
        }
        input = input.trim();
        System.out.println("> \"" + input + "\"");
        boolean yes = this.get_yes_or_no_console("Confirm");
        if (!yes) {
            m.put("button", "red");
        } else {
            m.put("value", input);
            m.put("button", "green");
        }
        this.pipe.send(m);
    }

    /*
     * Unable to fully structure code
     */
    private void select(Map<String, Object> msg) throws IOException {
        System.out.println("# " + msg.get("text"));
        while (true) lbl-1000:
        // 4 sources

        {
            for (i = 1; i <= 5 && msg.containsKey(Integer.toString(i)); ++i) {
                System.out.println("> " + i + "=" + msg.get(Integer.toString(i)));
            }
            c = System.console();
            input = c.readLine(msg.get("text") + " > ", new Object[0]);
            if (input == null) {
                nack = JSONProtocol.nok(msg, "Input was null");
                this.pipe.send(nack);
                return;
            }
            input = input.trim();
            try {
                choice = Integer.parseInt(input);
            }
            catch (NumberFormatException e) {
                System.err.println("\"" + input + "\" is not a number");
                ** continue;
            }
            if (msg.containsKey(input)) break;
            System.err.println("\"" + input + "\" is not an available option");
        }
        System.out.println("> \"" + msg.get(Integer.toString(choice)) + "\"");
        yes = this.get_yes_or_no_console("Confirm");
        m = JSONProtocol.ok(msg);
        if (!yes) {
            m.put("button", "red");
        } else {
            m.put("value", input);
            m.put("button", "green");
        }
        this.pipe.send(m);
    }

    private void decrypt(Map<String, Object> msg) throws IOException {
        String cmd = (String)msg.get("bytes");
        if (cmd == null) {
            throw new IOException("bytes is null");
        }
        CommandAPDU c = new CommandAPDU(HexUtils.hex2bin(cmd));
        try {
            ResponseAPDU r = this.jsonterminal.card.getBasicChannel().transmit(c);
            if (r.getSW() == 36864) {
                System.out.println("# " + msg.get("text"));
                System.out.println("# " + new String(r.getData(), "UTF-8"));
                Map<String, Object> m = JSONProtocol.ok(msg);
                boolean yes = this.get_yes_or_no_console("Confirm");
                if (!yes) {
                    m.put("button", "red");
                } else {
                    m.put("button", "green");
                }
                this.pipe.send(m);
            } else {
                Map<String, Object> rm = JSONProtocol.nok(msg, "Card returned 0x" + Integer.toHexString(r.getSW()));
                rm.put("bytes", HexUtils.bin2hex(Arrays.copyOfRange(r.getBytes(), r.getBytes().length - 2, r.getBytes().length)));
                this.pipe.send(rm);
            }
        }
        catch (CardException e) {
            this.pipe.send(JSONProtocol.nok(msg, e.getMessage()));
        }
    }

    private void message(Map<String, Object> msg) throws IOException {
        System.out.println("# " + (String)msg.get("text"));
        this.pipe.send(JSONProtocol.ok(msg));
    }

    private void stop(Map<String, Object> msg) {
        String text = "# Connection closed";
        text = msg.containsKey("text") ? text + ": " + msg.get("text") : text + ".";
        System.out.println(text);
    }

    private boolean processMessage(Map<String, Object> msg) throws IOException {
        if (!msg.containsKey("cmd")) {
            throw new IOException("No command in message: " + msg);
        }
        String cmd = (String)msg.get("cmd");
        if (cmd.equals("MESSAGE")) {
            this.message(msg);
        } else if (cmd.equals("VERIFY")) {
            this.verify(msg);
        } else if (cmd.equals("DIALOG")) {
            this.dialog(msg);
        } else if (cmd.equals("INPUT")) {
            this.input(msg);
        } else if (cmd.equals("SELECT")) {
            this.select(msg);
        } else {
            if (cmd.equals("STOP")) {
                this.stop(msg);
                return false;
            }
            if (cmd.equals("DECRYPT")) {
                this.decrypt(msg);
            } else {
                System.err.println("No idea how to process: " + msg.toString());
                return false;
            }
        }
        return true;
    }

    private boolean get_yes_or_no_console(String msg) {
        Console c = System.console();
        while (true) {
            String response;
            if ((response = c.readLine(msg + " y/n ? ", new Object[0])) == null) {
                continue;
            }
            if ((response = response.trim()).equalsIgnoreCase("y")) {
                return true;
            }
            if (response.equalsIgnoreCase("n")) {
                return false;
            }
            System.out.println("Please enter 'y' or 'n' followed by ENTER");
        }
    }
}

