/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerminalManager {
    static final String SUN_CLASS = "sun.security.smartcardio.SunPCSC";
    static final String JNA_CLASS = "jnasmartcardio.Smartcardio";
    static final String LIB_PROP = "sun.security.smartcardio.library";
    private static final Logger logger = LoggerFactory.getLogger(TerminalManager.class);
    private static final String debian64_path = "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu_path = "/lib/libpcsclite.so.1";
    private static final String ubuntu32_path = "/lib/i386-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu64_path = "/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String freebsd_path = "/usr/local/lib/libpcsclite.so";
    private static final String fedora64_path = "/usr/lib64/libpcsclite.so.1";
    private static final String raspbian_path = "/usr/lib/arm-linux-gnueabihf/libpcsclite.so.1";

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static void fixPlatformPaths() {
        if (System.getProperty(LIB_PROP) == null) {
            if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
                if (System.getProperty("os.arch").contains("64")) {
                    if (new File(debian64_path).exists()) {
                        System.setProperty(LIB_PROP, debian64_path);
                    } else if (new File(fedora64_path).exists()) {
                        System.setProperty(LIB_PROP, fedora64_path);
                    } else if (new File(ubuntu64_path).exists()) {
                        System.setProperty(LIB_PROP, ubuntu64_path);
                    }
                } else if (new File(ubuntu_path).exists()) {
                    System.setProperty(LIB_PROP, ubuntu_path);
                } else if (new File(ubuntu32_path).exists()) {
                    System.setProperty(LIB_PROP, ubuntu32_path);
                } else if (new File(raspbian_path).exists()) {
                    System.setProperty(LIB_PROP, raspbian_path);
                }
            } else if (System.getProperty("os.name").equalsIgnoreCase("FreeBSD")) {
                if (new File(freebsd_path).exists()) {
                    System.setProperty(LIB_PROP, freebsd_path);
                } else {
                    System.err.println("Hint: pcsc-lite is missing. pkg install devel/libccid");
                }
            }
        }
    }

    @Deprecated
    public static TerminalFactory getTerminalFactory(boolean fix) throws NoSuchAlgorithmException {
        TerminalManager.fixPlatformPaths();
        if (fix) {
            return TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        }
        return TerminalFactory.getDefault();
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static TerminalFactory loadTerminalFactory(String jar, String classname, String type, String arg) throws NoSuchAlgorithmException {
        try {
            Class<?> cls;
            if (arg != null) {
                arg = URLDecoder.decode(arg, "UTF-8");
            }
            if (jar != null) {
                URLClassLoader loader = new URLClassLoader(new URL[]{new File(jar).toURI().toURL()}, TerminalManager.class.getClassLoader());
                cls = Class.forName(classname, true, loader);
            } else {
                cls = Class.forName(classname);
            }
            Provider p = (Provider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            TerminalFactory tf = TerminalFactory.getInstance(type == null ? "PC/SC" : type, (Object)arg, p);
            return tf;
        }
        catch (UnsupportedEncodingException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            throw new NoSuchAlgorithmException("Could not load " + classname + ": " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            if (e.getCause() != null) {
                Class<?> cause = e.getCause().getClass();
                if (cause.equals(UnsupportedOperationException.class)) {
                    throw new NoSuchAlgorithmException(e.getCause().getMessage());
                }
                if (cause.equals(UnsatisfiedLinkError.class)) {
                    throw new NoSuchAlgorithmException(e.getCause().getMessage());
                }
            }
            throw e;
        }
    }

    public static TerminalFactory getTerminalFactory(String spec) throws NoSuchAlgorithmException {
        if (spec == null) {
            spec = JNA_CLASS;
        }
        TerminalManager.fixPlatformPaths();
        String[] args = spec.split(":");
        if (args.length == 1) {
            return TerminalManager.loadTerminalFactory(null, args[0], null, null);
        }
        if (args.length == 2) {
            Path jarfile = Paths.get(args[0], new String[0]);
            if (Files.exists(jarfile, new LinkOption[0])) {
                return TerminalManager.loadTerminalFactory(args[0], args[1], null, null);
            }
            return TerminalManager.loadTerminalFactory(null, args[0], null, args[1]);
        }
        if (args.length == 3) {
            return TerminalManager.loadTerminalFactory(args[0], args[1], null, args[2]);
        }
        throw new IllegalArgumentException("Could not parse (too many components): " + spec);
    }

    @Deprecated
    public static CardTerminal getTheReader() throws CardException {
        return TerminalManager.getTheReader(JNA_CLASS);
    }

    public static CardTerminal getTheReader(String spec) throws CardException {
        try {
            String msg = "This application expects one and only one card reader (with an inserted card)";
            TerminalFactory tf = TerminalManager.getTerminalFactory(spec);
            CardTerminals tl = tf.terminals();
            List<CardTerminal> list = tl.list(CardTerminals.State.CARD_PRESENT);
            if (list.size() > 1) {
                throw new CardException(msg);
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            List<CardTerminal> wl = tl.list(CardTerminals.State.ALL);
            if (wl.size() == 1) {
                CardTerminal t = wl.get(0);
                System.out.println("Waiting for a card insertion to " + t.getName());
                if (t.waitForCardPresent(0L)) {
                    return t;
                }
                throw new CardException("Could not find a reader with a card");
            }
            throw new CardException(msg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CardException(e);
        }
    }

    public static List<CardTerminal> byATR(Collection<ATR> atrs) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals ts = tf.terminals();
        List<CardTerminal> tl = ts.list(CardTerminals.State.ALL);
        ArrayList<CardTerminal> result = new ArrayList<CardTerminal>();
        for (CardTerminal t : tl) {
            logger.trace("Checking {}", (Object)t.getName());
            if (!t.isCardPresent()) continue;
            Card c = t.connect("DIRECT");
            ATR cardatr = c.getATR();
            c.disconnect(false);
            for (ATR atr : atrs) {
                if (!cardatr.equals(atr)) continue;
                logger.debug("{} matched for ATR {}", (Object)t.getName(), (Object)HexUtils.bin2hex(atr.getBytes()));
                result.add(t);
            }
        }
        return result;
    }

    public static CardTerminal getByATR(Collection<ATR> atrs) throws NoSuchAlgorithmException, CardException {
        List<CardTerminal> result = TerminalManager.byATR(atrs);
        if (result.size() == 0) {
            throw new CardNotPresentException("No card with requested ATR-s found");
        }
        return result.get(0);
    }

    public static CardTerminal getByATRBytes(Collection<byte[]> atrs) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals ts = tf.terminals();
        List<CardTerminal> tl = ts.list(CardTerminals.State.ALL);
        for (CardTerminal t : tl) {
            logger.trace("Checking {}", (Object)t.getName());
            if (!t.isCardPresent()) continue;
            Card c = t.connect("DIRECT");
            byte[] cardatr = c.getATR().getBytes();
            c.disconnect(false);
            for (byte[] atr : atrs) {
                if (!Arrays.equals(cardatr, atr)) continue;
                logger.debug("{} matched for ATR {}", (Object)t.getName(), (Object)HexUtils.bin2hex(atr));
                return t;
            }
        }
        throw new CardNotPresentException("No card with requested ATR present");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CardTerminal getByAID(Collection<byte[]> aids) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals ts = tf.terminals();
        List<CardTerminal> tl = ts.list(CardTerminals.State.ALL);
        for (CardTerminal t : tl) {
            if (!t.isCardPresent()) continue;
            Card c = null;
            try {
                c = t.connect("*");
                for (byte[] aid : aids) {
                    CommandAPDU s = new CommandAPDU(0, 164, 4, 0, aid, 256);
                    ResponseAPDU r = c.getBasicChannel().transmit(s);
                    if (r.getSW() != 36864) continue;
                    logger.debug("{} matched for AID {}", (Object)t.getName(), (Object)HexUtils.bin2hex(aid));
                    CardTerminal cardTerminal = t;
                    return cardTerminal;
                }
            }
            catch (CardException e) {
                logger.trace("Could not connect or select AID", (Throwable)e);
            }
            finally {
                if (c == null) continue;
                c.disconnect(false);
            }
        }
        throw new CardNotPresentException("No card with requested AID-s present");
    }

    public static void listReaders(PrintWriter to, boolean verbose, String preferred, String ignored) {
    }

    public CardTerminal getReader(String preferred, String ignored) {
        return null;
    }

    private static String getscard(String s) {
        Pattern p = Pattern.compile("SCARD_\\w+");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static String getExceptionMessage(Exception e) {
        String s;
        if (e.getCause() != null && e.getCause().getMessage() != null && (s = TerminalManager.getscard(e.getCause().getMessage())) != null) {
            return s;
        }
        if (e.getMessage() != null && (s = TerminalManager.getscard(e.getMessage())) != null) {
            return s;
        }
        return e.getMessage();
    }
}

