/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.remote;

import apdu4j.HexUtils;
import apdu4j.remote.RemoteTerminal;
import apdu4j.remote.RemoteTerminalThread;
import apdu4j.remote.SocketTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServer
extends RemoteTerminalThread {
    private static Logger logger = LoggerFactory.getLogger(TestServer.class);

    static void start(ServerSocket socket) {
        ExecutorService executor = Executors.newWorkStealingPool();
        while (true) {
            try {
                while (true) {
                    Socket s = socket.accept();
                    SocketTransport transport = new SocketTransport(s);
                    TestServer client = new TestServer();
                    client.setTerminal(new RemoteTerminal(transport));
                    executor.execute(client);
                }
            }
            catch (IOException e) {
                logger.trace("Could not accept client", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void setTerminal(RemoteTerminal t) {
        this.terminal = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Started session");
        try {
            this.terminal.start();
            this.terminal.statusMessage("Welcome!");
            String name = this.terminal.input("Please enter your name");
            this.terminal.statusMessage("Hello, " + name);
            HashMap<Integer, String> chs = new HashMap<Integer, String>();
            chs.put(1, "Apple");
            chs.put(2, "Orange");
            chs.put(3, "Banana");
            chs.put(4, "Hammer");
            int ch = this.terminal.select("What do you like?", chs);
            this.terminal.statusMessage("So you like " + ch);
            try {
                CardTerminal ct = this.terminal.getCardTerminal();
                CardChannel c = ct.connect("*").getBasicChannel();
                if (this.terminal.dialog("Shall we try to select MF in " + ct.getName()).equals((Object)RemoteTerminal.Button.GREEN)) {
                    ResponseAPDU r = c.transmit(new CommandAPDU(0, 164, 4, 0));
                    this.terminal.statusMessage("Card returned: " + HexUtils.bin2hex(r.getBytes()));
                }
                this.terminal.input("Please enter your nam");
            }
            catch (CardException e) {
                this.terminal.statusMessage("Failed: " + e.getMessage());
            }
            finally {
                this.terminal.stop("Bye!");
            }
        }
        catch (IOException e) {
            logger.error("Communication error", (Throwable)e);
        }
        catch (RemoteTerminal.UserCancelExcption e) {
            logger.warn("User cancelled the operation with red button");
        }
    }
}

