/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;

public class PinPadTerminal
implements AutoCloseable {
    private static final int CM_IOCTL_GET_FEATURE_REQUEST = PinPadTerminal.CARD_CTL_CODE(3400);
    private Map<FEATURE, Integer> features = new HashMap<FEATURE, Integer>();
    private boolean display = false;
    private CardTerminal t = null;
    private Card c = null;

    private static Map<FEATURE, Integer> tokenize(byte[] tlv) {
        HashMap<FEATURE, Integer> m = new HashMap<FEATURE, Integer>();
        if (tlv.length % 6 != 0) {
            throw new IllegalArgumentException("Bad response length: " + tlv.length);
        }
        for (int i = 0; i < tlv.length; i += 6) {
            int ft = tlv[i + 0] & 0xFF;
            FEATURE f = FEATURE.fromValue(ft);
            byte[] c = Arrays.copyOfRange(tlv, i + 2, i + 6);
            ByteBuffer buffer = ByteBuffer.wrap(c);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int ci = buffer.getInt();
            m.put(f, ci);
        }
        return m;
    }

    private void parse_pin_properties(byte[] prop) {
        if (prop.length == 4) {
            int cols = prop[0] & 0xFF;
            int rows = prop[1] & 0xFF;
            int pin = prop[2] & 0xFF;
            int timeout = prop[3] & 0xFF;
            if (rows > 0 && cols > 0) {
                this.display = true;
            }
        } else {
            throw new IllegalArgumentException("Bad PIN properties length: " + prop.length);
        }
    }

    private static void parse_tlv_properties(byte[] tlv) {
        byte[] v;
        for (int i = 0; i < tlv.length; i += v.length + 2) {
            int t = tlv[i + 0] & 0xFF;
            int l = tlv[i + 1] & 0xFF;
            v = Arrays.copyOfRange(tlv, i + 2, i + 2 + l);
            System.out.println(Integer.toHexString(t) + "=" + HexUtils.bin2hex(v));
        }
    }

    public static int CARD_CTL_CODE(int c) {
        String os = System.getProperty("os.name", "unknown").toLowerCase();
        if (os.indexOf("windows") != -1) {
            return 0x310000 | c << 2;
        }
        return 0x42000000 + c;
    }

    public void probe() throws CardException {
        if (this.t != null && this.c == null) {
            this.c = this.t.connect("DIRECT");
        }
        byte[] resp = this.c.transmitControlCommand(CM_IOCTL_GET_FEATURE_REQUEST, new byte[0]);
        Map<FEATURE, Integer> props = PinPadTerminal.tokenize(resp);
        this.features.putAll(props);
        if (props.containsKey((Object)FEATURE.IFD_PIN_PROPERTIES) && (resp = this.c.transmitControlCommand(props.get((Object)FEATURE.IFD_PIN_PROPERTIES), new byte[0])) != null && resp.length > 0) {
            this.parse_pin_properties(resp);
        }
        if (!props.containsKey((Object)FEATURE.GET_TLV_PROPERTIES) || (resp = this.c.transmitControlCommand(props.get((Object)FEATURE.GET_TLV_PROPERTIES), new byte[0])) == null || resp.length > 0) {
            // empty if block
        }
    }

    private PinPadTerminal(CardTerminal terminal, Card card) {
        this.t = terminal;
        this.c = card;
    }

    public static PinPadTerminal getInstance(CardTerminal terminal) {
        PinPadTerminal p = new PinPadTerminal(terminal, null);
        return p;
    }

    public static PinPadTerminal getInstance(Card card) {
        PinPadTerminal p = new PinPadTerminal(null, card);
        return p;
    }

    public boolean canVerify() {
        return this.features.containsKey((Object)FEATURE.VERIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.VERIFY_PIN_START) && this.features.containsKey((Object)FEATURE.VERIFY_PIN_FINISH);
    }

    public boolean canModify() {
        return this.features.containsKey((Object)FEATURE.MODIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.MODIFY_PIN_START) && this.features.containsKey((Object)FEATURE.MODIFY_PIN_FINISH);
    }

    public boolean hasDisplay() {
        return this.display;
    }

    @Override
    public void close() throws IOException, CardException {
        if (this.t != null && this.c != null) {
            this.c.disconnect(false);
        }
    }

    public static enum FEATURE {
        VERIFY_PIN_START(1),
        VERIFY_PIN_FINISH(2),
        MODIFY_PIN_START(3),
        MODIFY_PIN_FINISH(4),
        GET_KEY_PRESSED(5),
        VERIFY_PIN_DIRECT(6),
        MODIFY_PIN_DIRECT(7),
        MCT_READERDIRECT(8),
        MCT_UNIVERSAL(9),
        IFD_PIN_PROPERTIES(10),
        ABORT(11),
        SET_SPE_MESSAGE(12),
        VERIFY_PIN_DIRECT_APP_ID(13),
        MODIFY_PIN_DIRECT_APP_ID(14),
        WRITE_DISPLAY(15),
        GET_KEY(16),
        IFD_DISPLAY_PROPERTIES(17),
        GET_TLV_PROPERTIES(18),
        CCID_ESC_COMMAND(19),
        EXECUTE_PACE(32);

        private final int value;

        private FEATURE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FEATURE fromValue(int v) {
            for (FEATURE f : FEATURE.values()) {
                if (f.value != v) continue;
                return f;
            }
            return null;
        }
    }
}

