/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.terminals;

import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class LoggingCardTerminal
extends CardTerminal {
    protected final CardTerminal terminal;
    protected final PrintStream log;
    protected final PrintStream dump;

    private LoggingCardTerminal(CardTerminal term, PrintStream log, PrintStream dump) {
        this.terminal = term;
        this.log = log;
        this.dump = dump;
    }

    private static LoggingCardTerminal make(CardTerminal term, OutputStream log, OutputStream dump) {
        PrintStream dumpstream;
        PrintStream logstream;
        try {
            logstream = new PrintStream(log, true, StandardCharsets.UTF_8.name());
            dumpstream = dump != null ? new PrintStream(dump, true, StandardCharsets.UTF_8.name()) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Must support UTF-8", e);
        }
        return new LoggingCardTerminal(term, logstream, dumpstream);
    }

    public static LoggingCardTerminal getInstance(CardTerminal term) {
        return LoggingCardTerminal.make(term, System.out, null);
    }

    public static LoggingCardTerminal getInstance(CardTerminal term, OutputStream dump) {
        return LoggingCardTerminal.make(term, System.out, dump);
    }

    @Override
    public Card connect(String arg0) throws CardException {
        return new LoggingCard(this.terminal, arg0);
    }

    @Override
    public String getName() {
        return this.terminal.getName();
    }

    @Override
    public boolean isCardPresent() throws CardException {
        return this.terminal.isCardPresent();
    }

    @Override
    public boolean waitForCardAbsent(long arg0) throws CardException {
        return this.terminal.waitForCardAbsent(arg0);
    }

    @Override
    public boolean waitForCardPresent(long arg0) throws CardException {
        return this.terminal.waitForCardPresent(arg0);
    }

    public final class LoggingCard
    extends Card {
        private long inBytes = 0L;
        private long outBytes = 0L;
        private final Card card;

        private LoggingCard(CardTerminal term, String protocol) throws CardException {
            LoggingCardTerminal.this.log.print("SCardConnect(\"" + LoggingCardTerminal.this.terminal.getName() + "\", " + (protocol.equals("*") ? "T=*" : protocol) + ")");
            LoggingCardTerminal.this.log.flush();
            try {
                this.card = LoggingCardTerminal.this.terminal.connect(protocol);
                String atr = HexUtils.bin2hex((byte[])this.card.getATR().getBytes());
                LoggingCardTerminal.this.log.println(" -> " + this.card.getProtocol() + ", " + atr);
                if (LoggingCardTerminal.this.dump != null) {
                    String ts = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(Calendar.getInstance().getTime());
                    LoggingCardTerminal.this.dump.println("# Generated on " + ts + " by apdu4j/" + TerminalManager.getVersion());
                    LoggingCardTerminal.this.dump.println("# Using " + LoggingCardTerminal.this.terminal.getName());
                    LoggingCardTerminal.this.dump.println("# ATR: " + atr);
                    LoggingCardTerminal.this.dump.println("# PROTOCOL: " + this.card.getProtocol());
                    LoggingCardTerminal.this.dump.println("#");
                }
            }
            catch (CardException e) {
                LoggingCardTerminal.this.log.println(" -> " + TerminalManager.getExceptionMessage(e));
                throw e;
            }
        }

        @Override
        public void beginExclusive() throws CardException {
            LoggingCardTerminal.this.log.println("SCardBeginTransaction(\"" + LoggingCardTerminal.this.terminal.getName() + "\")");
            this.card.beginExclusive();
        }

        @Override
        public void disconnect(boolean arg0) throws CardException {
            LoggingCardTerminal.this.log.println("SCardDisconnect(\"" + LoggingCardTerminal.this.terminal.getName() + "\", " + arg0 + ") tx:" + this.outBytes + "/rx:" + this.inBytes);
            this.outBytes = 0L;
            this.inBytes = 0L;
            if (LoggingCardTerminal.this.dump != null) {
                LoggingCardTerminal.this.dump.close();
            }
            this.card.disconnect(arg0);
        }

        @Override
        public void endExclusive() throws CardException {
            LoggingCardTerminal.this.log.println("SCardEndTransaction(\"" + LoggingCardTerminal.this.terminal.getName() + "\")");
            this.card.endExclusive();
        }

        @Override
        public ATR getATR() {
            return this.card.getATR();
        }

        @Override
        public CardChannel getBasicChannel() {
            return new LoggingCardChannel(this.card);
        }

        @Override
        public String getProtocol() {
            return this.card.getProtocol();
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            throw new CardException("Logical channels are not supported");
        }

        @Override
        public byte[] transmitControlCommand(int arg0, byte[] arg1) throws CardException {
            byte[] result;
            LoggingCardTerminal.this.log.print("SCardControl(\"" + LoggingCardTerminal.this.terminal.getName() + "\", " + Integer.toString(arg0, 16) + ", " + HexUtils.bin2hex((byte[])arg1) + ")");
            try {
                result = this.card.transmitControlCommand(arg0, arg1);
            }
            catch (CardException e) {
                String err = TerminalManager.getExceptionMessage(e);
                if (err != null) {
                    LoggingCardTerminal.this.log.println("-> " + err);
                } else {
                    LoggingCardTerminal.this.log.println("-> Exception");
                }
                throw e;
            }
            LoggingCardTerminal.this.log.println("-> " + HexUtils.bin2hex((byte[])result));
            return result;
        }

        public final class LoggingCardChannel
        extends CardChannel {
            private final CardChannel channel;
            private final Card card;

            public LoggingCardChannel(Card card) {
                this.card = card;
                this.channel = card.getBasicChannel();
            }

            @Override
            public void close() throws CardException {
                this.channel.close();
            }

            @Override
            public Card getCard() {
                return this.card;
            }

            @Override
            public int getChannelNumber() {
                return this.channel.getChannelNumber();
            }

            @Override
            public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
                ResponseAPDU response;
                byte[] cb = apdu.getBytes();
                int len_end = apdu.getData().length > 255 ? 7 : 5;
                LoggingCardTerminal.this.log.print("A>> " + this.card.getProtocol() + " (4+" + String.format("%04d", apdu.getData().length) + ")");
                LoggingCardTerminal.this.log.print(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(cb, 0, 4)));
                if (cb.length > 4) {
                    int cmdlen = cb[4] & 0xFF;
                    if (cmdlen == 0 && apdu.getData().length > 255) {
                        cmdlen = cb[5] & 0xFF00 | cb[6] & 0xFF;
                    }
                    if (apdu.getData().length < cmdlen) {
                        cmdlen = 0;
                    }
                    LoggingCardTerminal.this.log.print(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(cb, 4, len_end)));
                    LoggingCardTerminal.this.log.print(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(cb, len_end, len_end + cmdlen)));
                    if (len_end + cmdlen < cb.length) {
                        LoggingCardTerminal.this.log.println(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(cb, len_end + cmdlen, cb.length)));
                    } else {
                        LoggingCardTerminal.this.log.println();
                    }
                } else {
                    LoggingCardTerminal.this.log.println();
                }
                LoggingCardTerminal.this.log.flush();
                long t = System.currentTimeMillis();
                try {
                    response = this.channel.transmit(apdu);
                    LoggingCard.this.outBytes = LoggingCard.this.outBytes + (long)cb.length;
                }
                catch (CardException e) {
                    String err = TerminalManager.getExceptionMessage(e);
                    String time = this.time(System.currentTimeMillis() - t);
                    if (err != null) {
                        System.out.println("<< (" + time + ") " + err);
                    } else {
                        System.out.println("<< Exception");
                    }
                    throw e;
                }
                String time = this.time(System.currentTimeMillis() - t);
                byte[] rb = response.getBytes();
                LoggingCard.this.inBytes = LoggingCard.this.inBytes + (long)rb.length;
                System.out.print("A<< (" + String.format("%04d", response.getData().length) + "+2) (" + time + ")");
                if (rb.length > 2) {
                    LoggingCardTerminal.this.log.print(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(rb, 0, rb.length - 2)));
                }
                LoggingCardTerminal.this.log.println(" " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(rb, rb.length - 2, rb.length)));
                if (LoggingCardTerminal.this.dump != null) {
                    LoggingCardTerminal.this.dump.println("# Sent\n" + HexUtils.bin2hex((byte[])cb));
                    LoggingCardTerminal.this.dump.println("# Received in " + time + "\n" + HexUtils.bin2hex((byte[])rb));
                }
                return response;
            }

            private String time(long ms) {
                String time = ms + "ms";
                if (ms > 1000L) {
                    time = ms / 1000L + "s" + ms % 1000L + "ms";
                }
                return time;
            }

            @Override
            public int transmit(ByteBuffer cmd, ByteBuffer rsp) throws CardException {
                byte[] commandBytes = new byte[cmd.remaining()];
                cmd.get(commandBytes);
                cmd.position(0);
                LoggingCardTerminal.this.log.println("B>> " + this.card.getProtocol() + " (" + commandBytes.length + ") " + HexUtils.bin2hex((byte[])commandBytes));
                int response = this.channel.transmit(cmd, rsp);
                LoggingCard.this.outBytes = LoggingCard.this.outBytes + (long)commandBytes.length;
                byte[] responseBytes = new byte[response];
                LoggingCard.this.inBytes = LoggingCard.this.inBytes + (long)responseBytes.length;
                rsp.get(responseBytes);
                rsp.position(0);
                LoggingCardTerminal.this.log.println("B<< (" + responseBytes.length + ") " + HexUtils.bin2hex((byte[])responseBytes));
                if (LoggingCardTerminal.this.dump != null) {
                    LoggingCardTerminal.this.dump.println("# Sent\n" + HexUtils.bin2hex((byte[])commandBytes));
                    LoggingCardTerminal.this.dump.println("# Received\n" + HexUtils.bin2hex((byte[])responseBytes));
                }
                return response;
            }
        }
    }
}

