/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.providers;

import apdu4j.HexUtils;
import apdu4j.TerminalManager;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactorySpi;

public class APDUReplayProvider
extends Provider {
    private static final String PROVIDER_NAME = "APDUReplay";
    private static final String TERMINAL_NAME = "Replay Terminal 0";

    public APDUReplayProvider() {
        super(PROVIDER_NAME, 0.1, "APDU Replay from apdu4j/" + TerminalManager.getVersion());
        this.put("TerminalFactory.PC/SC", APDUReplayProviderSpi.class.getName());
    }

    public static class APDUReplayProviderSpi
    extends TerminalFactorySpi {
        boolean strict = true;
        InputStream script = null;
        List<byte[]> commands = null;
        List<byte[]> responses = null;

        public APDUReplayProviderSpi(Object parameter) {
            if (parameter != null && parameter instanceof InputStream) {
                this.script = (InputStream)parameter;
            }
        }

        @Override
        public CardTerminals engineTerminals() {
            return new ReplayTerminals(this.script);
        }

        public synchronized byte[] replay_transmit(byte[] cmd) throws CardException {
            if (this.commands.size() == 0) {
                throw new CardException("Replay script depleted!");
            }
            byte[] expected_cmd = this.commands.remove(0);
            if (this.strict && !Arrays.equals(cmd, expected_cmd)) {
                throw new CardException("Expected " + HexUtils.bin2hex((byte[])expected_cmd) + " but got " + HexUtils.bin2hex((byte[])cmd));
            }
            return this.responses.remove(0);
        }

        private final class ReplayTerminals
        extends CardTerminals {
            private static final String PROTOCOL = "# PROTOCOL: ";
            private static final String ATR = "# ATR: ";
            final Scanner script;
            ATR atr;
            String protocol;

            protected ReplayTerminals(InputStream script_stream) {
                this.script = new Scanner(script_stream, StandardCharsets.UTF_8.name());
                APDUReplayProviderSpi.this.commands = new ArrayList<byte[]>();
                APDUReplayProviderSpi.this.responses = new ArrayList<byte[]>();
                boolean is_cmd = true;
                while (this.script.hasNextLine()) {
                    String l = this.script.nextLine().trim();
                    if (l.startsWith("#")) {
                        if (l.startsWith(ATR)) {
                            this.atr = new ATR(HexUtils.hex2bin((String)l.substring(ATR.length())));
                            continue;
                        }
                        if (!l.startsWith(PROTOCOL)) continue;
                        this.protocol = l.substring(PROTOCOL.length());
                        continue;
                    }
                    byte[] r = HexUtils.hex2bin((String)l);
                    if (is_cmd) {
                        APDUReplayProviderSpi.this.commands.add(r);
                    } else {
                        APDUReplayProviderSpi.this.responses.add(r);
                    }
                    is_cmd = !is_cmd;
                }
                if (this.atr == null || this.protocol == null || APDUReplayProviderSpi.this.responses.size() == 0 || APDUReplayProviderSpi.this.responses.size() != APDUReplayProviderSpi.this.commands.size()) {
                    throw new IllegalArgumentException("Incomplete APDU dump!");
                }
            }

            @Override
            public List<CardTerminal> list(CardTerminals.State state) throws CardException {
                ArrayList<CardTerminal> terminals = new ArrayList<CardTerminal>();
                if (state == CardTerminals.State.ALL || state == CardTerminals.State.CARD_PRESENT) {
                    terminals.add(new ReplayTerminal());
                }
                return terminals;
            }

            @Override
            public boolean waitForChange(long arg0) throws CardException {
                return false;
            }

            private final class ReplayTerminal
            extends CardTerminal {
                private ReplayTerminal() {
                }

                @Override
                public Card connect(String protocol) throws CardException {
                    return new ReplayCard();
                }

                @Override
                public String getName() {
                    return APDUReplayProvider.TERMINAL_NAME;
                }

                @Override
                public boolean isCardPresent() throws CardException {
                    return true;
                }

                @Override
                public boolean waitForCardAbsent(long arg0) throws CardException {
                    return false;
                }

                @Override
                public boolean waitForCardPresent(long arg0) throws CardException {
                    return true;
                }

                public final class ReplayCard
                extends Card {
                    private final CardChannel basicChannel = new ReplayChannel();

                    protected ReplayCard() {
                    }

                    @Override
                    public void beginExclusive() throws CardException {
                    }

                    @Override
                    public void disconnect(boolean reset) throws CardException {
                    }

                    @Override
                    public void endExclusive() throws CardException {
                    }

                    @Override
                    public ATR getATR() {
                        return ReplayTerminals.this.atr;
                    }

                    @Override
                    public CardChannel getBasicChannel() {
                        return this.basicChannel;
                    }

                    @Override
                    public String getProtocol() {
                        return ReplayTerminals.this.protocol;
                    }

                    @Override
                    public CardChannel openLogicalChannel() throws CardException {
                        throw new CardException("Logical channels not supported");
                    }

                    @Override
                    public byte[] transmitControlCommand(int arg0, byte[] arg1) throws CardException {
                        throw new RuntimeException("Control commands don't make sense");
                    }

                    public final class ReplayChannel
                    extends CardChannel {
                        @Override
                        public void close() throws CardException {
                            throw new IllegalStateException("Can't close basic channel");
                        }

                        @Override
                        public Card getCard() {
                            return ReplayCard.this;
                        }

                        @Override
                        public int getChannelNumber() {
                            return 0;
                        }

                        @Override
                        public ResponseAPDU transmit(CommandAPDU apdu) throws CardException {
                            return new ResponseAPDU(APDUReplayProviderSpi.this.replay_transmit(apdu.getBytes()));
                        }

                        @Override
                        public int transmit(ByteBuffer arg0, ByteBuffer arg1) throws CardException {
                            byte[] cmd = new byte[arg0.remaining()];
                            arg0.get(cmd);
                            byte[] resp = APDUReplayProviderSpi.this.replay_transmit(cmd);
                            arg1.put(resp);
                            return resp.length;
                        }
                    }
                }
            }
        }
    }
}

