/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import apdu4j.PinPadTerminal;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TerminalManager {
    static final String SUN_CLASS = "sun.security.smartcardio.SunPCSC";
    static final String JNA_CLASS = "jnasmartcardio.Smartcardio";
    static final String LIB_PROP = "sun.security.smartcardio.library";
    private static final Logger logger = LoggerFactory.getLogger(TerminalManager.class);
    private static final String debian64_path = "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu_path = "/lib/libpcsclite.so.1";
    private static final String ubuntu32_path = "/lib/i386-linux-gnu/libpcsclite.so.1";
    private static final String ubuntu64_path = "/lib/x86_64-linux-gnu/libpcsclite.so.1";
    private static final String freebsd_path = "/usr/local/lib/libpcsclite.so";
    private static final String fedora64_path = "/usr/lib64/libpcsclite.so.1";
    private static final String raspbian_path = "/usr/lib/arm-linux-gnueabihf/libpcsclite.so.1";

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static void fixPlatformPaths() {
        if (System.getProperty(LIB_PROP) == null) {
            if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
                if (System.getProperty("os.arch").contains("64")) {
                    if (new File(debian64_path).exists()) {
                        System.setProperty(LIB_PROP, debian64_path);
                    } else if (new File(fedora64_path).exists()) {
                        System.setProperty(LIB_PROP, fedora64_path);
                    } else if (new File(ubuntu64_path).exists()) {
                        System.setProperty(LIB_PROP, ubuntu64_path);
                    }
                } else if (new File(ubuntu_path).exists()) {
                    System.setProperty(LIB_PROP, ubuntu_path);
                } else if (new File(ubuntu32_path).exists()) {
                    System.setProperty(LIB_PROP, ubuntu32_path);
                } else if (new File(raspbian_path).exists()) {
                    System.setProperty(LIB_PROP, raspbian_path);
                }
            } else if (System.getProperty("os.name").equalsIgnoreCase("FreeBSD")) {
                if (new File(freebsd_path).exists()) {
                    System.setProperty(LIB_PROP, freebsd_path);
                } else {
                    System.err.println("Hint: pcsc-lite is missing. pkg install devel/libccid");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static TerminalFactory loadTerminalFactory(String jar, String classname, String type, String arg) throws NoSuchAlgorithmException {
        try {
            Class<?> cls;
            if (arg != null) {
                arg = URLDecoder.decode(arg, "UTF-8");
            }
            if (jar != null) {
                URLClassLoader loader = new URLClassLoader(new URL[]{new File(jar).toURI().toURL()}, TerminalManager.class.getClassLoader());
                cls = Class.forName(classname, true, loader);
            } else {
                cls = Class.forName(classname);
            }
            Provider p = (Provider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            TerminalFactory tf = TerminalFactory.getInstance(type == null ? "PC/SC" : type, (Object)arg, p);
            return tf;
        }
        catch (UnsupportedEncodingException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
            throw new NoSuchAlgorithmException("Could not load " + classname + ": " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            if (e.getCause() != null) {
                Class<?> cause = e.getCause().getClass();
                if (cause.equals(UnsupportedOperationException.class)) {
                    throw new NoSuchAlgorithmException(e.getCause().getMessage());
                }
                if (cause.equals(UnsatisfiedLinkError.class)) {
                    throw new NoSuchAlgorithmException(e.getCause().getMessage());
                }
            }
            throw e;
        }
    }

    public static TerminalFactory getTerminalFactory(String spec) throws NoSuchAlgorithmException {
        if (spec == null) {
            spec = JNA_CLASS;
        }
        TerminalManager.fixPlatformPaths();
        String[] args = spec.split(":");
        if (args.length == 1) {
            return TerminalManager.loadTerminalFactory(null, args[0], null, null);
        }
        if (args.length == 2) {
            Path jarfile = Paths.get(args[0], new String[0]);
            if (Files.exists(jarfile, new LinkOption[0])) {
                return TerminalManager.loadTerminalFactory(args[0], args[1], null, null);
            }
            return TerminalManager.loadTerminalFactory(null, args[0], null, args[1]);
        }
        if (args.length == 3) {
            return TerminalManager.loadTerminalFactory(args[0], args[1], null, args[2]);
        }
        throw new IllegalArgumentException("Could not parse (too many components): " + spec);
    }

    static boolean ignoreReader(String ignore, String name) {
        if (ignore != null) {
            String[] names;
            for (String n : names = ignore.toLowerCase().split(";")) {
                if (!name.toLowerCase().contains(n)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listReaders(String ignore, List<CardTerminal> terminals, PrintStream to, boolean pinpad) {
        try {
            for (CardTerminal t : terminals) {
                String vmd = "";
                if (pinpad) {
                    try (PinPadTerminal pp = PinPadTerminal.getInstance(t);){
                        pp.probe();
                        vmd = vmd + (pp.canVerify() ? "V" : " ");
                        vmd = vmd + (pp.canModify() ? "M" : " ");
                        vmd = vmd + (pp.hasDisplay() ? "D" : " ");
                    }
                    catch (CardException e) {
                        String err = TerminalManager.getExceptionMessage(e);
                        vmd = err.equals("SCARD_E_SHARING_VIOLATION") ? "   " : "EEE";
                    }
                    vmd = "[" + vmd + "] ";
                }
                String present = " ";
                if (TerminalManager.ignoreReader(ignore, t.getName())) {
                    present = "I";
                } else if (t.isCardPresent()) {
                    present = "*";
                }
                String secondline = null;
                if (t.isCardPresent()) {
                    Card c = null;
                    byte[] atr = null;
                    try {
                        c = t.connect("*");
                        atr = c.getATR().getBytes();
                    }
                    catch (CardException e) {
                        String err = TerminalManager.getExceptionMessage(e);
                        if (err.equals("SCARD_E_SHARING_VIOLATION")) {
                            present = "X";
                            try {
                                c = t.connect("DIRECT");
                                atr = c.getATR().getBytes();
                            }
                            catch (CardException e2) {
                                String err2 = TerminalManager.getExceptionMessage(e2);
                                if (err2.equals("SCARD_E_SHARING_VIOLATION")) {
                                    present = "X";
                                }
                            }
                        } else {
                            secondline = "          " + err;
                        }
                    }
                    finally {
                        if (c != null) {
                            c.disconnect(false);
                        }
                    }
                    if (atr != null) {
                        secondline = "          " + HexUtils.bin2hex((byte[])atr).toUpperCase();
                    }
                }
                to.println(String.format("[%s] %s%s", present, vmd, t.getName()));
                if (secondline == null) continue;
                to.println(secondline);
            }
        }
        catch (CardException e) {
            logger.error("Failed to print reader list: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Optional<CardTerminal> getTheReader(String arg, String ignore, Collection<byte[]> atrs, long wait) throws CardException, NoSuchAlgorithmException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals ts = tf.terminals();
        List<CardTerminal> terminals = ts.list();
        if (terminals.size() == 0 && wait > 0L) {
            if (ts.waitForChange(wait)) {
                ts = tf.terminals();
                terminals = ts.list();
                if (terminals.size() == 1) {
                    return Optional.of(terminals.get(0));
                }
            } else {
                logger.warn("Timeout waiting for a NFC reader");
                return Optional.empty();
            }
        }
        if (arg != null) {
            try {
                int n = Integer.parseInt(arg);
                if (n > 0 && n < 10 && n <= terminals.size()) {
                    return Optional.of(terminals.get(n - 1));
                }
                logger.error(n + ": only have " + terminals.size() + " readers.");
                TerminalManager.listReaders(ignore, terminals, System.err, false);
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
            List matchingName = terminals.stream().filter(t -> t.getName().toLowerCase().contains(arg)).collect(Collectors.toList());
            if (matchingName.size() == 1) {
                return Optional.of(matchingName.get(0));
            }
            if (matchingName.size() == 0) {
                logger.error(String.format("No reader matches '%s'", arg));
                return Optional.empty();
            }
            logger.warn(String.format("Multiple readers contain '%s'", arg));
            TerminalManager.listReaders(ignore, terminals, System.err, false);
        } else {
            if (terminals.size() == 0) {
                logger.error("No smart card readers available");
                return Optional.empty();
            }
            if (terminals.size() == 1) {
                return Optional.of(terminals.get(0));
            }
            List<CardTerminal> withCard = ts.list(CardTerminals.State.CARD_PRESENT);
            if (withCard.size() == 1) {
                return Optional.of(withCard.get(0));
            }
            List<CardTerminal> withAtr = TerminalManager.byATR(ts.list(CardTerminals.State.CARD_PRESENT), atrs);
            if (withAtr.size() == 1) {
                return Optional.of(withAtr.get(0));
            }
            System.err.println("Multiple readers, must choose one:");
            TerminalManager.listReaders(ignore, terminals, System.err, false);
        }
        return Optional.empty();
    }

    public static List<CardTerminal> byATR(List<CardTerminal> terminals, Collection<byte[]> atrs) {
        return terminals.stream().filter(t -> {
            try {
                if (t.isCardPresent()) {
                    Card c = t.connect("DIRECT");
                    byte[] atr = c.getATR().getBytes();
                    c.disconnect(false);
                    return atrs.stream().anyMatch(a -> Arrays.equals(a, atr));
                }
                return false;
            }
            catch (CardException e) {
                logger.warn("Failed to get ATR: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static List<CardTerminal> byATR(CardTerminals terminals, Collection<byte[]> atrs) throws CardException {
        List<CardTerminal> tl = terminals.list(CardTerminals.State.ALL);
        return TerminalManager.byATR(tl, atrs);
    }

    public static List<CardTerminal> byATR(Collection<byte[]> atrs) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals terminals = tf.terminals();
        return TerminalManager.byATR(terminals, atrs);
    }

    public static List<CardTerminal> byAID(List<CardTerminal> terminals, Collection<byte[]> aids) throws CardException {
        return terminals.stream().filter(t -> {
            try {
                if (!t.isCardPresent()) return false;
                Card c = null;
                try {
                    byte[] aid;
                    CommandAPDU s;
                    ResponseAPDU r;
                    c = t.connect("*");
                    Iterator iterator = aids.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        aid = (byte[])iterator.next();
                        s = new CommandAPDU(0, 164, 4, 0, aid, 256);
                    } while ((r = c.getBasicChannel().transmit(s)).getSW() != 36864);
                    logger.debug("{} matched for AID {}", (Object)t.getName(), (Object)HexUtils.bin2hex((byte[])aid));
                    boolean bl = true;
                    return bl;
                }
                catch (CardException e) {
                    logger.trace("Could not connect or select AID", (Throwable)e);
                    return false;
                }
                finally {
                    if (c != null) {
                        c.disconnect(false);
                    }
                }
            }
            catch (CardException e) {
                logger.warn("Failed to get AID: " + e.getMessage(), (Throwable)e);
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static List<CardTerminal> byAID(Collection<byte[]> aids) throws NoSuchAlgorithmException, CardException {
        TerminalFactory tf = TerminalFactory.getInstance("PC/SC", null, (Provider)new Smartcardio());
        CardTerminals ts = tf.terminals();
        return TerminalManager.byAID(ts.list(), aids);
    }

    CallbackHandler getCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback c : callbacks) {
                    String type;
                    if (!(c instanceof TextOutputCallback)) continue;
                    TextOutputCallback cb = (TextOutputCallback)c;
                    switch (cb.getMessageType()) {
                        case 0: {
                            type = "INFORMATION";
                            break;
                        }
                        case 1: {
                            type = "WARNING";
                            break;
                        }
                        case 2: {
                            type = "ERROR";
                            break;
                        }
                        default: {
                            type = "MESSAGE";
                        }
                    }
                    System.out.println(type + ": " + cb.getMessage());
                }
            }
        };
    }

    public static Card connect(CardTerminal terminal, String protocol, CallbackHandler cb) throws CardException {
        try {
            if (!terminal.isCardPresent()) {
                cb.handle(new Callback[]{new TextOutputCallback(0, "Waiting for card ...")});
                boolean found = false;
                for (int i = 20; i > 0 && !found; --i) {
                    found = terminal.waitForCardPresent(3000L);
                    System.out.print(".");
                }
                System.out.println();
                if (!found) {
                    throw new CardNotPresentException("Timeout waiting for a card!");
                }
            }
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new CardException("Could not connect to card: " + e.getMessage(), e);
        }
        return terminal.connect(protocol);
    }

    private static String getscard(String s) {
        Pattern p = Pattern.compile("SCARD_\\w+");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    public static String getExceptionMessage(Exception e) {
        String s;
        if (e.getCause() != null && e.getCause().getMessage() != null && (s = TerminalManager.getscard(e.getCause().getMessage())) != null) {
            return s;
        }
        if (e.getMessage() != null && (s = TerminalManager.getscard(e.getMessage())) != null) {
            return s;
        }
        return e.getMessage();
    }

    public static String getVersion() {
        String version;
        block26: {
            version = "unknown-development";
            try (InputStream versionfile = TerminalManager.class.getResourceAsStream("pro_version.txt");){
                if (versionfile == null) break block26;
                try (BufferedReader vinfo = new BufferedReader(new InputStreamReader(versionfile, StandardCharsets.UTF_8));){
                    version = vinfo.readLine();
                }
            }
            catch (IOException e) {
                version = "unknown-error";
            }
        }
        return version;
    }
}

