/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.HexUtils;
import apdu4j.SCard;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PinPadTerminal
implements AutoCloseable {
    private static final int CM_IOCTL_GET_FEATURE_REQUEST = SCard.CARD_CTL_CODE(3400);
    private static final Logger logger = LoggerFactory.getLogger(PinPadTerminal.class);
    private Map<FEATURE, Integer> features = new HashMap<FEATURE, Integer>();
    private boolean display = false;
    private CardTerminal t = null;
    private Card c = null;

    private PinPadTerminal(CardTerminal terminal, Card card) {
        this.t = terminal;
        this.c = card;
    }

    private static Map<FEATURE, Integer> tokenize(byte[] tlv) {
        HashMap<FEATURE, Integer> m = new HashMap<FEATURE, Integer>();
        if (tlv.length % 6 != 0) {
            throw new IllegalArgumentException("Bad response length: " + tlv.length);
        }
        for (int i = 0; i < tlv.length; i += 6) {
            int ft = tlv[i + 0] & 0xFF;
            FEATURE f = FEATURE.fromValue(ft);
            byte[] c = Arrays.copyOfRange(tlv, i + 2, i + 6);
            ByteBuffer buffer = ByteBuffer.wrap(c);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int ci = buffer.getInt();
            m.put(f, ci);
        }
        return m;
    }

    private static void parse_tlv_properties(byte[] tlv) {
        byte[] v;
        for (int i = 0; i < tlv.length; i += v.length + 2) {
            int t = tlv[i + 0] & 0xFF;
            int l = tlv[i + 1] & 0xFF;
            v = Arrays.copyOfRange(tlv, i + 2, i + 2 + l);
            System.out.println(Integer.toHexString(t) + "=" + HexUtils.bin2hex((byte[])v));
        }
    }

    public static PinPadTerminal getInstance(CardTerminal terminal) {
        PinPadTerminal p = new PinPadTerminal(terminal, null);
        return p;
    }

    public static PinPadTerminal getInstance(Card card) {
        PinPadTerminal p = new PinPadTerminal(null, card);
        return p;
    }

    private void parse_pin_properties(byte[] prop) {
        int timeout;
        int pin;
        int rows;
        int cols;
        if (prop.length == 4) {
            cols = prop[0] & 0xFF;
            rows = prop[1] & 0xFF;
            pin = prop[2] & 0xFF;
            timeout = prop[3] & 0xFF;
            if (rows > 0 && cols > 0) {
                this.display = true;
            }
        } else {
            throw new IllegalArgumentException("Bad PIN properties length: " + prop.length);
        }
        logger.debug("cols={} rows={} pin={} timeout={}", new Object[]{cols, rows, pin, timeout});
    }

    public void probe() throws CardException {
        if (this.t != null && this.c == null) {
            this.c = this.t.connect("DIRECT");
        }
        byte[] resp = this.c.transmitControlCommand(CM_IOCTL_GET_FEATURE_REQUEST, new byte[0]);
        this.features.putAll(PinPadTerminal.tokenize(resp));
        if (this.features.containsKey((Object)FEATURE.IFD_PIN_PROPERTIES) && (resp = this.c.transmitControlCommand(this.features.get((Object)FEATURE.IFD_PIN_PROPERTIES), new byte[0])) != null && resp.length > 0) {
            this.parse_pin_properties(resp);
        }
        if (this.features.containsKey((Object)FEATURE.GET_TLV_PROPERTIES) && (resp = this.c.transmitControlCommand(this.features.get((Object)FEATURE.GET_TLV_PROPERTIES), new byte[0])) != null && resp.length > 0) {
            PinPadTerminal.parse_tlv_properties(resp);
        }
    }

    public boolean canVerify() {
        return this.features.containsKey((Object)FEATURE.VERIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.VERIFY_PIN_START) && this.features.containsKey((Object)FEATURE.VERIFY_PIN_FINISH);
    }

    public boolean canModify() {
        return this.features.containsKey((Object)FEATURE.MODIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.MODIFY_PIN_START) && this.features.containsKey((Object)FEATURE.MODIFY_PIN_FINISH);
    }

    public boolean hasDisplay() {
        return this.display;
    }

    @Override
    public void close() throws CardException {
        if (this.t != null && this.c != null) {
            this.c.disconnect(false);
        }
    }

    public static enum FEATURE {
        VERIFY_PIN_START(1),
        VERIFY_PIN_FINISH(2),
        MODIFY_PIN_START(3),
        MODIFY_PIN_FINISH(4),
        GET_KEY_PRESSED(5),
        VERIFY_PIN_DIRECT(6),
        MODIFY_PIN_DIRECT(7),
        MCT_READERDIRECT(8),
        MCT_UNIVERSAL(9),
        IFD_PIN_PROPERTIES(10),
        ABORT(11),
        SET_SPE_MESSAGE(12),
        VERIFY_PIN_DIRECT_APP_ID(13),
        MODIFY_PIN_DIRECT_APP_ID(14),
        WRITE_DISPLAY(15),
        GET_KEY(16),
        IFD_DISPLAY_PROPERTIES(17),
        GET_TLV_PROPERTIES(18),
        CCID_ESC_COMMAND(19),
        EXECUTE_PACE(32);

        private final int value;

        private FEATURE(int value) {
            this.value = value;
        }

        public static FEATURE fromValue(int v) {
            for (FEATURE f : FEATURE.values()) {
                if (f.value != v) continue;
                return f;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

