/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.APDUBIBO;
import apdu4j.BIBO;
import apdu4j.TagRemovedException;
import apdu4j.TerminalManager;
import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;

public class CardChannelBIBO
implements BIBO {
    private final CardChannel channel;

    private CardChannelBIBO(CardChannel channel) {
        this.channel = channel;
    }

    public static APDUBIBO getBIBO(CardChannel channel) {
        return new APDUBIBO((BIBO)new CardChannelBIBO(channel));
    }

    public byte[] transceive(byte[] bytes) throws IOException {
        try {
            return this.channel.transmit(new CommandAPDU(bytes)).getBytes();
        }
        catch (CardException e) {
            String r = TerminalManager.getExceptionMessage(e);
            if (r.equals("SCARD_E_NOT_TRANSACTED") || r.equals("SCARD_E_NO_SMARTCARD")) {
                throw new TagRemovedException(r, (Throwable)e);
            }
            throw new IOException("Transmit failed: " + e.getMessage(), e);
        }
    }
}

