/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import java.util.Arrays;

public class ResponseAPDU {
    final byte[] apdu;

    public ResponseAPDU(byte[] bytes) {
        if (bytes.length < 2) {
            throw new IllegalArgumentException("APDU must be at least 2 bytes!");
        }
        this.apdu = (byte[])bytes.clone();
    }

    public int getSW1() {
        return this.apdu[this.apdu.length - 2] & 0xFF;
    }

    public int getSW2() {
        return this.apdu[this.apdu.length - 1] & 0xFF;
    }

    public int getSW() {
        return this.getSW1() << 8 | this.getSW2();
    }

    public byte[] getData() {
        return Arrays.copyOf(this.apdu, this.apdu.length - 2);
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }
}

