/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import apdu4j.APDUBIBO;
import apdu4j.CommandAPDU;
import apdu4j.ResponseAPDU;
import java.io.IOException;

public class GetResponseWrapper
extends APDUBIBO {
    public GetResponseWrapper(APDUBIBO bibo) {
        super(bibo);
    }

    @Override
    public ResponseAPDU transmit(CommandAPDU command) throws IOException {
        byte[] response = new byte[]{};
        for (int i = 0; i < 32; ++i) {
            ResponseAPDU r = super.transmit(command);
            response = GetResponseWrapper.concatenate(response, r.getData());
            if (r.getSW1() != 97) {
                response = GetResponseWrapper.concatenate(response, {(byte)r.getSW1(), (byte)r.getSW2()});
                break;
            }
            command = new CommandAPDU(command.getCLA(), 192, 0, 0, r.getSW2() == 0 ? 256 : r.getSW2());
        }
        return new ResponseAPDU(response);
    }

    static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }
}

