/*
 * Decompiled with CFR 0.152.
 */
package apdu4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CommandAPDU2 {
    private int nc;
    private int ne;
    private final byte[] data;
    private byte[] apdu;

    public int getCLA() {
        return this.apdu[0] & 0xFF;
    }

    public int getP1() {
        return this.apdu[2] & 0xFF;
    }

    public int getP2() {
        return this.apdu[3] & 0xFF;
    }

    public int getINS() {
        return this.apdu[1] & 0xFF;
    }

    public int getNe() {
        return this.ne;
    }

    public int getNc() {
        return this.nc;
    }

    public byte[] getData() {
        if (this.data == null) {
            return new byte[0];
        }
        return (byte[])this.data.clone();
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public CommandAPDU2(int cla, int ins, int p1, int p2) {
        this.data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(cla);
        bos.write(ins);
        bos.write(p1);
        bos.write(p2);
        this.apdu = bos.toByteArray();
    }

    public CommandAPDU2(int cla, int ins, int p1, int p2, byte[] data, int le) {
        this.data = (byte[])data.clone();
        this.ne = le;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(cla);
            bos.write(ins);
            bos.write(p1);
            bos.write(p2);
            bos.write(this.data.length);
            bos.write(this.data);
            bos.write(le);
            this.apdu = bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CommandAPDU2(byte[] bytes) {
        this.data = null;
        this.apdu = (byte[])bytes.clone();
    }

    public CommandAPDU2(int cla, int ins, int p1, int p2, byte[] data) {
        this.data = (byte[])data.clone();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(cla);
            bos.write(ins);
            bos.write(p1);
            bos.write(p2);
            bos.write(data.length);
            bos.write(data);
            this.apdu = bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CommandAPDU2(int cla, int ins, int p1, int p2, int le) {
        this.data = null;
        this.ne = le;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(cla);
        bos.write(ins);
        bos.write(p1);
        bos.write(p2);
        bos.write(le);
        this.apdu = bos.toByteArray();
    }
}

