/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathclassloader;

import com.github.marschall.pathclassloader.PathURLStreamHandler;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PathClassLoader
extends ClassLoader {
    private final Path path;

    public PathClassLoader(Path path) {
        this(path, null);
    }

    public PathClassLoader(Path path, ClassLoader parent) {
        super(parent);
        this.path = path;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Path clazz = this.path.resolve(name.replace('.', '/').concat(".class")).normalize();
        if (!clazz.startsWith(this.path)) {
            throw new ClassNotFoundException();
        }
        if (Files.exists(clazz, new LinkOption[0])) {
            try {
                byte[] byteCode = Files.readAllBytes(clazz);
                return this.defineClass(name, byteCode, 0, byteCode.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        Path resolved = this.path.resolve(name).normalize();
        if (!resolved.startsWith(this.path)) {
            return null;
        }
        if (Files.exists(resolved, new LinkOption[0])) {
            try {
                return this.toURL(resolved);
            }
            catch (IOException e) {
                throw new RuntimeException("could not open " + resolved, e);
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Path resolved = this.path.resolve(name).normalize();
        if (!resolved.startsWith(this.path)) {
            return Collections.emptyEnumeration();
        }
        if (Files.exists(resolved, new LinkOption[0])) {
            try {
                return new SingletonEnumeration<URL>(this.toURL(resolved));
            }
            catch (IOException e) {
                throw new RuntimeException("could not open " + resolved, e);
            }
        }
        return Collections.emptyEnumeration();
    }

    private URL toURL(Path path) throws IOException {
        return new URL(null, path.toUri().toString(), PathURLStreamHandler.INSTANCE);
    }

    static {
        PathClassLoader.registerAsParallelCapable();
    }

    static final class SingletonEnumeration<E>
    implements Enumeration<E> {
        private boolean hasMoreElements;
        private final E element;

        SingletonEnumeration(E element) {
            this.element = element;
            this.hasMoreElements = true;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMoreElements;
        }

        @Override
        public E nextElement() {
            if (!this.hasMoreElements) {
                throw new NoSuchElementException();
            }
            this.hasMoreElements = false;
            return this.element;
        }

        @Override
        public Iterator<E> asIterator() {
            if (this.hasMoreElements) {
                return Collections.singleton(this.element).iterator();
            }
            return Collections.emptyIterator();
        }
    }
}

