/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.pathclassloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

final class PathURLConnection
extends URLConnection {
    private final Path path;

    PathURLConnection(URL url, Path path) {
        super(url);
        this.path = path;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public long getContentLengthLong() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException("could not get size of: " + this.path, e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public String getContentType() {
        try {
            return Files.probeContentType(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException("could not get content type of: " + this.path, e);
        }
    }

    @Override
    public long getLastModified() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
            return attributes.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException("could not get last modified time of: " + this.path, e);
        }
    }
}

