/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.nativebytebuffers.benchmarks;

import com.github.marschall.nativebytebuffers.Stdlib;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
public class SmallAllocationBenchmarks {
    @Param(value={"1024", "4096", "1048576"})
    public int allocationSize;

    @Benchmark
    public ByteBuffer allocateDirect() {
        return ByteBuffer.allocateDirect(this.allocationSize);
    }

    @Benchmark
    public void malloc(Blackhole blackhole) {
        ByteBuffer buffer = Stdlib.malloc(this.allocationSize);
        blackhole.consume(buffer);
        Stdlib.free(buffer);
    }
}

