/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.BlockChannel;
import com.github.marschall.memoryfilesystem.MemoryFileLock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

final class AsynchronousBlockChannel
extends AsynchronousFileChannel {
    private final BlockChannel delegate;
    private final ExecutorService workExecutor;
    private final ExecutorService callbackExecutor;

    AsynchronousBlockChannel(BlockChannel delegate, ExecutorService workExecutor, ExecutorService callbackExecutor) {
        this.delegate = delegate;
        this.workExecutor = workExecutor;
        this.callbackExecutor = callbackExecutor;
    }

    private <A> void failed(Throwable exception, A attachment, CompletionHandler<?, ? super A> handler) {
        this.callbackExecutor.submit(() -> handler.failed(exception, (Object)attachment));
    }

    private <V, A> void completed(V result, A attachment, CompletionHandler<V, ? super A> handler) {
        this.callbackExecutor.submit(() -> handler.completed(result, (Object)attachment));
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size();
    }

    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        this.delegate.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    @Override
    public <A> void lock(long position, long size, boolean shared, A attachment, CompletionHandler<FileLock, ? super A> handler) {
        this.workExecutor.submit(() -> {
            try {
                MemoryFileLock l = new MemoryFileLock(this, position, size, shared);
                MemoryFileLock lock = this.delegate.lock(l);
                this.completed(lock, attachment, handler);
            }
            catch (IOException | RuntimeException e) {
                this.failed(e, attachment, handler);
            }
        });
    }

    @Override
    public Future<FileLock> lock(long position, long size, boolean shared) {
        return this.workExecutor.submit(() -> {
            MemoryFileLock l = new MemoryFileLock(this, position, size, shared);
            return this.delegate.lock(l);
        });
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.delegate.tryLock(position, size, shared);
    }

    @Override
    public <A> void read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.workExecutor.submit(() -> {
            try {
                int read = this.delegate.read(dst, position);
                this.completed(read, attachment, handler);
            }
            catch (IOException | RuntimeException e) {
                this.failed(e, attachment, handler);
            }
        });
    }

    @Override
    public Future<Integer> read(ByteBuffer dst, long position) {
        return this.workExecutor.submit(() -> this.delegate.read(dst, position));
    }

    @Override
    public <A> void write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.workExecutor.submit(() -> {
            try {
                int written = this.delegate.write(src, position);
                this.completed(written, attachment, handler);
            }
            catch (IOException | RuntimeException e) {
                this.failed(e, attachment, handler);
            }
        });
    }

    @Override
    public Future<Integer> write(ByteBuffer src, long position) {
        return this.workExecutor.submit(() -> this.delegate.write(src, position));
    }
}

